/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -1569492065407109019L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowDetailsPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSelectionModel selectionModel;
    private JLabel lblGenres;
    private JLabel lblCertification;
    private LinkLabel lblThetvdbId;
    private LinkLabel lblImdbId;
    private LinkLabel lblPath;
    private JLabel lblPremiered;
    private JLabel lblStudio;
    private JLabel lblStatus;
    private JLabel lblYear;
    private JLabel lblTags;

    public TvShowDetailsPanel(TvShowSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"25px"), ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"25px"), ColumnSpec.decode((String)"default:grow(2)")}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblPremieredT = new JLabel(BUNDLE.getString("metatag.premiered"));
        this.setBoldLabel(lblPremieredT);
        this.add((Component)lblPremieredT, "1, 2");
        this.lblPremiered = new JLabel("");
        this.add((Component)this.lblPremiered, "3, 2");
        JLabel lblYearT = new JLabel(BUNDLE.getString("metatag.year"));
        this.setBoldLabel(lblYearT);
        this.add((Component)lblYearT, "5, 2");
        this.lblYear = new JLabel("");
        this.add((Component)this.lblYear, "7, 2");
        JLabel lblStatusT = new JLabel(BUNDLE.getString("metatag.status"));
        this.setBoldLabel(lblStatusT);
        this.add((Component)lblStatusT, "1, 4");
        this.lblStatus = new JLabel("");
        this.add((Component)this.lblStatus, "3, 4");
        JLabel lblImdbIdT = new JLabel("IMDB Id");
        this.setBoldLabel(lblImdbIdT);
        this.add((Component)lblImdbIdT, "5, 4");
        this.lblImdbId = new LinkLabel("");
        this.lblImdbId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String url = "http://www.imdb.com/title/" + TvShowDetailsPanel.this.lblImdbId.getNormalText();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e) {
                    LOGGER.error("browse to imdbid", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.add((Component)this.lblImdbId, "7, 4");
        lblImdbIdT.setLabelFor(this.lblImdbId);
        JLabel lblStudioT = new JLabel(BUNDLE.getString("metatag.studio"));
        this.setBoldLabel(lblStudioT);
        this.add((Component)lblStudioT, "1, 6");
        this.lblStudio = new JLabel("");
        this.add((Component)this.lblStudio, "3, 6");
        JLabel lblThetvdbIdT = new JLabel("TheTVDB Id");
        this.setBoldLabel(lblThetvdbIdT);
        this.add((Component)lblThetvdbIdT, "5, 6");
        this.lblThetvdbId = new LinkLabel("");
        this.lblThetvdbId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String url = "http://thetvdb.com/?tab=series&id=" + TvShowDetailsPanel.this.lblThetvdbId.getNormalText();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e) {
                    LOGGER.error("browse to thetvdb", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.add((Component)this.lblThetvdbId, "7, 6");
        lblThetvdbIdT.setLabelFor(this.lblThetvdbId);
        JLabel lblCertificationT = new JLabel(BUNDLE.getString("metatag.certification"));
        this.setBoldLabel(lblCertificationT);
        this.add((Component)lblCertificationT, "1, 8");
        lblCertificationT.setLabelFor(this.lblCertification);
        this.lblCertification = new JLabel("");
        this.add((Component)this.lblCertification, "3, 8, 5, 1");
        JLabel lblGenresT = new JLabel(BUNDLE.getString("metatag.genre"));
        this.setBoldLabel(lblGenresT);
        this.add((Component)lblGenresT, "1, 10");
        lblGenresT.setLabelFor(this.lblGenres);
        this.lblGenres = new JLabel("");
        this.add((Component)this.lblGenres, "3, 10, 5, 1");
        JLabel lblTagsT = new JLabel(BUNDLE.getString("metatag.tags"));
        this.setBoldLabel(lblTagsT);
        this.add((Component)lblTagsT, "1, 12");
        lblGenresT.setLabelFor(this.lblTags);
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "3, 12, 5, 1");
        JLabel lblPathT = new JLabel(BUNDLE.getString("metatag.path"));
        this.setBoldLabel(lblPathT);
        this.add((Component)lblPathT, "1, 14");
        this.lblPath = new LinkLabel("");
        lblPathT.setLabelFor(this.lblPath);
        this.lblPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!StringUtils.isEmpty((CharSequence)TvShowDetailsPanel.this.lblPath.getNormalText())) {
                    Path path = Paths.get(TvShowDetailsPanel.this.lblPath.getNormalText(), new String[0]);
                    try {
                        if (Files.exists(path, new LinkOption[0])) {
                            TmmUIHelper.openFile(path);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("open filemanager", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            }
        });
        this.add((Component)this.lblPath, "3, 14, 5, 1");
        this.initDataBindings();
    }

    private void setBoldLabel(JLabel label) {
        label.setFont(label.getFont().deriveFont(1));
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.tvdbId");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.lblThetvdbId, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.imdbId");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblImdbId, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShow.path");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_4, (Object)this.lblPath, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.certification.name");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.genresAsString");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.lblGenres, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShow.productionCompany");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_6, (Object)this.lblStudio, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShow.firstAiredAsString");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_7, (Object)this.lblPremiered, (Property)jLabelBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShow.status");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_5, (Object)this.lblStatus, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShow.year");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_8, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShow.tagAsString");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_9, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
    }
}

