/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.moviesets.MovieSetRootTreeNode;
import org.tinymediamanager.ui.moviesets.MovieSetTreeNode;
import org.tinymediamanager.ui.moviesets.MovieTreeNode;

public class MovieSetTreeModel
implements TreeModel {
    private MovieSetRootTreeNode root = new MovieSetRootTreeNode();
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private Map<Object, TreeNode> nodeMap = Collections.synchronizedMap(new HashMap());
    private PropertyChangeListener propertyChangeListener;
    private MovieList movieList = MovieList.getInstance();

    public MovieSetTreeModel(List<MovieSet> movieSets) {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultMutableTreeNode node;
                MovieSet movieSet;
                MovieSet movieSet2;
                Movie movie;
                if ("addedMovie".equals(evt.getPropertyName())) {
                    movie = (Movie)evt.getNewValue();
                    movieSet2 = (MovieSet)evt.getSource();
                    MovieSetTreeModel.this.addMovie(movieSet2, movie);
                }
                if ("removedMovie".equals(evt.getPropertyName())) {
                    movie = (Movie)evt.getNewValue();
                    movieSet2 = (MovieSet)evt.getSource();
                    MovieSetTreeModel.this.removeMovie(movieSet2, movie);
                }
                if ("removedAllMovies".equals(evt.getPropertyName())) {
                    List removedMovies = (List)evt.getOldValue();
                    movieSet2 = (MovieSet)evt.getSource();
                    for (Movie movie2 : removedMovies) {
                        MovieSetTreeModel.this.removeMovie(movieSet2, movie2);
                    }
                }
                if ("addedMovieSet".equals(evt.getPropertyName())) {
                    movieSet = (MovieSet)evt.getNewValue();
                    MovieSetTreeModel.this.addMovieSet(movieSet);
                }
                if ("removedMovieSet".equals(evt.getPropertyName())) {
                    movieSet = (MovieSet)evt.getNewValue();
                    MovieSetTreeModel.this.removeMovieSet(movieSet);
                }
                if ("movies".equals(evt.getPropertyName()) && evt.getSource() instanceof MovieSet) {
                    movieSet = (MovieSet)evt.getSource();
                    MovieSetTreeModel.this.sortMoviesInMovieSet(movieSet);
                }
                if ((evt.getSource() instanceof MovieSet || evt.getSource() instanceof Movie) && (node = (DefaultMutableTreeNode)MovieSetTreeModel.this.nodeMap.get(evt.getSource())) != null) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    int index = parent.getIndex(node);
                    TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{node});
                    for (TreeModelListener listener : MovieSetTreeModel.this.listeners) {
                        listener.treeNodesChanged(event);
                    }
                }
            }
        };
        for (MovieSet movieSet : movieSets) {
            MovieSetTreeNode setNode = new MovieSetTreeNode(movieSet);
            this.nodeMap.put(movieSet, setNode);
            for (Movie movie : movieSet.getMovies()) {
                MovieTreeNode movieNode = new MovieTreeNode(movie);
                setNode.add(movieNode);
                this.nodeMap.put(movie, movieNode);
            }
            this.root.add(setNode);
            movieSet.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.movieList.addPropertyChangeListener(this.propertyChangeListener);
        this.root.sort();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        MovieSetTreeNode mstnode;
        if (node == this.root) {
            return false;
        }
        if (node instanceof MovieSetTreeNode && (mstnode = (MovieSetTreeNode)node).getUserObject() instanceof MovieSet) {
            return false;
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovieSet(MovieSet movieSet) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            MovieSetTreeNode child = new MovieSetTreeNode(movieSet);
            this.nodeMap.put(movieSet, child);
            this.root.add(child);
            this.root.sort();
            int index = this.root.getIndex(child);
            TreeModelEvent event = new TreeModelEvent((Object)this, this.root.getPath(), new int[]{index}, new Object[]{child});
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(event);
            }
        }
        movieSet.addPropertyChangeListener(this.propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMovie(MovieSet movieSet, Movie movie) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            MovieSetTreeNode parent = (MovieSetTreeNode)this.nodeMap.get(movieSet);
            MovieTreeNode child = new MovieTreeNode(movie);
            if (parent != null) {
                this.nodeMap.put(movie, child);
                parent.add(child);
                int index = parent.getIndex(child);
                TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                for (TreeModelListener listener : this.listeners) {
                    listener.treeNodesInserted(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMovie(MovieSet movieSet, Movie movie) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            MovieSetTreeNode parent = (MovieSetTreeNode)this.nodeMap.get(movieSet);
            MovieTreeNode child = (MovieTreeNode)this.nodeMap.get(movie);
            if (parent != null && child != null && parent.isNodeChild(child)) {
                int index = parent.getIndex(child);
                parent.remove(child);
                this.nodeMap.remove(movie);
                TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                for (TreeModelListener listener : this.listeners) {
                    listener.treeNodesRemoved(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovieSet(MovieSet movieSet) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            MovieSetTreeNode node = (MovieSetTreeNode)this.nodeMap.get(movieSet);
            int index = this.root.getIndex(node);
            movieSet.removePropertyChangeListener(this.propertyChangeListener);
            this.nodeMap.remove(movieSet);
            for (Movie movie : movieSet.getMovies()) {
                this.nodeMap.remove(movie);
                movie.removePropertyChangeListener(this.propertyChangeListener);
            }
            node.removeAllChildren();
            node.removeFromParent();
            TreeModelEvent event = new TreeModelEvent((Object)this, this.root.getPath(), new int[]{index}, new Object[]{node});
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TreePath path) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)path.getParentPath().getLastPathComponent();
            int index = parent.getIndex(node);
            if (node.getUserObject() instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)node.getUserObject();
                for (Movie movie : movieSet.getMovies()) {
                    movie.setMovieSet(null);
                    movie.writeNFO();
                    movie.saveToDb();
                    this.nodeMap.remove(movie);
                }
                movieSet.removeAllMovies();
                movieSet.removePropertyChangeListener(this.propertyChangeListener);
                this.movieList.removeMovieSet(movieSet);
                this.nodeMap.remove(movieSet);
                node.removeAllChildren();
                node.removeFromParent();
                TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{node});
                for (TreeModelListener listener : this.listeners) {
                    listener.treeNodesRemoved(event);
                }
            }
            if (node.getUserObject() instanceof Movie) {
                Movie movie = (Movie)node.getUserObject();
                MovieSet movieSet = movie.getMovieSet();
                if (movieSet != null) {
                    movieSet.removeMovie(movie, true);
                }
                this.nodeMap.remove(movie);
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortMoviesInMovieSet(MovieSet movieSet) {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            MovieSetTreeNode node = (MovieSetTreeNode)this.nodeMap.get(movieSet);
            node.sort();
            TreeModelEvent event = new TreeModelEvent((Object)this, node.getPath());
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortMovieSets() {
        MovieSetRootTreeNode movieSetRootTreeNode = this.root;
        synchronized (movieSetRootTreeNode) {
            this.root.sort();
            TreeModelEvent event = new TreeModelEvent((Object)this, this.root.getPath());
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }
}

