/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;

public class MovieBatchEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -8515248604267310279L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieList movieList = MovieList.getInstance();
    private List<Movie> moviesToEdit;
    private boolean changed = false;
    private JComboBox cbGenres;
    private JComboBox cbTags;
    private JComboBox cbMovieSet;
    private JCheckBox chckbxWatched;
    private JTextField tfLanguage;

    public MovieBatchEditorDialog(List<Movie> movies) {
        super(BUNDLE.getString("movie.edit"), "movieBatchEditor");
        this.setBounds(5, 5, 350, 230);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblGenres = new JLabel(BUNDLE.getString("metatag.genre"));
        panelContent.add((Component)lblGenres, "2, 2, 2, 1, right, default");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenres.setEditable(true);
        panelContent.add((Component)this.cbGenres, "5, 2, fill, default");
        JButton btnAddGenre = new JButton("");
        btnAddGenre.setIcon(IconManager.LIST_ADD);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        btnAddGenre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MediaGenres genre = null;
                Object item = MovieBatchEditorDialog.this.cbGenres.getSelectedItem();
                if (item instanceof MediaGenres) {
                    genre = (MediaGenres)item;
                }
                if (item instanceof String) {
                    genre = MediaGenres.getGenre((String)((String)item));
                }
                if (genre != null) {
                    for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                        movie.addGenre(genre);
                    }
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnAddGenre, "7, 2");
        JButton btnRemoveGenre = new JButton("");
        btnRemoveGenre.setIcon(IconManager.LIST_REMOVE);
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveGenre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MediaGenres genre = (MediaGenres)MovieBatchEditorDialog.this.cbGenres.getSelectedItem();
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.removeGenre(genre);
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveGenre, "9, 2");
        JLabel lblTags = new JLabel(BUNDLE.getString("metatag.tags"));
        panelContent.add((Component)lblTags, "2, 4, 2, 1, right, default");
        this.cbTags = new AutocompleteComboBox<Object>(this.movieList.getTagsInMovies().toArray());
        this.cbTags.setEditable(true);
        panelContent.add((Component)this.cbTags, "5, 4, fill, default");
        JButton btnAddTag = new JButton("");
        btnAddTag.setIcon(IconManager.LIST_ADD);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        btnAddTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)MovieBatchEditorDialog.this.cbTags.getSelectedItem();
                if (StringUtils.isBlank((CharSequence)tag)) {
                    return;
                }
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.addToTags(tag);
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnAddTag, "7, 4");
        JButton btnRemoveTag = new JButton("");
        btnRemoveTag.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)MovieBatchEditorDialog.this.cbTags.getSelectedItem();
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.removeFromTags(tag);
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveTag, "9, 4");
        JLabel lblCertification = new JLabel(BUNDLE.getString("metatag.certification"));
        panelContent.add((Component)lblCertification, "2, 6, 2, 1, right, default");
        final JComboBox<Certification> cbCertification = new JComboBox<Certification>();
        for (Certification cert : Certification.getCertificationsforCountry((CountryCode)MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry())) {
            cbCertification.addItem(cert);
        }
        panelContent.add(cbCertification, "5, 6, fill, default");
        JButton btnCertification = new JButton("");
        btnCertification.setMargin(new Insets(2, 2, 2, 2));
        btnCertification.setIcon(IconManager.APPLY);
        btnCertification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                Certification cert = (Certification)cbCertification.getSelectedItem();
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setCertification(cert);
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnCertification, "7, 6");
        JLabel lblMovieSet = new JLabel(BUNDLE.getString("metatag.movieset"));
        panelContent.add((Component)lblMovieSet, "2, 8, 2, 1, right, default");
        this.cbMovieSet = new JComboBox();
        panelContent.add((Component)this.cbMovieSet, "5, 8, fill, default");
        JButton btnSetMovieSet = new JButton("");
        btnSetMovieSet.setMargin(new Insets(2, 2, 2, 2));
        btnSetMovieSet.setIcon(IconManager.APPLY);
        btnSetMovieSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                Object obj = MovieBatchEditorDialog.this.cbMovieSet.getSelectedItem();
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    if (obj instanceof String) {
                        movie.removeFromMovieSet();
                    }
                    if (!(obj instanceof MovieSet)) continue;
                    MovieSet movieSet = (MovieSet)obj;
                    if (movie.getMovieSet() == movieSet) continue;
                    movie.removeFromMovieSet();
                    movie.setMovieSet(movieSet);
                    movieSet.insertMovie(movie);
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnSetMovieSet, "7, 8");
        JButton btnNewMovieset = new JButton("");
        btnNewMovieset.setMargin(new Insets(2, 2, 2, 2));
        btnNewMovieset.setAction(new MovieSetAddAction(false));
        panelContent.add((Component)btnNewMovieset, "9, 8");
        JLabel lblWatched = new JLabel(BUNDLE.getString("metatag.watched"));
        panelContent.add((Component)lblWatched, "2, 10, 2, 1, right, default");
        this.chckbxWatched = new JCheckBox("");
        panelContent.add((Component)this.chckbxWatched, "5, 10");
        JButton btnWatched = new JButton("");
        btnWatched.setMargin(new Insets(2, 2, 2, 2));
        btnWatched.setIcon(IconManager.APPLY);
        btnWatched.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setWatched(MovieBatchEditorDialog.this.chckbxWatched.isSelected());
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnWatched, "7, 10");
        JLabel lblVideo3D = new JLabel(BUNDLE.getString("metatag.3d"));
        panelContent.add((Component)lblVideo3D, "2, 12, 2, 1, right, default");
        final JCheckBox chckbxVideo3D = new JCheckBox("");
        panelContent.add((Component)chckbxVideo3D, "5, 12");
        JButton btnVideo3D = new JButton("");
        btnVideo3D.setMargin(new Insets(2, 2, 2, 2));
        btnVideo3D.setIcon(IconManager.APPLY);
        btnVideo3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setVideoIn3D(chckbxVideo3D.isSelected());
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnVideo3D, "7, 12");
        JLabel lblMediasource = new JLabel(BUNDLE.getString("metatag.source"));
        panelContent.add((Component)lblMediasource, "2, 14, 2, 1, right, default");
        final JComboBox<MediaSource> cbMediaSource = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSource, "5, 14, fill, default");
        JButton btnMediaSource = new JButton("");
        btnMediaSource.setMargin(new Insets(2, 2, 2, 2));
        btnMediaSource.setIcon(IconManager.APPLY);
        btnMediaSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                Object obj = cbMediaSource.getSelectedItem();
                if (obj instanceof MediaSource) {
                    MediaSource mediaSource = (MediaSource)((Object)obj);
                    MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                        movie.setMediaSource(mediaSource);
                    }
                    MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        panelContent.add((Component)btnMediaSource, "7, 14");
        JLabel lblLanguage = new JLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguage, "2, 16, 2, 1, right, default");
        this.tfLanguage = new JTextField();
        panelContent.add((Component)this.tfLanguage, "5, 16, fill, default");
        this.tfLanguage.setColumns(10);
        JButton btnLanguage = new JButton("");
        btnLanguage.setMargin(new Insets(2, 2, 2, 2));
        btnLanguage.setIcon(IconManager.APPLY);
        btnLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setSpokenLanguages(MovieBatchEditorDialog.this.tfLanguage.getText());
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnLanguage, "7, 16");
        JLabel lblSorttitleT = new JLabel(BUNDLE.getString("metatag.sorttitle"));
        panelContent.add((Component)lblSorttitleT, "2, 18, right, default");
        JButton btnSetSorttitle = new JButton(BUNDLE.getString("edit.setsorttitle"));
        btnSetSorttitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setSortTitle(movie.getTitleSortable());
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JLabel lblSorttitleInfo = new JLabel(IconManager.HINT);
        lblSorttitleInfo.setToolTipText(BUNDLE.getString("edit.setsorttitle.desc"));
        panelContent.add((Component)lblSorttitleInfo, "3, 18");
        panelContent.add((Component)btnSetSorttitle, "5, 18");
        JButton btnClearSorttitle = new JButton(BUNDLE.getString("edit.clearsorttitle"));
        btnClearSorttitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieBatchEditorDialog.this.changed = true;
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                    movie.setSortTitle("");
                }
                MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnClearSorttitle, "5, 20");
        JPanel panelButtons = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panelButtons.getLayout();
        flowLayout.setAlignment(2);
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MovieBatchEditorDialog.this.changed) {
                    MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                        movie.writeNFO();
                        movie.saveToDb();
                    }
                    MovieBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                MovieBatchEditorDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MovieBatchEditorDialog.this.changed) {
                    for (Movie movie : MovieBatchEditorDialog.this.moviesToEdit) {
                        movie.writeNFO();
                        movie.saveToDb();
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
                        SyncTraktTvTask task = new SyncTraktTvTask(MovieBatchEditorDialog.this.moviesToEdit, null);
                        TmmTaskManager.getInstance().addUnnamedTask(task);
                    }
                }
            }
        });
        this.setMovieSets();
        this.moviesToEdit = movies;
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("addedMovieSet".equals(evt.getPropertyName())) {
                    MovieBatchEditorDialog.this.setMovieSets();
                }
            }
        };
        this.movieList.addPropertyChangeListener(listener);
    }

    private void setMovieSets() {
        MovieSet selectedMovieSet = null;
        Object obj = this.cbMovieSet.getSelectedItem();
        if (obj instanceof MovieSet) {
            selectedMovieSet = (MovieSet)obj;
        }
        this.cbMovieSet.removeAllItems();
        this.cbMovieSet.addItem("");
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
        }
        if (selectedMovieSet != null) {
            this.cbMovieSet.setSelectedItem(selectedMovieSet);
        }
    }
}

