/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieClearImageCacheAction
extends AbstractAction {
    private static final long serialVersionUID = -5089957097690621345L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieClearImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("movie.clearimagecache"));
        this.putValue("SwingLargeIconKey", "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        MainWindow.getActiveInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (Movie movie : selectedMovies) {
            ImageCache.clearImageCacheForMediaEntity(movie);
        }
        MainWindow.getActiveInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

