/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.MediaInfoAudioCodecConverter;
import org.tinymediamanager.ui.converter.MediaInfoVideoCodecConverter;
import org.tinymediamanager.ui.converter.MediaInfoVideoFormatConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.converter.WatchedIconConverter2;
import org.tinymediamanager.ui.movies.MovieActorPanel;
import org.tinymediamanager.ui.movies.MovieCrewPanel;
import org.tinymediamanager.ui.movies.MovieDetailsPanel;
import org.tinymediamanager.ui.movies.MovieGenresPanel;
import org.tinymediamanager.ui.movies.MovieMediaFilesPanel;
import org.tinymediamanager.ui.movies.MovieMediaInformationPanel;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.MovieTrailerPanel;
import org.tinymediamanager.ui.panels.ImagePanel;

public class MovieInformationPanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final long serialVersionUID = -8527284262749511617L;
    private JSplitPane splitPaneVertical;
    private JPanel panelTop;
    private JPanel panelMovieLogos;
    private StarRater panelRatingStars;
    private JLabel lblWatchedImage;
    private JLabel lblMovieName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblTagline;
    private JLabel lblCertificationImage;
    private ImageLabel lblMovieBackground;
    private ImageLabel lblMoviePoster;
    private JTabbedPane tabbedPaneMovieDetails;
    private JPanel panelOverview;
    private MovieCrewPanel panelMovieCrew;
    private JPanel panelDetails;
    private JTextPane tpOverview;
    private JPanel panelMediaInformation;
    private JPanel panelMediaFiles;
    private MovieTrailerPanel panelMovieTrailer;
    private MovieSelectionModel movieSelectionModel;
    private JLabel lblMediaLogoResolution;
    private JLabel lblMediaLogoVideoCodec;
    private JLabel lblMediaLogoAudio;
    private JLabel lblTop250;

    public MovieInformationPanel(MovieSelectionModel movieSelectionModel) {
        this.movieSelectionModel = movieSelectionModel;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"450px:grow")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.splitPaneVertical = new JSplitPane();
        this.splitPaneVertical.setBorder(null);
        this.splitPaneVertical.setResizeWeight(0.9);
        this.splitPaneVertical.setContinuousLayout(true);
        this.splitPaneVertical.setOneTouchExpandable(true);
        this.splitPaneVertical.setOrientation(0);
        this.add((Component)this.splitPaneVertical, "1, 1, fill, fill");
        this.panelTop = new JPanel();
        this.panelTop.setBorder(null);
        this.splitPaneVertical.setTopComponent(this.panelTop);
        this.panelTop.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"fill:default"), RowSpec.decode((String)"top:100dlu:grow")}));
        JPanel panelMovieHeader = new JPanel();
        this.panelTop.add((Component)panelMovieHeader, "2, 1, 3, 1, fill, top");
        panelMovieHeader.setBorder(null);
        panelMovieHeader.setLayout(new BorderLayout(0, 0));
        JPanel panelMovieTitle = new JPanel();
        panelMovieHeader.add((Component)panelMovieTitle, "North");
        panelMovieTitle.setLayout(new BorderLayout(0, 0));
        this.lblMovieName = new JLabel("");
        TmmFontHelper.changeFont(this.lblMovieName, 1.33, 1);
        panelMovieTitle.add(this.lblMovieName);
        JPanel panelRatingTagline = new JPanel();
        panelMovieHeader.add((Component)panelRatingTagline, "Center");
        panelRatingTagline.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"24px"), FormFactory.DEFAULT_ROWSPEC}));
        this.lblRating = new JLabel("");
        panelRatingTagline.add((Component)this.lblRating, "2, 2, left, center");
        this.lblVoteCount = new JLabel("");
        panelRatingTagline.add((Component)this.lblVoteCount, "3, 2, left, center");
        this.panelRatingStars = new StarRater(10, 1);
        panelRatingTagline.add((Component)this.panelRatingStars, "1, 2, left, top");
        this.panelRatingStars.setEnabled(false);
        this.lblTop250 = new JLabel("");
        panelRatingTagline.add((Component)this.lblTop250, "5, 2, left, default");
        this.lblTagline = new JLabel();
        panelRatingTagline.add((Component)this.lblTagline, "1, 3, 5, 1, default, center");
        this.panelMovieLogos = new JPanel();
        panelMovieHeader.add((Component)this.panelMovieLogos, "East");
        this.lblCertificationImage = new JLabel();
        this.panelMovieLogos.add(this.lblCertificationImage);
        JLayeredPane layeredPaneImages = new JLayeredPane();
        this.panelTop.add((Component)layeredPaneImages, "1, 2, 4, 1, fill, fill");
        layeredPaneImages.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(10px;default)"), ColumnSpec.decode((String)"left:120px:grow"), ColumnSpec.decode((String)"default:grow(10)")}, new RowSpec[]{RowSpec.decode((String)"max(10px;default)"), RowSpec.decode((String)"top:180px:grow"), RowSpec.decode((String)"fill:80px:grow(3)")}));
        this.lblMovieBackground = new ImageLabel(false, true);
        this.lblMovieBackground.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblMovieBackground.enableLightbox();
        layeredPaneImages.add((Component)this.lblMovieBackground, "1, 1, 3, 3, fill, fill");
        this.lblMoviePoster = new ImageLabel();
        this.lblMoviePoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblMoviePoster.enableLightbox();
        layeredPaneImages.setLayer(this.lblMoviePoster, 1);
        layeredPaneImages.add((Component)this.lblMoviePoster, "2, 2, fill, fill");
        this.lblWatchedImage = new JLabel();
        this.lblWatchedImage.setOpaque(false);
        layeredPaneImages.setLayer(this.lblWatchedImage, 2);
        layeredPaneImages.add((Component)this.lblWatchedImage, "2, 2, left, top");
        MovieGenresPanel panelGenres = new MovieGenresPanel(movieSelectionModel);
        layeredPaneImages.setLayer(panelGenres, 2);
        layeredPaneImages.add((Component)panelGenres, "2, 2, 2, 2, right, bottom");
        JPanel panelLogos = new JPanel();
        panelLogos.setOpaque(false);
        layeredPaneImages.setLayer(panelLogos, 2);
        layeredPaneImages.add((Component)panelLogos, "2, 2, 2, 2, right, top");
        panelLogos.setLayout(new FlowLayout(1, 5, 5));
        this.lblMediaLogoResolution = new JLabel("");
        panelLogos.add(this.lblMediaLogoResolution);
        this.lblMediaLogoVideoCodec = new JLabel("");
        panelLogos.add(this.lblMediaLogoVideoCodec);
        this.lblMediaLogoAudio = new JLabel("");
        panelLogos.add(this.lblMediaLogoAudio);
        JPanel panelBottom = new JPanel();
        panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"300px:grow")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        this.tabbedPaneMovieDetails = new JTabbedPane(1);
        panelBottom.add((Component)this.tabbedPaneMovieDetails, "1, 2, fill, fill");
        this.splitPaneVertical.setBottomComponent(panelBottom);
        this.panelDetails = new MovieDetailsPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.details"), null, this.panelDetails, null);
        this.panelOverview = new JPanel();
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.plot"), null, this.panelOverview, null);
        this.panelOverview.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        JScrollPane scrollPaneOverview = new JScrollPane();
        scrollPaneOverview.setBorder(null);
        this.panelOverview.add((Component)scrollPaneOverview, "1, 2, fill, fill");
        this.tpOverview = new JTextPane();
        this.tpOverview.setOpaque(false);
        this.tpOverview.setEditable(false);
        scrollPaneOverview.setViewportView(this.tpOverview);
        this.panelMovieCrew = new MovieCrewPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.crew"), null, this.panelMovieCrew, null);
        MovieActorPanel panelMovieActors = new MovieActorPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.cast"), null, panelMovieActors, null);
        this.panelMediaInformation = new MovieMediaInformationPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.mediainformation"), null, this.panelMediaInformation, null);
        this.panelMediaFiles = new MovieMediaFilesPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.panelMediaFiles, null);
        final ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        final ImagePanel panelArtwork = new ImagePanel(mediaFiles);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.artwork"), null, panelArtwork, null);
        this.panelMovieTrailer = new MovieTrailerPanel(movieSelectionModel);
        this.tabbedPaneMovieDetails.addTab(BUNDLE.getString("metatag.trailer"), null, this.panelMovieTrailer, null);
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Movie movie;
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source instanceof MovieSelectionModel || source instanceof Movie && "mediaFiles".equals(property)) {
                    movie = null;
                    if (source instanceof MovieSelectionModel) {
                        movie = ((MovieSelectionModel)source).getSelectedMovie();
                    }
                    if (source instanceof Movie) {
                        movie = (Movie)source;
                    }
                    if (movie != null) {
                        if (movie.getTop250() > 0) {
                            MovieInformationPanel.this.lblTop250.setText("Top 250: #" + movie.getTop250());
                        } else {
                            MovieInformationPanel.this.lblTop250.setText("");
                        }
                        MovieInformationPanel.this.lblMovieBackground.setImagePath(movie.getArtworkFilename(MediaFileType.FANART));
                        MovieInformationPanel.this.lblMoviePoster.setImagePath(movie.getArtworkFilename(MediaFileType.POSTER));
                        List list = mediaFiles;
                        synchronized (list) {
                            mediaFiles.clear();
                            for (MediaFile mediafile : movie.getMediaFiles()) {
                                if (!mediafile.isGraphic()) continue;
                                mediaFiles.add(mediafile);
                            }
                            panelArtwork.rebuildPanel();
                        }
                    }
                }
                if (source.getClass() == Movie.class && "fanart".equals(property)) {
                    movie = (Movie)source;
                    MovieInformationPanel.this.lblMovieBackground.clearImage();
                    MovieInformationPanel.this.lblMovieBackground.setImagePath(movie.getArtworkFilename(MediaFileType.FANART));
                }
                if (source.getClass() == Movie.class && "poster".equals(property)) {
                    movie = (Movie)source;
                    MovieInformationPanel.this.lblMoviePoster.clearImage();
                    MovieInformationPanel.this.lblMoviePoster.setImagePath(movie.getArtworkFilename(MediaFileType.POSTER));
                }
                if (source.getClass() == Movie.class && "top250".equals(property)) {
                    movie = (Movie)source;
                    if (movie.getTop250() > 0) {
                        MovieInformationPanel.this.lblTop250.setText(BUNDLE.getString("metatag.top250") + ": #" + movie.getTop250());
                    } else {
                        MovieInformationPanel.this.lblTop250.setText("");
                    }
                }
            }
        };
        movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    public JSplitPane getSplitPaneVertical() {
        return this.splitPaneVertical;
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.titleForUi");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblMovieName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.rating");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedMovie.plot");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_14, (Object)this.tpOverview, (Property)jTextPaneBeanProperty);
        autoBinding_15.bind();
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.votes");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_2.setConverter((Converter)new VoteCountConverter());
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.certification");
        BeanProperty jLabelBeanProperty_2 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblCertificationImage, (Property)jLabelBeanProperty_2);
        autoBinding_7.setConverter((Converter)new CertificationImageConverter());
        autoBinding_7.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.tagline");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblTagline, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedMovie.watched");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_7, (Object)this.lblWatchedImage, (Property)jLabelBeanProperty_2);
        autoBinding_8.setConverter((Converter)new WatchedIconConverter2());
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedMovie.mediaInfoVideoFormat");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_9, (Object)this.lblMediaLogoResolution, (Property)jLabelBeanProperty_2);
        autoBinding_11.setConverter((Converter)new MediaInfoVideoFormatConverter());
        autoBinding_11.bind();
        BeanProperty movieSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedMovie.mediaInfoVideoCodec");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_10, (Object)this.lblMediaLogoVideoCodec, (Property)jLabelBeanProperty_2);
        autoBinding_12.setConverter((Converter)new MediaInfoVideoCodecConverter());
        autoBinding_12.bind();
        BeanProperty movieSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedMovie.mediaInfoAudioCodecAndChannels");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_11, (Object)this.lblMediaLogoAudio, (Property)jLabelBeanProperty_2);
        autoBinding_13.setConverter((Converter)new MediaInfoAudioCodecConverter());
        autoBinding_13.bind();
    }
}

