/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MessagePanel;

public class MessageHistoryDialog
extends TmmDialog
implements ListEventListener<Message> {
    private static final long serialVersionUID = -5054005564554148578L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static MessageHistoryDialog instance;
    private Map<Message, JPanel> messageMap;
    private JPanel messagesPanel;
    private JScrollPane scrollPane;

    private MessageHistoryDialog() {
        super(MainWindow.getActiveInstance(), BUNDLE.getString("summarywindow.title"), "messageSummary");
        this.setModal(false);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.messageMap = new HashMap<Message, JPanel>();
        this.getContentPane().setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"300dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"150dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.scrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.scrollPane, "2, 2, fill, fill");
        this.messagesPanel = new JPanel();
        this.messagesPanel.setBackground(Color.WHITE);
        this.messagesPanel.setLayout(new BoxLayout(this.messagesPanel, 3));
        this.scrollPane.setViewportView(this.messagesPanel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        this.getContentPane().add((Component)panelButtons, "2, 4, fill, fill");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        panelButtons.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MessageHistoryDialog.this.setVisible(false);
            }
        });
        TmmUIMessageCollector.instance.getMessages().addListEventListener((ListEventListener)this);
        this.updatePanel();
    }

    public static MessageHistoryDialog getInstance() {
        if (instance == null) {
            instance = new MessageHistoryDialog();
        }
        return instance;
    }

    @Override
    public void setVisible(boolean visible) {
        TmmUIMessageCollector.instance.resetNewMessageCount();
        if (visible) {
            TmmWindowSaver.getInstance().loadSettings(this);
            this.pack();
            this.setLocationRelativeTo(MainWindow.getActiveInstance());
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    public void listChanged(ListEvent<Message> listChanges) {
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePanel() {
        EventList<Message> list = TmmUIMessageCollector.instance.getMessages();
        list.getReadWriteLock().readLock().lock();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Message message = (Message)list.get(i);
                if (this.messageMap.containsKey(message)) continue;
                MessagePanel panel = new MessagePanel(message);
                this.messageMap.put(message, panel);
                this.messagesPanel.add(panel);
            }
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
        }
        finally {
            list.getReadWriteLock().readLock().unlock();
        }
    }
}

