/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseSpinnerUI;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class SmallSpinnerUI
extends BaseSpinnerUI {
    private static final Dimension zeroSize = new Dimension(0, 0);
    private static final Color fieldBorderColor = new Color(127, 157, 185);
    private MyLayoutManager myLayoutManager = null;

    public static ComponentUI createUI(JComponent c) {
        return new SmallSpinnerUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.spinner.setBorder(BorderFactory.createLineBorder(fieldBorderColor));
    }

    protected LayoutManager createLayout() {
        if (this.myLayoutManager == null) {
            this.myLayoutManager = new MyLayoutManager();
        }
        return this.myLayoutManager;
    }

    protected Component createNextButton() {
        SpinButton button = new SpinButton(1);
        if (JTattooUtilities.isLeftToRight((Component)this.spinner)) {
            MatteBorder border = BorderFactory.createMatteBorder(0, 1, 1, 0, fieldBorderColor);
            ((JComponent)((Object)button)).setBorder(border);
        } else {
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 1, fieldBorderColor);
            ((JComponent)((Object)button)).setBorder(border);
        }
        this.installNextButtonListeners((Component)((Object)button));
        return button;
    }

    protected Component createPreviousButton() {
        SpinButton button = new SpinButton(5);
        if (JTattooUtilities.isLeftToRight((Component)this.spinner)) {
            MatteBorder border = BorderFactory.createMatteBorder(0, 1, 0, 0, fieldBorderColor);
            ((JComponent)((Object)button)).setBorder(border);
        } else {
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 0, 1, fieldBorderColor);
            ((JComponent)((Object)button)).setBorder(border);
        }
        this.installPreviousButtonListeners((Component)((Object)button));
        return button;
    }

    private static class MyLayoutManager
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private MyLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                this.nextButton = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int nextY = buttonInsets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = buttonInsets.top + nextHeight;
            int previousHeight = height - previousY - buttonInsets.bottom;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }

    public static class SpinButton
    extends NoFocusButton {
        private static final long serialVersionUID = 1L;
        private static final Dimension minSize = new Dimension(12, 8);
        private int direction = 1;

        public SpinButton(int aDirection) {
            this.setInheritsPopupMenu(true);
            this.direction = aDirection;
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = Math.max(size.width, SpinButton.minSize.width);
            size.height = Math.max(size.height, SpinButton.minSize.height);
            return size;
        }

        public void paint(Graphics g) {
            ButtonModel model;
            Color[] colors = this.isEnabled() ? ((model = this.getModel()).isPressed() && model.isArmed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive((Component)((Object)this)) ? AbstractLookAndFeel.getTheme().getButtonColors() : AbstractLookAndFeel.getTheme().getInActiveColors()))) : AbstractLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient((Graphics)g, (Color[])colors, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
            this.paintBorder(g);
            g.setColor(this.getForeground());
            int w = 4;
            int h = 3;
            int x = (this.getWidth() - w) / 2;
            int y = (this.getHeight() - h) / 2;
            if (this.direction == 1) {
                for (int i = 0; i < h; ++i) {
                    g.drawLine(x + (h - i) - 1, y + i, x + w - (h - i) + 1, y + i);
                }
            } else {
                for (int i = 0; i < h; ++i) {
                    g.drawLine(x + i, y + i, x + w - i, y + i);
                }
            }
        }
    }
}

