/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcNfoConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowUpdateDatasourceTask2
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpdateDatasourceTask2.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR");
    private static final String skipRegex = "^[.][\\w@]+.*";
    private static final Pattern seasonPattern = Pattern.compile("(?i)season([0-9]{0,2}|-specials)-poster\\..{2,4}");
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private List<String> dataSources;
    private List<Path> tvShowFolders = new ArrayList<Path>();
    private TvShowList tvShowList;
    private HashSet<Path> filesFound = new HashSet();

    public TvShowUpdateDatasourceTask2() {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
    }

    public TvShowUpdateDatasourceTask2(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    public TvShowUpdateDatasourceTask2(List<Path> tvShowFolders) {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(0);
        this.tvShowFolders.addAll(tvShowFolders);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.tvShowFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        preDir = 0L;
        postDir = 0L;
        visFile = 0L;
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.start();
            ArrayList<Path> existing = new ArrayList<Path>();
            for (TvShow show : this.tvShowList.getTvShows()) {
                existing.add(show.getPathNIO());
            }
            if (this.tvShowFolders.isEmpty()) {
                for (String ds : this.dataSources) {
                    LOGGER.info("Start UDS on datasource: " + ds);
                    Path dsAsPath = Paths.get(ds, new String[0]);
                    if (!Files.exists(dsAsPath, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty " + ds);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    this.initThreadPool(3, "update");
                    ArrayList<Path> newTvShowDirs = new ArrayList<Path>();
                    ArrayList<Path> existingTvShowDirs = new ArrayList<Path>();
                    List<Path> rootList = TvShowUpdateDatasourceTask2.listFilesAndDirs(dsAsPath);
                    if (rootList.isEmpty() && !Platform.isWindows()) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    for (Path path : rootList) {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (existing.contains(path)) {
                                existingTvShowDirs.add(path);
                                continue;
                            }
                            newTvShowDirs.add(path);
                            continue;
                        }
                        String ext = FilenameUtils.getExtension((String)path.getFileName().toString());
                        if (!Globals.settings.getVideoFileType().contains("." + ext)) continue;
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.episodeinroot", new String[]{path.getFileName().toString()}));
                    }
                    for (Path subdir : newTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    for (Path subdir : existingTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    this.waitForCompletionOrCancel();
                    if (!this.cancel) {
                        this.cleanupDatasource(ds);
                        this.waitForCompletionOrCancel();
                        if (!this.cancel) continue;
                    }
                    break;
                }
            } else {
                this.initThreadPool(3, "update");
                for (Path path : this.tvShowFolders) {
                    if (!Files.exists(path, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty " + path.toAbsolutePath().toString());
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{path.toAbsolutePath().toString()}));
                        continue;
                    }
                    this.submitTask(new FindTvShowTask(path, path.getParent().toAbsolutePath()));
                }
                this.waitForCompletionOrCancel();
                if (!this.cancel) {
                    this.cleanupShows();
                    this.waitForCompletionOrCancel();
                }
            }
            LOGGER.info("getting Mediainfo...");
            this.initThreadPool(1, "mediainfo");
            this.setTaskName(BUNDLE.getString("update.mediainfo"));
            this.setTaskDescription(null);
            this.setProgressDone(0);
            if (!this.cancel) {
                TvShow tvShow;
                if (this.tvShowFolders.isEmpty()) {
                    for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.dataSources.contains(tvShow.getDataSource())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                } else {
                    for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                }
                this.waitForCompletionOrCancel();
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took " + stopWatch);
            LOGGER.debug("FilesFound " + this.filesFound.size());
            LOGGER.debug("tvShowsFound " + this.tvShowList.getTvShowCount());
            LOGGER.debug("episodesFound " + this.tvShowList.getEpisodeCount());
            LOGGER.debug("PreDir " + preDir);
            LOGGER.debug("PostDir " + postDir);
            LOGGER.debug("VisFile " + visFile);
            preDir = 0L;
            postDir = 0L;
            visFile = 0L;
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void cleanupShows() {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanupDatasource(String datasource) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned tv shows/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!Paths.get(datasource, new String[0]).toAbsolutePath().equals(Paths.get(tvShow.getDataSource(), new String[0]).toAbsolutePath())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanup(TvShow tvShow) {
        boolean dirty = false;
        if (!tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(tvShow.getMediaFiles());
            for (MediaFile mf : mediaFiles) {
                if (this.filesFound.contains(mf.getFileAsPath())) continue;
                if (!mf.exists()) {
                    LOGGER.debug("removing orphaned file: " + mf.getFileAsPath());
                    tvShow.removeFromMediaFiles(mf);
                    dirty = true;
                    continue;
                }
                LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
            }
            ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(tvShow.getEpisodes());
            for (TvShowEpisode episode : episodes) {
                mediaFiles = new ArrayList<MediaFile>(episode.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file: " + mf.getFileAsPath());
                        episode.removeFromMediaFiles(mf);
                        dirty = true;
                        continue;
                    }
                    LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
                }
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (mfs.size() != 0) continue;
                tvShow.removeEpisode(episode);
                dirty = true;
            }
        }
        if (dirty) {
            tvShow.saveToDb();
        }
    }

    private void gatherMediaInformationForUngatheredMediaFiles(TvShow tvShow) {
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
            this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)tvShow, false));
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)episode, false));
            }
        }
    }

    private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
        MediaFile mf = null;
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf = new MediaFile(mediaFile);
        }
        return mf;
    }

    private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf.add(new MediaFile(mediaFile));
        }
        return mf;
    }

    private List<MediaFile> getMediaFilesExceptType(List<MediaFile> mfs, MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (match) continue;
            mf.add(new MediaFile(mediaFile));
        }
        return mf;
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static List<Path> listFilesOnly(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (!Utils.isRegularFile(path)) continue;
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || TvShowModuleManager.SETTINGS.getTvShowSkipFolders().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: " + path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileNames;
    }

    public static List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || TvShowModuleManager.SETTINGS.getTvShowSkipFolders().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: " + path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileNames;
    }

    public static HashSet<Path> getAllFilesRecursive(Path folder, int deep) {
        folder = folder.toAbsolutePath();
        AllFilesRecursive visitor = new AllFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    private static class AllFilesRecursive
    extends SimpleFileVisitor<Path> {
        private HashSet<Path> fFound = new HashSet();

        private AllFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            visFile++;
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(TvShowUpdateDatasourceTask2.skipRegex)) {
                this.fFound.add(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            preDir++;
            if (dir.getFileName() != null && (Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || skipFolders.contains(dir.getFileName().toString().toUpperCase(Locale.ROOT)) || dir.getFileName().toString().matches(TvShowUpdateDatasourceTask2.skipRegex)) || TvShowModuleManager.SETTINGS.getTvShowSkipFolders().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: " + dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            postDir++;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOGGER.error("" + exc);
            return FileVisitResult.CONTINUE;
        }
    }

    private class FindTvShowTask
    implements Callable<Object> {
        private Path showDir = null;
        private Path datasource = null;
        private long uniqueId;

        public FindTvShowTask(Path showDir, Path datasource) {
            this.showDir = showDir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() throws Exception {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            LOGGER.info("start parsing " + this.showDir);
            if (this.showDir.getFileName().toString().matches(TvShowUpdateDatasourceTask2.skipRegex)) {
                LOGGER.debug("Skipping dir: " + this.showDir);
                return "";
            }
            HashSet<Path> allFiles = TvShowUpdateDatasourceTask2.getAllFilesRecursive(this.showDir, Integer.MAX_VALUE);
            if (allFiles != null && allFiles.isEmpty()) {
                LOGGER.info("skip empty directory " + this.showDir);
                return "";
            }
            TvShowUpdateDatasourceTask2.this.filesFound.add(this.showDir.toAbsolutePath());
            TvShowUpdateDatasourceTask2.this.filesFound.addAll(allFiles);
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            for (Path file : allFiles) {
                if (file.getFileName().toString().matches(TvShowUpdateDatasourceTask2.skipRegex)) continue;
                mfs.add(new MediaFile(file));
            }
            allFiles.clear();
            if (TvShowUpdateDatasourceTask2.this.getMediaFiles(mfs, new MediaFileType[]{MediaFileType.VIDEO}).size() == 0) {
                LOGGER.info("no video file found in directory " + this.showDir);
                return "";
            }
            TvShow tvShow = TvShowUpdateDatasourceTask2.this.tvShowList.getTvShowByPath(this.showDir);
            MediaFile showNFO = new MediaFile(this.showDir.resolve("tvshow.nfo"), MediaFileType.NFO);
            if (tvShow == null) {
                if (Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    tvShow = TvShowToXbmcNfoConnector.getData(showNFO.getFileAsPath().toFile());
                }
                if (tvShow == null) {
                    tvShow = new TvShow();
                    String[] ty = ParserUtils.detectCleanMovienameAndYear(this.showDir.getFileName().toString());
                    tvShow.setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        tvShow.setYear(ty[1]);
                    }
                }
                if (tvShow != null) {
                    tvShow.setPath(this.showDir.toAbsolutePath().toString());
                    tvShow.setDataSource(this.datasource.toString());
                    tvShow.setNewlyAdded(true);
                    TvShowUpdateDatasourceTask2.this.tvShowList.addTvShow(tvShow);
                }
            }
            HashSet<Path> discFolders = new HashSet<Path>();
            for (MediaFile mf : TvShowUpdateDatasourceTask2.this.getMediaFiles(mfs, new MediaFileType[]{MediaFileType.VIDEO})) {
                List<TvShowEpisode> episodes;
                ArrayList<MediaFile> epFiles = new ArrayList<MediaFile>();
                if (mf.isDiscFile()) {
                    Path discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                    String folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                    while (folder.contains("BDMV") || folder.contains("VIDEO_TS")) {
                        discRoot = discRoot.getParent();
                        folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                    }
                    if (discFolders.contains(discRoot)) continue;
                    discFolders.add(discRoot);
                    for (MediaFile em : mfs) {
                        if (!em.getFileAsPath().startsWith(discRoot) || em.getType() == MediaFileType.UNKNOWN) continue;
                        epFiles.add(em);
                    }
                } else {
                    String basename = FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
                    LOGGER.trace("UDS: basename: " + basename);
                    for (MediaFile em : mfs) {
                        String emBasename = FilenameUtils.getBaseName((String)em.getFilename());
                        String epNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                        if (!emBasename.equals(basename) && !emBasename.matches(epNameRegexp)) continue;
                        if (em.getType() == MediaFileType.GRAPHIC) {
                            em.setType(MediaFileType.THUMB);
                        }
                        epFiles.add(em);
                        LOGGER.trace("UDS: found matching MF: " + em);
                    }
                }
                if ((episodes = TvShowUpdateDatasourceTask2.this.tvShowList.getTvEpisodesByFile(tvShow, mf.getFile())).size() == 0) {
                    TvShowEpisode ep;
                    String folder;
                    Path discRoot;
                    TvShowEpisode episode2;
                    MediaFile epNfo;
                    MediaFile meta = TvShowUpdateDatasourceTask2.this.getMediaFile(epFiles, new MediaFileType[]{MediaFileType.VSMETA});
                    TvShowEpisode vsMetaEP = null;
                    if (meta != null) {
                        VSMeta vsmeta = new VSMeta();
                        vsmeta.parseFile(meta.getFileAsPath());
                        vsMetaEP = vsmeta.getTvShowEpisode();
                    }
                    if ((epNfo = TvShowUpdateDatasourceTask2.this.getMediaFile(epFiles, new MediaFileType[]{MediaFileType.NFO})) != null) {
                        LOGGER.info("found episode NFO - try to parse '" + this.showDir.relativize(epNfo.getFileAsPath()) + "'");
                        List<TvShowEpisode> episodesInNfo = TvShowEpisode.parseNFO(epNfo);
                        if (episodesInNfo.size() > 0) {
                            for (TvShowEpisode episode2 : episodesInNfo) {
                                episode2.setPath(mf.getPath());
                                episode2.setTvShow(tvShow);
                                episode2.setDateAddedFromMediaFile(mf);
                                if (episode2.getMediaSource() == MediaSource.UNKNOWN) {
                                    episode2.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                                }
                                episode2.setNewlyAdded(true);
                                episode2.addToMediaFiles(epFiles);
                                if (mf.isDiscFile()) {
                                    episode2.setDisc(true);
                                    discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                                    folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                    while (folder.contains("BDMV") || folder.contains("VIDEO_TS")) {
                                        discRoot = discRoot.getParent();
                                        folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                    }
                                    episode2.setPath(discRoot.toAbsolutePath().toString());
                                }
                                if (episodesInNfo.size() > 1) {
                                    episode2.setMultiEpisode(true);
                                } else {
                                    episode2.setMultiEpisode(false);
                                }
                                episode2.merge(vsMetaEP);
                                episode2.saveToDb();
                                tvShow.addEpisode(episode2);
                            }
                            continue;
                        }
                    }
                    String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                    TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                    if (result.episodes.size() == 1 && result.season > -1 && result.stackingMarkerFound && (ep = tvShow.getEpisode(result.season, result.episodes.get(0))) != null) {
                        ep.setNewlyAdded(true);
                        ep.addToMediaFiles(mf);
                        continue;
                    }
                    if (result.episodes.size() == 0 && result.date == null) {
                        result = TvShowEpisodeAndSeasonParser.detectEpisodeFromDirectory(this.showDir.toFile(), tvShow.getPath());
                    }
                    if (result.season == -1) {
                        result.season = TvShowEpisodeAndSeasonParser.detectSeason(relativePath);
                    }
                    if (result.episodes.size() > 0) {
                        for (int ep2 : result.episodes) {
                            TvShowEpisode episode3 = new TvShowEpisode();
                            episode3.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                            episode3.setEpisode(ep2);
                            episode3.setSeason(result.season);
                            episode3.setFirstAired(result.date);
                            if (result.name.isEmpty()) {
                                result.name = FilenameUtils.getBaseName((String)mf.getFilename());
                            }
                            episode3.setTitle(result.name);
                            episode3.setPath(mf.getPath());
                            episode3.setTvShow(tvShow);
                            episode3.addToMediaFiles(epFiles);
                            episode3.setDateAddedFromMediaFile(mf);
                            if (episode3.getMediaSource() == MediaSource.UNKNOWN) {
                                episode3.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                            }
                            episode3.setNewlyAdded(true);
                            if (mf.isDiscFile()) {
                                episode3.setDisc(true);
                                Path discRoot2 = mf.getFileAsPath().getParent().toAbsolutePath();
                                String folder2 = this.showDir.relativize(discRoot2).toString().toUpperCase(Locale.ROOT);
                                while (folder2.contains("BDMV") || folder2.contains("VIDEO_TS")) {
                                    discRoot2 = discRoot2.getParent();
                                    folder2 = this.showDir.relativize(discRoot2).toString().toUpperCase(Locale.ROOT);
                                }
                                episode3.setPath(discRoot2.toAbsolutePath().toString());
                            }
                            if (result.episodes.size() > 1) {
                                episode3.setMultiEpisode(true);
                            } else {
                                episode3.setMultiEpisode(false);
                            }
                            episode3.merge(vsMetaEP);
                            episode3.saveToDb();
                            tvShow.addEpisode(episode3);
                        }
                        continue;
                    }
                    episode2 = new TvShowEpisode();
                    episode2.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                    episode2.setEpisode(-1);
                    episode2.setSeason(-1);
                    episode2.setPath(mf.getPath());
                    if (mf.isDiscFile()) {
                        episode2.setDisc(true);
                        discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                        folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                        while (folder.contains("BDMV") || folder.contains("VIDEO_TS")) {
                            discRoot = discRoot.getParent();
                            folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                        }
                        episode2.setPath(discRoot.toAbsolutePath().toString());
                    }
                    episode2.setTitle(FilenameUtils.getBaseName((String)mf.getFilename()));
                    episode2.setTvShow(tvShow);
                    episode2.setFirstAired(result.date);
                    episode2.addToMediaFiles(epFiles);
                    episode2.setDateAddedFromMediaFile(mf);
                    if (episode2.getMediaSource() == MediaSource.UNKNOWN) {
                        episode2.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                    }
                    episode2.setNewlyAdded(true);
                    episode2.merge(vsMetaEP);
                    episode2.saveToDb();
                    tvShow.addEpisode(episode2);
                    continue;
                }
                for (TvShowEpisode episode : episodes) {
                    episode.addToMediaFiles(epFiles);
                    episode.setDisc(mf.isDiscFile());
                    if (episodes.size() > 1) {
                        episode.setMultiEpisode(true);
                    } else {
                        episode.setMultiEpisode(false);
                    }
                    episode.saveToDb();
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            for (MediaFile mf : mfs) {
                String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                if (result.season <= 0 || result.episodes.isEmpty()) continue;
                Iterator<Comparable<MediaFile>> i$ = result.episodes.iterator();
                while (i$.hasNext()) {
                    int epnr = (Integer)i$.next();
                    TvShowEpisode ep = tvShow.getEpisode(result.season, epnr);
                    if (ep == null || mf.getType() == MediaFileType.SEASON_POSTER) continue;
                    ep.addToMediaFiles(mf);
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            tvShow.addToMediaFiles(mfs);
            for (MediaFile mf : TvShowUpdateDatasourceTask2.this.getMediaFiles(mfs, new MediaFileType[]{MediaFileType.SEASON_POSTER})) {
                Matcher matcher = seasonPattern.matcher(mf.getFilename());
                if (!matcher.matches()) continue;
                try {
                    int season = Integer.parseInt(matcher.group(1));
                    LOGGER.debug("found season poster " + mf.getFileAsPath());
                    tvShow.setSeasonPoster(season, mf);
                }
                catch (Exception e) {
                    if (!mf.getFilename().startsWith("season-specials-poster")) continue;
                    LOGGER.debug("found season specials poster " + mf.getFileAsPath());
                    tvShow.setSeasonPoster(-1, mf);
                }
            }
            tvShow.saveToDb();
            return this.showDir.getFileName().toString();
        }
    }
}

