/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.japura.gui.renderer.DefaultSplitButtonRenderer;
import org.japura.gui.renderer.SplitButtonRenderer;

public class SplitButton
extends JButton {
    private static final long serialVersionUID = 4L;
    public static final Mode BUTTON = Mode.BUTTON;
    public static final Mode MENU = Mode.MENU;
    private Mode mode;
    private int maxLabelWidth;
    private int alignment = 0;
    private int imageWidth = 13;
    private int gap = 5;
    private int separatorGap = 7;
    private String actualButton;
    private boolean fireBlocked;
    private boolean buttonChooserVisible;
    private boolean mouseIn;
    private List<Button> buttons;
    private DefaultListModel listModel;
    private JPopupMenu buttonsChooser;
    private JPanel buttonsRoot;
    private JList buttonsList;
    private ListRenderer listRenderer;
    private SplitButtonRenderer splitButtonRenderer;
    private transient MouseListener originalMouseListener;
    private transient MouseListener handlerMouseListener;

    public SplitButton() {
        this(Mode.BUTTON);
    }

    public SplitButton(Mode mode) {
        this.mode = mode != null ? mode : BUTTON;
        this.buttons = new ArrayList<Button>();
        this.splitButtonRenderer = new DefaultSplitButtonRenderer();
        URL url = this.getClass().getResource("/images/jpr_splitbuttondown.png");
        Insets margin = this.getMargin();
        margin.right = this.gap;
        margin.left = this.gap;
        this.setMargin(margin);
        super.setHorizontalTextPosition(2);
        super.setHorizontalAlignment(4);
        super.setIcon(new ImageIcon(url));
        this.setFocusPainted(false);
        this.originalMouseListener = this.getMouseListeners()[0];
        this.removeMouseListener(this.originalMouseListener);
        this.addMouseListener(this.getHandlerMouseListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SplitButton.this.reajustTextGap();
            }
        });
    }

    private Button get(String name) {
        if ((name = this.ajustName(name)) == null) {
            return null;
        }
        for (Button button : this.buttons) {
            if (button.isSeparator() || !button.getName().equals(name)) continue;
            return button;
        }
        return null;
    }

    private DefaultListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    public void showButtonsChooser() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SplitButton.this.isEnabled() || !SplitButton.this.isShowing()) {
                    return;
                }
                SplitButton.this.buttonChooserVisible = true;
                SplitButton.this.fireBlocked = true;
                DefaultListModel model = SplitButton.this.getListModel();
                model.removeAllElements();
                boolean lastWasSeparator = false;
                boolean lastWasButton = false;
                for (Button button : SplitButton.this.buttons) {
                    if (button.isSeparator() && lastWasButton) {
                        model.addElement(button);
                        lastWasButton = false;
                        lastWasSeparator = true;
                        continue;
                    }
                    if (!button.isVisible() || button.isSeparator()) continue;
                    model.addElement(button);
                    lastWasButton = true;
                    lastWasSeparator = false;
                }
                while (lastWasSeparator) {
                    Button button;
                    model.remove(model.size() - 1);
                    lastWasSeparator = false;
                    if (model.size() <= 0 || !(button = (Button)model.get(model.size() - 1)).isSeparator()) continue;
                    lastWasSeparator = true;
                }
                if (model.size() == 0) {
                    SplitButton.this.buttonChooserVisible = false;
                    SplitButton.this.fireBlocked = false;
                    return;
                }
                Dimension dim = SplitButton.this.getSize();
                Dimension bcDim = SplitButton.this.getButtonsRoot().getPreferredSize();
                Insets insets = SplitButton.this.getButtonsChooser().getInsets();
                int width = dim.width;
                int height = bcDim.height + insets.bottom + insets.top;
                Dimension newDim = new Dimension(width, height);
                SplitButton.this.getButtonsChooser().setPreferredSize(newDim);
                SplitButton.this.getButtonsChooser().show(SplitButton.this, 0, dim.height);
            }
        });
    }

    private JPopupMenu getButtonsChooser() {
        if (this.buttonsChooser == null) {
            this.buttonsChooser = new JPopupMenu();
            this.buttonsChooser.setName("buttonsChooser");
            this.buttonsChooser.add(this.getButtonsRoot());
            this.buttonsChooser.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (SplitButton.this.mouseIn) {
                        SplitButton.this.buttonChooserVisible = true;
                    } else {
                        SplitButton.this.buttonChooserVisible = false;
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
        }
        return this.buttonsChooser;
    }

    private JPanel getButtonsRoot() {
        if (this.buttonsRoot == null) {
            this.buttonsRoot = new JPanel();
            this.buttonsRoot.setLayout(new BorderLayout());
            this.buttonsRoot.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
            this.buttonsRoot.add((Component)this.getButtonsList(), "Center");
        }
        return this.buttonsRoot;
    }

    private JList getButtonsList() {
        if (this.buttonsList == null) {
            this.buttonsList = new JList();
            this.listRenderer = new ListRenderer();
            this.buttonsList.setCellRenderer(this.listRenderer);
            this.buttonsList.setSelectionMode(0);
            this.buttonsList.setModel(this.getListModel());
            this.buttonsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Button button;
                    if (!(e.getValueIsAdjusting() || SplitButton.this.buttonsList.getSelectedIndex() <= -1 || (button = (Button)SplitButton.this.buttonsList.getSelectedValue()).isSeparator() || button.isDisabled())) {
                        SplitButton.this.setCurrentButton(button.getName());
                        SplitButton.this.doClick();
                        SplitButton.this.buttonsList.clearSelection();
                    }
                }
            });
            this.buttonsList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = SplitButton.this.buttonsList.locationToIndex(e.getPoint());
                    SplitButton.this.buttonsList.repaint();
                }
            });
            this.buttonsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = -1;
                    SplitButton.this.buttonsList.repaint();
                }
            });
        }
        return this.buttonsList;
    }

    private void removeActualListeners() {
        Button button;
        if (this.actualButton != null && (button = this.get(this.actualButton)) != null) {
            for (ActionListener listener : button.getListeners()) {
                super.removeActionListener(listener);
            }
        }
    }

    public void clearCurrentButton() {
        this.removeActualListeners();
        this.fireBlocked = false;
        this.getButtonsChooser().setVisible(false);
        this.listRenderer.mouseOverIndex = -1;
        this.actualButton = null;
        if (this.mode.equals((Object)Mode.BUTTON)) {
            super.setText("");
        }
        this.reajustTextGap();
    }

    public void setCurrentButton(Action action) {
        String name = null;
        if (action != null) {
            name = (String)action.getValue("Name");
        }
        this.setCurrentButton(name);
    }

    public void setCurrentButton(String name) {
        this.clearCurrentButton();
        name = this.ajustName(name);
        Button button = this.get(name);
        if (name != null && button != null && !button.isDisabled()) {
            this.actualButton = name;
            for (ActionListener listener : button.getListeners()) {
                super.addActionListener(listener);
            }
            if (this.mode.equals((Object)Mode.BUTTON)) {
                super.setText(name);
            }
        }
        this.reajustTextGap();
    }

    private void reajustTextGap() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension dim = null;
        dim = this.isShowing() ? this.getSize() : this.getPreferredSize();
        Insets insets = this.getInsets();
        int avaiableWidth = dim.width - insets.left - insets.right - this.imageWidth - this.separatorGap - 3 - this.gap;
        int d = this.gap + 3 + this.separatorGap;
        int width = fm.stringWidth(this.getText());
        if (this.alignment == 2) {
            super.setIconTextGap(avaiableWidth - width + d);
        } else if (this.alignment == 0) {
            super.setIconTextGap(avaiableWidth / 2 - width / 2 + d);
        } else if (this.alignment == 4) {
            super.setIconTextGap(this.gap + 3 + this.separatorGap);
        }
    }

    @Override
    public final void setHorizontalTextPosition(int textPosition) {
    }

    @Override
    public final void setHorizontalAlignment(int alignment) {
        if (alignment != 2 && alignment != 0 && alignment != 4) {
            throw new IllegalArgumentException();
        }
        this.alignment = alignment;
        this.reajustTextGap();
    }

    @Override
    public final void setIconTextGap(int iconTextGap) {
    }

    private void calculateMaxLabelWidth() {
        this.maxLabelWidth = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (Button button : this.buttons) {
            if (button.isSeparator()) continue;
            String name = button.getName();
            this.maxLabelWidth = Math.max(this.maxLabelWidth, fm.stringWidth(name));
        }
        if (this.mode.equals((Object)Mode.MENU)) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, fm.stringWidth(this.getText()));
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.calculatePreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.calculatePreferredSize();
    }

    private Dimension calculatePreferredSize() {
        Dimension dim = super.getPreferredSize();
        int width = this.maxLabelWidth;
        Insets insets = this.getInsets();
        width += insets.left + insets.right;
        dim.width = width += this.gap + this.imageWidth + this.separatorGap + 3;
        return dim;
    }

    @Override
    public final void setIcon(Icon defaultIcon) {
    }

    private String ajustName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim();
    }

    public boolean addButton(String name) {
        if ((name = this.ajustName(name)) != null && name.length() > 0 && this.get(name) == null) {
            this.buttons.add(new Button(name));
            this.calculateMaxLabelWidth();
            if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton == null) {
                this.setCurrentButton(name);
            }
            this.reajustTextGap();
            return true;
        }
        return false;
    }

    public void addButton(Action action) {
        String name = (String)action.getValue("Name");
        if (this.addButton(name)) {
            this.addActionListener(name, action);
        }
    }

    public void addButtons(List<Action> actions) {
        for (Action action : actions) {
            this.addButton(action);
        }
    }

    public void removeSeparators() {
        ArrayList<Button> list = new ArrayList<Button>();
        for (Button button : this.buttons) {
            if (!button.isSeparator()) continue;
            list.add(button);
        }
        for (Button button : list) {
            this.buttons.remove(button);
        }
    }

    public void removeButtons() {
        this.clearCurrentButton();
        this.buttons.clear();
        this.calculateMaxLabelWidth();
        this.reajustTextGap();
    }

    public void removeButton(Action action) {
        String name = (String)action.getValue("Name");
        this.removeButton(name);
    }

    public void removeButton(String name) {
        Button button = this.get(name);
        if (button != null) {
            if (this.actualButton.equals(name)) {
                this.clearCurrentButton();
            }
            this.buttons.remove(button);
            this.calculateMaxLabelWidth();
            this.reajustTextGap();
        }
    }

    public void addSeparator() {
        this.buttons.add(new Button());
    }

    @Override
    public final void addActionListener(ActionListener l) {
        if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null) {
            this.addActionListener(this.actualButton, l);
        }
    }

    public final void addActionListener(String name, ActionListener l) {
        List<ActionListener> array;
        Button button = this.get(name);
        if (button != null && !(array = button.getListeners()).contains(l)) {
            array.add(l);
            if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null && this.actualButton.equals(name)) {
                super.addActionListener(l);
            }
        }
    }

    @Override
    public final void removeActionListener(ActionListener l) {
        if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null) {
            this.removeActionListener(this.actualButton, l);
        }
    }

    public final void removeActionListener(String name, ActionListener l) {
        Button button = this.get(name);
        if (button != null) {
            List<ActionListener> array = button.getListeners();
            array.remove(l);
            if (this.actualButton.equals(name)) {
                super.removeActionListener(l);
            }
        }
    }

    @Override
    public final ActionListener[] getActionListeners() {
        return this.getActionListeners(this.actualButton);
    }

    public final ActionListener[] getActionListeners(String name) {
        Button button = this.get(name);
        if (button != null) {
            List<ActionListener> array = button.getListeners();
            return array.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    @Override
    protected final void fireActionPerformed(ActionEvent event) {
        if (!this.fireBlocked) {
            super.fireActionPerformed(event);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public final void setText(String text) {
        if (this.mode.equals((Object)Mode.MENU)) {
            super.setText(text);
            this.calculateMaxLabelWidth();
        }
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mode.equals((Object)Mode.BUTTON)) {
            Dimension dim = this.getSize();
            Insets insets = this.getInsets();
            int x = dim.width - insets.right - this.imageWidth - this.separatorGap;
            int y = 6;
            g.setColor(Color.white);
            g.fillRect(x, y, 3, dim.height - 2 * y);
            g.setColor(Color.gray);
            g.drawLine(x + 1, y, x + 1, dim.height - y);
        }
    }

    public void setButtonEnabled(Action action, boolean enabled) {
        String name = (String)action.getValue("Name");
        this.setButtonEnabled(name, enabled);
    }

    public void setButtonEnabled(String name, boolean enabled) {
        Button button = this.get(name);
        if (button != null) {
            button.setDisabled(!enabled);
            if (enabled) {
                if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton == null) {
                    this.setCurrentButton(name);
                }
            } else if (this.mode.equals((Object)Mode.BUTTON) && this.actualButton != null && this.actualButton.equals(name)) {
                boolean founded = false;
                for (Button otherButton : this.buttons) {
                    if (otherButton.isDisabled()) continue;
                    founded = true;
                    this.setCurrentButton(otherButton.getName());
                    break;
                }
                if (!founded) {
                    this.clearCurrentButton();
                }
            }
        }
    }

    public void setButtonVisible(Action action, boolean visible) {
        String name = (String)action.getValue("Name");
        this.setButtonVisible(name, visible);
    }

    public void setButtonVisible(String name, boolean visible) {
        Button button = this.get(name);
        if (button != null) {
            button.setVisible(visible);
        }
    }

    public boolean isButtonVisible(Action action) {
        String name = (String)action.getValue("Name");
        return this.isButtonVisible(name);
    }

    public boolean isButtonVisible(String name) {
        Button button = this.get(name);
        if (button != null) {
            return button.isVisible();
        }
        return false;
    }

    public boolean isButtonEnabled(Action action) {
        String name = (String)action.getValue("Name");
        return this.isButtonEnabled(name);
    }

    public boolean isButtonEnabled(String name) {
        Button button = this.get(name);
        if (button != null) {
            return !button.isDisabled();
        }
        return false;
    }

    public String getSelectedButton() {
        return this.actualButton;
    }

    private MouseListener getHandlerMouseListener() {
        if (this.handlerMouseListener == null) {
            this.handlerMouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SplitButton.this.originalMouseListener.mouseClicked(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SplitButton.this.mouseIn = true;
                    SplitButton.this.originalMouseListener.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SplitButton.this.mouseIn = false;
                    SplitButton.this.originalMouseListener.mouseExited(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    SplitButton.this.originalMouseListener.mousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SplitButton.this.mode.equals((Object)Mode.MENU)) {
                        SplitButton.this.removeActualListeners();
                    }
                    Dimension dim = SplitButton.this.getSize();
                    int x = dim.width - SplitButton.this.getInsets().right - SplitButton.this.imageWidth - SplitButton.this.separatorGap;
                    if (!SplitButton.this.buttonChooserVisible && SplitButton.this.buttons.size() > 0 && (SplitButton.this.mode.equals((Object)Mode.MENU) || e.getPoint().x > x)) {
                        SplitButton.this.fireBlocked = true;
                        SplitButton.this.showButtonsChooser();
                    } else {
                        SplitButton.this.getButtonsChooser().setVisible(false);
                        ((SplitButton)SplitButton.this).listRenderer.mouseOverIndex = -1;
                        SplitButton.this.buttonChooserVisible = false;
                    }
                    SplitButton.this.originalMouseListener.mouseReleased(e);
                    SplitButton.this.fireBlocked = false;
                }
            };
        }
        return this.handlerMouseListener;
    }

    public SplitButtonRenderer getRenderer() {
        return this.splitButtonRenderer;
    }

    public void setRenderer(SplitButtonRenderer renderer) {
        if (renderer == null) {
            renderer = new DefaultSplitButtonRenderer();
        }
        this.splitButtonRenderer = renderer;
    }

    private static class Button {
        private String id = UUID.randomUUID().toString();
        private boolean separator;
        private boolean visible;
        private boolean disabled;
        private String name;
        private List<ActionListener> listeners = new Vector<ActionListener>();

        public Button() {
            this(null);
            this.separator = true;
        }

        public Button(String name) {
            this.name = name;
            this.visible = true;
        }

        public boolean isSeparator() {
            return this.separator;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public List<ActionListener> getListeners() {
            return this.listeners;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Button other = (Button)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    public static enum Mode {
        BUTTON,
        MENU;

    }

    private class ListRenderer
    implements ListCellRenderer {
        public int mouseOverIndex;

        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Button button = (Button)value;
            cellHasFocus = this.mouseOverIndex == index;
            String name = null;
            if (!button.isSeparator()) {
                name = button.getName();
            }
            return SplitButton.this.splitButtonRenderer.getCellRendererComponent(name, button.isSeparator(), cellHasFocus, !button.isDisabled());
        }
    }
}

