/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;

class MovieSourcePanel
extends JPanel {
    private static final long serialVersionUID = -8346420911623937902L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private JList<String> listDataSources;
    private JComboBox<MovieConnectors> cbNfoFormat;

    public MovieSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.LINE_GAP_ROWSPEC}));
        JPanel panelMovieDataSources = new JPanel();
        this.add((Component)panelMovieDataSources, "2, 2, fill, fill");
        panelMovieDataSources.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"70dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblMovieDataSources = new JLabel(BUNDLE.getString("wizard.movie.datasources"));
        panelMovieDataSources.add((Component)lblMovieDataSources, "2, 2, 5, 1");
        JTextPane tpDatasourceHint = new JTextPane();
        tpDatasourceHint.setText(BUNDLE.getString("wizard.datasource.hint"));
        tpDatasourceHint.setOpaque(false);
        panelMovieDataSources.add((Component)tpDatasourceHint, "2, 3, 5, 1, fill, fill");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelMovieDataSources.add((Component)scrollPaneDataSources, "2, 5, 3, 1, fill, fill");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        JPanel panelMovieSourcesButtons = new JPanel();
        panelMovieDataSources.add((Component)panelMovieSourcesButtons, "6, 5, fill, top");
        panelMovieSourcesButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAdd = new JButton(IconManager.LIST_ADD);
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.datasource.folderchooser"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    MovieModuleManager.MOVIE_SETTINGS.addMovieDataSources(file.toAbsolutePath().toString());
                }
            }
        });
        panelMovieSourcesButtons.add((Component)btnAdd, "1, 1, fill, top");
        JButton btnRemove = new JButton(IconManager.LIST_REMOVE);
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = MovieSourcePanel.this.listDataSources.getSelectedIndex();
                if (row != -1) {
                    String path = MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource().get(row);
                    Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                    int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.movie.datasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                    if (decision == 0) {
                        MovieSourcePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        MovieModuleManager.MOVIE_SETTINGS.removeMovieDataSources(path);
                        MovieSourcePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        panelMovieSourcesButtons.add((Component)btnRemove, "1, 3, fill, top");
        JPanel panel = new JPanel();
        panelMovieDataSources.add((Component)panel, "2, 7, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"right:default"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"26px")}));
        JLabel lblNfoFormat = new JLabel(BUNDLE.getString("Settings.nfoFormat"));
        panel.add((Component)lblNfoFormat, "1, 1, right, default");
        this.cbNfoFormat = new JComboBox();
        panel.add(this.cbNfoFormat, "3, 1, fill, default");
        this.cbNfoFormat.setModel(new DefaultComboBoxModel<MovieConnectors>(MovieConnectors.values()));
        JTextPane tpNfoHint = new JTextPane();
        tpNfoHint.setText(BUNDLE.getString("wizard.nfo.hint"));
        tpNfoHint.setOpaque(false);
        panelMovieDataSources.add((Component)tpNfoHint, "4, 7, 3, 1, fill, fill");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"movieConnector");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"movieDataSource");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listDataSources);
        jListBinding_1.bind();
    }
}

