/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;

public class MovieSetInformationPanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final long serialVersionUID = -8166784589262658147L;
    private MovieSetSelectionModel selectionModel;
    private JLabel lblMovieSetName;
    private JTable tableAssignedMovies;
    private ImageLabel lblMovieSetPoster;
    private JPanel panel;
    private JLayeredPane layeredPane;
    private ImageLabel lblMovieSetFanart;
    private JSplitPane panelSouth;
    private JScrollPane scrollPaneOverview;
    private JTextPane tpOverview;
    private JPanel panelOverview;
    private JLabel lblOverview;
    private EventList<Movie> movieEventList;
    private DefaultEventTableModel<Movie> movieTableModel = null;

    public MovieSetInformationPanel(MovieSetSelectionModel model) {
        this.selectionModel = model;
        this.movieEventList = new ObservableElementList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)new BasicEventList()), GlazedLists.beanConnector(Movie.class));
        this.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"180px:grow"), ColumnSpec.decode((String)"1px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"pref:grow"), RowSpec.decode((String)"bottom:default")}));
        this.lblMovieSetName = new JLabel("");
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.5, 1);
        this.panel.add((Component)this.lblMovieSetName, "2,1, fill, fill");
        this.layeredPane = new JLayeredPane();
        this.panel.add((Component)this.layeredPane, "1, 3, 2, 1, fill, fill");
        this.layeredPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"10px"), ColumnSpec.decode((String)"120px"), ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{RowSpec.decode((String)"10px"), RowSpec.decode((String)"180px"), RowSpec.decode((String)"default:grow")}));
        this.lblMovieSetPoster = new ImageLabel();
        this.lblMovieSetPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblMovieSetPoster.enableLightbox();
        this.layeredPane.setLayer(this.lblMovieSetPoster, 1);
        this.layeredPane.add((Component)this.lblMovieSetPoster, "2, 2, fill, fill");
        this.lblMovieSetFanart = new ImageLabel(false, true);
        this.lblMovieSetFanart.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblMovieSetFanart.enableLightbox();
        this.layeredPane.add((Component)this.lblMovieSetFanart, "1, 1, 3, 3, fill, fill");
        this.panelSouth = new JSplitPane();
        this.panelSouth.setContinuousLayout(true);
        this.panelSouth.setResizeWeight(0.5);
        this.add((Component)this.panelSouth, "South");
        this.panelOverview = new JPanel();
        this.panelSouth.setLeftComponent(this.panelOverview);
        this.panelOverview.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"100px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"24px:grow")}));
        this.lblOverview = new JLabel(BUNDLE.getString("metatag.plot"));
        this.panelOverview.add((Component)this.lblOverview, "1, 2");
        this.scrollPaneOverview = new JScrollPane();
        this.panelOverview.add((Component)this.scrollPaneOverview, "1, 4, fill, fill");
        this.tpOverview = new JTextPane();
        this.tpOverview.setEditable(false);
        this.scrollPaneOverview.setViewportView(this.tpOverview);
        JPanel panelMovies = new JPanel();
        this.panelSouth.setRightComponent(panelMovies);
        panelMovies.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow(3)")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"203px:grow")}));
        this.movieTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.movieEventList), (TableFormat)new MovieInMovieSetTableFormat());
        this.tableAssignedMovies = new ZebraJTable((TableModel)this.movieTableModel);
        JScrollPane scrollPaneMovies = ZebraJTable.createStripedJScrollPane(this.tableAssignedMovies);
        panelMovies.add((Component)scrollPaneMovies, "1, 2, fill, fill");
        this.tableAssignedMovies.setPreferredScrollableViewportSize(new Dimension(450, 200));
        scrollPaneMovies.setViewportView(this.tableAssignedMovies);
        this.initDataBindings();
        int width = this.tableAssignedMovies.getFontMetrics(this.tableAssignedMovies.getFont()).stringWidth(" 2000");
        int titleWidth = this.tableAssignedMovies.getFontMetrics(this.tableAssignedMovies.getFont()).stringWidth(BUNDLE.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((double)width * 1.5));
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(2).setMinWidth(70);
        this.tableAssignedMovies.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(85);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MovieSet movieSet;
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSetSelectionModel.class && "selectedMovieSet".equals(property) || source.getClass() == MovieSet.class && "movies".equals(property)) {
                    MovieSetInformationPanel.this.movieEventList.clear();
                    MovieSetInformationPanel.this.movieEventList.addAll(MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getMovies());
                    if (StringUtils.isNotBlank((CharSequence)MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkFilename(MediaFileType.POSTER))) {
                        MovieSetInformationPanel.this.lblMovieSetPoster.setImagePath(MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkFilename(MediaFileType.POSTER));
                    } else {
                        MovieSetInformationPanel.this.lblMovieSetPoster.setImagePath("");
                        MovieSetInformationPanel.this.lblMovieSetPoster.setImageUrl(MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkUrl(MediaFileType.POSTER));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkFilename(MediaFileType.FANART))) {
                        MovieSetInformationPanel.this.lblMovieSetFanart.setImagePath(MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkFilename(MediaFileType.FANART));
                    } else {
                        MovieSetInformationPanel.this.lblMovieSetFanart.setImagePath("");
                        MovieSetInformationPanel.this.lblMovieSetFanart.setImageUrl(MovieSetInformationPanel.this.selectionModel.getSelectedMovieSet().getArtworkUrl(MediaFileType.FANART));
                    }
                }
                if (source.getClass() == MovieSet.class && "fanart".equals(property)) {
                    movieSet = (MovieSet)source;
                    MovieSetInformationPanel.this.lblMovieSetFanart.clearImage();
                    MovieSetInformationPanel.this.lblMovieSetFanart.setImagePath(movieSet.getArtworkFilename(MediaFileType.FANART));
                }
                if (source.getClass() == MovieSet.class && "poster".equals(property)) {
                    movieSet = (MovieSet)source;
                    MovieSetInformationPanel.this.lblMovieSetPoster.clearImage();
                    MovieSetInformationPanel.this.lblMovieSetPoster.setImagePath(movieSet.getArtworkFilename(MediaFileType.POSTER));
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initDataBindings() {
        BeanProperty movieSetSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovieSet.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSetSelectionModelBeanProperty, (Object)this.lblMovieSetName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSetSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovieSet.plot");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSetSelectionModelBeanProperty_4, (Object)this.tpOverview, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
    }

    private static class MovieInMovieSetTableFormat
    implements AdvancedTableFormat<Movie> {
        private MovieInMovieSetTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("movieset.parts");
                }
                case 1: {
                    return BUNDLE.getString("metatag.year");
                }
                case 2: {
                    return BUNDLE.getString("metatag.watched");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(Movie movie, int column) {
            switch (column) {
                case 0: {
                    return movie.getTitle();
                }
                case 1: {
                    return movie.getYear();
                }
                case 2: {
                    return movie.isWatched();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }
}

