/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.kodi.ScraperFunction;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;

public class KodiScraper
implements IMediaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiScraper.class);
    private Map<String, ScraperFunction> functions = new TreeMap<String, ScraperFunction>();
    MediaType type;
    String language;
    String provider;
    File addonFolder;
    String scraperXml;
    MediaProviderInfo providerInfo;

    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public KodiScraper(File scraperFolder) {
        try {
            File savedSettings;
            File settingsFile;
            File langFile;
            File info = new File(scraperFolder, "addon.xml");
            Document doc = Jsoup.parse((File)info, (String)"UTF-8", (String)"");
            Elements addon = doc.getElementsByTag("addon");
            this.addonFolder = scraperFolder;
            String id = addon.attr("id");
            String name = addon.attr("name");
            String version = addon.attr("version");
            String summary = "";
            String description = "";
            this.provider = addon.attr("provider-name");
            for (Element el : doc.getElementsByAttribute("point")) {
                String point = el.attr("point");
                if (point.equals("xbmc.addon.metadata")) {
                    Elements desc = el.getElementsByAttributeValue("lang", Locale.getDefault().getLanguage());
                    if (desc.size() == 0) {
                        desc = el.getElementsByAttributeValue("lang", "en");
                    }
                    for (Element d : desc) {
                        if (d.nodeName().equals("summary")) {
                            summary = d.text();
                            continue;
                        }
                        if (!d.nodeName().equals("description")) continue;
                        description = d.text();
                    }
                    continue;
                }
                if (!point.contains("metadata.scraper")) continue;
                this.scraperXml = el.attr("library");
                this.language = el.attr("language");
                if (point.equals("xbmc.metadata.scraper.movies")) {
                    this.type = MediaType.MOVIE;
                    continue;
                }
                if (!point.equals("xbmc.metadata.scraper.tvshows")) continue;
                this.type = MediaType.TV_SHOW;
            }
            this.providerInfo = new MediaProviderInfo(id, "Kodi: " + name, "<h3>" + summary + "</h3><br>" + description);
            this.providerInfo.setVersion(version);
            HashMap<String, String> labelmap = new HashMap<String, String>();
            String lang = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH);
            File langFolder = new File(scraperFolder, "resources/language/" + lang);
            if (!langFolder.exists()) {
                langFolder = new File(scraperFolder, "resources/language/English");
            }
            if ((langFile = new File(langFolder, "strings.xml")).exists()) {
                Document set = Jsoup.parse((File)langFile, (String)"UTF-8", (String)"");
                Elements strings = set.getElementsByTag("string");
                for (Element el : strings) {
                    labelmap.put(el.id(), el.text());
                }
            } else {
                langFile = new File(langFolder, "strings.po");
                if (langFile.exists()) {
                    String labels = FileUtils.readFileToString((File)langFile);
                    Pattern p = Pattern.compile("msgctxt \"#(.*?)\"\nmsgid \"(.*?)\"\nmsgstr \"(.*?)\"");
                    Matcher m = p.matcher(labels);
                    while (m.find()) {
                        labelmap.put(m.group(1), m.group(3).isEmpty() ? m.group(2) : m.group(3));
                    }
                }
            }
            if ((settingsFile = new File(scraperFolder, "resources/settings.xml")).exists()) {
                Document set = Jsoup.parse((File)settingsFile, (String)"UTF-8", (String)"");
                Elements settings = set.getElementsByTag("setting");
                block19: for (Element el : settings) {
                    String setid = el.attr("id");
                    if (StringUtils.isEmpty((CharSequence)setid)) continue;
                    String type = el.attr("type");
                    String defaultValue = el.attr("default");
                    String[] possibleValues = el.attr("values").split("\\|");
                    if (possibleValues.length == 1 && possibleValues[0].isEmpty()) {
                        possibleValues = el.attr("lvalues").split("\\|");
                    }
                    for (int index = 0; index < possibleValues.length; ++index) {
                        String labelName;
                        String code = possibleValues[index];
                        if (!code.startsWith("3") || code.length() != 5 || (labelName = (String)labelmap.get(code)) == null) continue;
                        possibleValues[index] = labelName = labelName.replaceAll("\\[COLOR=(.*?)\\]", "").replaceAll("\\[/COLOR\\]", "");
                    }
                    String label = el.attr("label");
                    String labelName = (String)labelmap.get(label);
                    if (labelName != null) {
                        labelName = labelName.replaceAll("\\[COLOR=(.*?)\\]", "").replaceAll("\\[/COLOR\\]", "");
                    }
                    boolean visible = true;
                    String vis = el.attr("visible");
                    if (vis.equalsIgnoreCase("false")) {
                        visible = false;
                    }
                    boolean encrypt = false;
                    String option = el.attr("option");
                    if (option.toLowerCase(Locale.ROOT).contains("hidden")) {
                        encrypt = true;
                    }
                    switch (type) {
                        case "bool": {
                            if (defaultValue.equalsIgnoreCase("true") || defaultValue.equalsIgnoreCase("false")) {
                                this.providerInfo.getConfig().addBoolean(setid, Boolean.valueOf(defaultValue).booleanValue());
                                break;
                            }
                            LOGGER.warn("This is not a boolean '" + setid + "=" + defaultValue + "' - ignoring");
                            break;
                        }
                        case "select": 
                        case "labelenum": {
                            this.providerInfo.getConfig().addSelect(setid, possibleValues, defaultValue);
                            break;
                        }
                        case "enum": {
                            this.providerInfo.getConfig().addSelectIndex(setid, possibleValues, defaultValue);
                            break;
                        }
                        case "text": {
                            this.providerInfo.getConfig().addText(setid, defaultValue, encrypt);
                            break;
                        }
                        default: {
                            continue block19;
                        }
                    }
                    if (!visible) {
                        this.providerInfo.getConfig().getConfigObject(setid).setVisible(visible);
                    }
                    if (labelName == null) continue;
                    this.providerInfo.getConfig().getConfigObject(setid).setKeyDescription(labelName);
                }
            }
            if ((savedSettings = new File(KodiUtil.detectKodiUserFolder(), "userdata/addon_data/" + this.providerInfo.getId() + "/settings.xml")).exists()) {
                Document set = Jsoup.parse((File)savedSettings, (String)"UTF-8", (String)"");
                Elements settings = set.getElementsByTag("setting");
                for (Element el : settings) {
                    String setid = el.attr("id");
                    String value = el.attr("value");
                    if (!this.providerInfo.getConfig().getConfigKeyValuePairs().keySet().contains(setid)) continue;
                    this.providerInfo.getConfig().setValue(setid, value);
                }
            }
            this.providerInfo.getConfig().load();
            File logo = new File(scraperFolder, "icon.png");
            if (logo.exists()) {
                this.providerInfo.setProviderLogo(logo.toURI().toURL());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addFunction(ScraperFunction func) {
        if (!this.functions.containsKey(func.getName())) {
            this.functions.put(func.getName(), func);
        }
    }

    public ScraperFunction getFunction(String name) {
        return this.functions.get(name);
    }

    public ScraperFunction[] getFunctions() {
        return this.functions.values().toArray(new ScraperFunction[this.functions.size()]);
    }

    public boolean containsFunction(String functionName) {
        return this.functions.containsKey(functionName);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public File getFolder() {
        return this.addonFolder;
    }

    public void setFolder(File folder) {
        this.addonFolder = folder;
    }

    public String getScraperXml() {
        return this.scraperXml;
    }

    public void setScraperXml(String scraperXml) {
        this.scraperXml = scraperXml;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.providerInfo.getId() == null ? 0 : this.providerInfo.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KodiScraper other = (KodiScraper)obj;
        return !(this.providerInfo.getId() == null ? other.providerInfo.getId() != null : !this.providerInfo.getId().equals(other.providerInfo.getId()));
    }
}

