/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.binding.xml.DescriptorBindingException;
import org.fourthline.cling.binding.xml.DeviceDescriptorBinder;
import org.fourthline.cling.binding.xml.ServiceDescriptorBinder;
import org.fourthline.cling.model.ValidationError;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Icon;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.transport.RouterException;
import org.seamless.util.Exceptions;

public class RetrieveRemoteDescriptors
implements Runnable {
    private static final Logger log = Logger.getLogger(RetrieveRemoteDescriptors.class.getName());
    private final UpnpService upnpService;
    private RemoteDevice rd;
    private static final Set<URL> activeRetrievals = new CopyOnWriteArraySet<URL>();
    protected List<UDN> errorsAlreadyLogged = new ArrayList<UDN>();

    public RetrieveRemoteDescriptors(UpnpService upnpService, RemoteDevice rd) {
        this.upnpService = upnpService;
        this.rd = rd;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public void run() {
        URL deviceURL = ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL();
        if (activeRetrievals.contains(deviceURL)) {
            log.finer("Exiting early, active retrieval for URL already in progress: " + deviceURL);
            return;
        }
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn(), true) != null) {
            log.finer("Exiting early, already discovered: " + deviceURL);
            return;
        }
        try {
            activeRetrievals.add(deviceURL);
            this.describe();
        }
        catch (RouterException ex) {
            log.log(Level.WARNING, "Descriptor retrieval failed: " + deviceURL, ex);
        }
        finally {
            activeRetrievals.remove(deviceURL);
        }
    }

    protected void describe() throws RouterException {
        String descriptorContent;
        StreamResponseMessage deviceDescMsg;
        if (this.getUpnpService().getRouter() == null) {
            log.warning("Router not yet initialized");
            return;
        }
        try {
            StreamRequestMessage deviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)this.rd.getIdentity());
            if (headers != null) {
                deviceDescRetrievalMsg.getHeaders().putAll((Map)((Object)headers));
            }
            log.fine("Sending device descriptor retrieval message: " + deviceDescRetrievalMsg);
            deviceDescMsg = this.getUpnpService().getRouter().send(deviceDescRetrievalMsg);
        }
        catch (IllegalArgumentException ex) {
            log.warning("Device descriptor retrieval failed: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL() + ", possibly invalid URL: " + ex);
            return;
        }
        if (deviceDescMsg == null) {
            log.warning("Device descriptor retrieval failed, no response: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        if (((UpnpResponse)deviceDescMsg.getOperation()).isFailed()) {
            log.warning("Device descriptor retrieval failed: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL() + ", " + ((UpnpResponse)deviceDescMsg.getOperation()).getResponseDetails());
            return;
        }
        if (!deviceDescMsg.isContentTypeTextUDA()) {
            log.fine("Received device descriptor without or with invalid Content-Type: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        }
        if ((descriptorContent = deviceDescMsg.getBodyString()) == null || descriptorContent.length() == 0) {
            log.warning("Received empty device descriptor:" + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        log.fine("Received root device descriptor: " + deviceDescMsg);
        this.describe(descriptorContent);
    }

    protected void describe(String descriptorXML) throws RouterException {
        block11: {
            boolean notifiedStart = false;
            RemoteDevice describedDevice = null;
            try {
                DeviceDescriptorBinder deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
                describedDevice = deviceDescriptorBinder.describe(this.rd, descriptorXML);
                log.fine("Remote device described (without services) notifying listeners: " + describedDevice);
                notifiedStart = this.getUpnpService().getRegistry().notifyDiscoveryStart(describedDevice);
                log.fine("Hydrating described device's services: " + describedDevice);
                RemoteDevice hydratedDevice = this.describeServices(describedDevice);
                if (hydratedDevice == null) {
                    if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                        this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                        log.warning("Device service description failed: " + this.rd);
                    }
                    if (notifiedStart) {
                        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, new DescriptorBindingException("Device service description failed: " + this.rd));
                    }
                    return;
                }
                log.fine("Adding fully hydrated remote device to registry: " + hydratedDevice);
                this.getUpnpService().getRegistry().addDevice(hydratedDevice);
            }
            catch (ValidationException ex) {
                if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                    this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                    log.warning("Could not validate device model: " + this.rd);
                    for (ValidationError validationError : ex.getErrors()) {
                        log.warning(validationError.toString());
                    }
                    if (describedDevice != null && notifiedStart) {
                        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
                    }
                }
            }
            catch (DescriptorBindingException ex) {
                log.warning("Could not hydrate device or its services from descriptor: " + this.rd);
                log.warning("Cause was: " + Exceptions.unwrap((Throwable)ex));
                if (describedDevice != null && notifiedStart) {
                    this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
                }
            }
            catch (RegistrationException ex) {
                log.warning("Adding hydrated device to registry failed: " + this.rd);
                log.warning("Cause was: " + ex.toString());
                if (describedDevice == null || !notifiedStart) break block11;
                this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
            }
        }
    }

    protected RemoteDevice describeServices(RemoteDevice currentDevice) throws RouterException, DescriptorBindingException, ValidationException {
        ArrayList<RemoteService> describedServices = new ArrayList<RemoteService>();
        if (currentDevice.hasServices()) {
            List<RemoteService> filteredServices = this.filterExclusiveServices(currentDevice.getServices());
            for (RemoteService service : filteredServices) {
                RemoteService svc = this.describeService(service);
                if (svc != null) {
                    describedServices.add(svc);
                    continue;
                }
                log.warning("Skipping invalid service '" + service + "' of: " + currentDevice);
            }
        }
        ArrayList<RemoteDevice> describedEmbeddedDevices = new ArrayList<RemoteDevice>();
        if (currentDevice.hasEmbeddedDevices()) {
            for (RemoteDevice embeddedDevice : currentDevice.getEmbeddedDevices()) {
                RemoteDevice describedEmbeddedDevice;
                if (embeddedDevice == null || (describedEmbeddedDevice = this.describeServices(embeddedDevice)) == null) continue;
                describedEmbeddedDevices.add(describedEmbeddedDevice);
            }
        }
        Icon[] iconDupes = new Icon[currentDevice.getIcons().length];
        for (int i = 0; i < currentDevice.getIcons().length; ++i) {
            Icon icon = currentDevice.getIcons()[i];
            iconDupes[i] = icon.deepCopy();
        }
        return currentDevice.newInstance(((RemoteDeviceIdentity)currentDevice.getIdentity()).getUdn(), currentDevice.getVersion(), currentDevice.getType(), currentDevice.getDetails(), iconDupes, currentDevice.toServiceArray((Collection<RemoteService>)describedServices), (List<RemoteDevice>)describedEmbeddedDevices);
    }

    protected RemoteService describeService(RemoteService service) throws RouterException, DescriptorBindingException, ValidationException {
        String descriptorContent;
        URL descriptorURL;
        try {
            descriptorURL = ((RemoteDevice)service.getDevice()).normalizeURI(service.getDescriptorURI());
        }
        catch (IllegalArgumentException e) {
            log.warning("Could not normalize service descriptor URL: " + service.getDescriptorURI());
            return null;
        }
        StreamRequestMessage serviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, descriptorURL);
        UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)((RemoteDevice)service.getDevice()).getIdentity());
        if (headers != null) {
            serviceDescRetrievalMsg.getHeaders().putAll((Map)((Object)headers));
        }
        log.fine("Sending service descriptor retrieval message: " + serviceDescRetrievalMsg);
        StreamResponseMessage serviceDescMsg = this.getUpnpService().getRouter().send(serviceDescRetrievalMsg);
        if (serviceDescMsg == null) {
            log.warning("Could not retrieve service descriptor, no response: " + service);
            return null;
        }
        if (((UpnpResponse)serviceDescMsg.getOperation()).isFailed()) {
            log.warning("Service descriptor retrieval failed: " + descriptorURL + ", " + ((UpnpResponse)serviceDescMsg.getOperation()).getResponseDetails());
            return null;
        }
        if (!serviceDescMsg.isContentTypeTextUDA()) {
            log.fine("Received service descriptor without or with invalid Content-Type: " + descriptorURL);
        }
        if ((descriptorContent = serviceDescMsg.getBodyString()) == null || descriptorContent.length() == 0) {
            log.warning("Received empty service descriptor:" + descriptorURL);
            return null;
        }
        log.fine("Received service descriptor, hydrating service model: " + serviceDescMsg);
        ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
        return serviceDescriptorBinder.describe(service, descriptorContent);
    }

    protected List<RemoteService> filterExclusiveServices(RemoteService[] services) {
        ServiceType[] exclusiveTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveTypes == null || exclusiveTypes.length == 0) {
            return Arrays.asList(services);
        }
        ArrayList<RemoteService> exclusiveServices = new ArrayList<RemoteService>();
        for (RemoteService discoveredService : services) {
            for (ServiceType exclusiveType : exclusiveTypes) {
                if (discoveredService.getServiceType().implementsVersion(exclusiveType)) {
                    log.fine("Including exclusive service: " + discoveredService);
                    exclusiveServices.add(discoveredService);
                    continue;
                }
                log.fine("Excluding unwanted service: " + exclusiveType);
            }
        }
        return exclusiveServices;
    }
}

