/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.a.a.a;
import com.a.c.s;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.b;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Resource {
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _marker;
    protected File _unpacked;
    protected boolean _unpack;
    protected boolean _isJar;
    protected boolean _isPacked200Jar;
    protected boolean _skipCache;
    protected static final Comparator<JarEntry> ENTRY_COMP = new b();
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    public Resource(String string, URL object, File file, boolean bl, boolean bl2) {
        this._path = string;
        this._remote = object;
        this._local = file;
        string = this._local.getPath();
        this._marker = new File(string + "v");
        this._unpack = bl;
        this._skipCache = bl2;
        this._isJar = Resource.isJar(string);
        this._isPacked200Jar = Resource.isPacked200Jar(string);
        if (this._unpack && this._isJar) {
            this._unpacked = this._local.getParentFile();
            return;
        }
        if (this._unpack && this._isPacked200Jar) {
            string = ".jar";
            object = this._local.getName();
            string = ((String)object).substring(0, ((String)object).lastIndexOf(string) + string.length());
            this._unpacked = new File(this._local.getParent(), string);
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        if (this.shouldUnpack()) {
            return this.getUnpacked();
        }
        return this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._unpack;
    }

    public String computeDigest(MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        return Resource.computeDigest(this._local, messageDigest, progressObserver);
    }

    public boolean isMarkedValid() {
        if (!this._skipCache) {
            if (!this._local.exists()) {
                this.clearMarker();
                return false;
            }
            return this._marker.exists();
        }
        this.clearMarker();
        return false;
    }

    public void markAsValid() throws IOException {
        if (!this._skipCache) {
            this._marker.createNewFile();
        }
    }

    public void clearMarker() {
        if (this._marker.exists() && !this._marker.delete()) {
            Log.log.b("Failed to erase marker file '" + this._marker + "'.", new Object[0]);
        }
    }

    public boolean unpack() {
        if (!this._isJar && !this._isPacked200Jar) {
            Log.log.b("Requested to unpack non-jar file '" + this._local + "'.", new Object[0]);
            return false;
        }
        try {
            if (this._isJar) {
                return FileUtil.unpackJar(new JarFile(this._local), this._unpacked);
            }
            return FileUtil.unpackPacked200Jar(this._local, this._unpacked);
        }
        catch (IOException iOException) {
            Log.log.b("Failed to create JarFile from '" + this._local + "': " + iOException, new Object[0]);
            return false;
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !this._local.delete()) {
            Log.log.b("Failed to erase resource '" + this._local + "'.", new Object[0]);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return this._path.equals(((Resource)object)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    public static String computeDigest(File file, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        block22: {
            int n2;
            byte[] byArray;
            block21: {
                messageDigest.reset();
                byArray = new byte[5125];
                n2 = Resource.isJar(file.getPath());
                boolean bl = Resource.isPacked200Jar(file.getPath());
                if (n2 == 0 && !bl) break block21;
                File file2 = null;
                JarFile jarFile = null;
                try {
                    if (bl) {
                        file2 = new File(file.getPath() + ".tmp");
                        FileUtil.unpackPacked200Jar(file, file2);
                        jarFile = new JarFile(file2);
                    } else {
                        jarFile = new JarFile(file);
                    }
                    ArrayList<JarEntry> arrayList = Collections.list(jarFile.entries());
                    Collections.sort(arrayList, ENTRY_COMP);
                    for (JarEntry jarEntry : arrayList) {
                        if (jarEntry.getName().startsWith("META-INF")) {
                            Resource.updateProgress(progressObserver, 0L, arrayList.size());
                            continue;
                        }
                        InputStream inputStream = null;
                        try {
                            int n3;
                            inputStream = jarFile.getInputStream(jarEntry);
                            while ((n3 = inputStream.read(byArray)) != -1) {
                                messageDigest.update(byArray, 0, n3);
                            }
                        }
                        finally {
                            a.a(inputStream);
                        }
                        Resource.updateProgress(progressObserver, 0L, arrayList.size());
                    }
                }
                catch (Throwable throwable) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            Log.log.b("Error closing jar", "path", file, "jar", jarFile, "error", iOException);
                        }
                    }
                    if (file2 != null) {
                        file2.delete();
                    }
                    throw throwable;
                }
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Log.log.b("Error closing jar", "path", file, "jar", jarFile, "error", iOException);
                }
                if (file2 != null) {
                    file2.delete();
                }
                break block22;
            }
            long l2 = file.length();
            long l3 = 0L;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n2);
                    Resource.updateProgress(progressObserver, l3 += (long)n2, l2);
                }
            }
            catch (Throwable throwable) {
                a.a(fileInputStream);
                throw throwable;
            }
            a.a(fileInputStream);
        }
        return s.a(messageDigest.digest());
    }

    protected static void updateProgress(ProgressObserver progressObserver, long l2, long l3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(100L * l2 / l3));
        }
    }

    protected static boolean isJar(String string) {
        return string.endsWith(".jar");
    }

    protected static boolean isPacked200Jar(String string) {
        return string.endsWith(".jar.pack") || string.endsWith(".jar.pack.gz");
    }
}

