/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util.math;

import org.seamless.util.math.Point;

public class Rectangle {
    private Point position;
    private int width;
    private int height;

    public Rectangle() {
    }

    public Rectangle(Point position, int width, int height) {
        this.position = position;
        this.width = width;
        this.height = height;
    }

    public void reset() {
        this.position = new Point(0, 0);
        this.width = 0;
        this.height = 0;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Rectangle intersection(Rectangle that) {
        int tx1 = this.position.getX();
        int ty1 = this.position.getY();
        int rx1 = that.position.getX();
        int ry1 = that.position.getY();
        long tx2 = tx1;
        tx2 += (long)this.width;
        long ty2 = ty1;
        ty2 += (long)this.height;
        long rx2 = rx1;
        rx2 += (long)that.width;
        long ry2 = ry1;
        ry2 += (long)that.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(new Point(tx1, ty1), (int)tx2, (int)ty2);
    }

    public boolean isOverlapping(Rectangle that) {
        Rectangle intersection = this.intersection(that);
        return intersection.getWidth() > 0 && intersection.getHeight() > 0;
    }

    public String toString() {
        return "Rectangle(" + this.position + " - " + this.width + "x" + this.height + ")";
    }
}

