/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbMovieParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbMovieParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Series|TV Episode|Short|Video Game)\\).*");
    private ImdbSiteDefinition imdbSite;

    public ImdbMovieParser(ImdbSiteDefinition imdbSite) {
        super(MediaType.MOVIE);
        this.imdbSite = imdbSite;
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected ImdbSiteDefinition getImdbSite() {
        return this.imdbSite;
    }

    @Override
    protected MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        return this.getMovieMetadata(options);
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt";
    }

    MediaMetadata getMovieMetadata(MediaScrapeOptions options) throws Exception {
        Elements elements;
        Element title;
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        if (options.getResult() != null && options.getResult().getMediaMetadata() != null) {
            LOGGER.debug("IMDB: getMetadata from cache: " + options.getResult());
            return options.getResult().getMediaMetadata();
        }
        String imdbId = "";
        if (options.getResult() != null) {
            imdbId = options.getResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            return md;
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): " + imdbId);
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        ExecutorCompletionService<Document> compSvcImdb = new ExecutorCompletionService<Document>(ImdbMetadataProvider.executor);
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
        StringBuilder sb = new StringBuilder(ImdbSiteDefinition.IMDB_COM.getSite());
        sb.append("title/");
        sb.append(imdbId);
        sb.append("/combined");
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, sb.toString(), options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futureCombined = compSvcImdb.submit(worker);
        sb = new StringBuilder(this.imdbSite.getSite());
        sb.append("title/");
        sb.append(imdbId);
        sb.append("/plotsummary");
        worker = new ImdbParser.ImdbWorker(this, sb.toString(), options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futurePlotsummary = compSvcImdb.submit(worker);
        Future<MediaMetadata> futureTmdb = null;
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdb").booleanValue() || ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo").booleanValue()) {
            ImdbParser.TmdbWorker worker2 = new ImdbParser.TmdbWorker(imdbId, options.getLanguage(), options.getCountry());
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        Document doc = futureCombined.get();
        this.parseCombinedPage(doc, options, md);
        doc = futurePlotsummary.get();
        this.parsePlotsummaryPage(doc, options, md);
        if (this.imdbSite != ImdbSiteDefinition.IMDB_COM && (title = doc.getElementById("tn15title")) != null && (elements = title.getElementsByClass("main")).size() > 0) {
            Element element = elements.first();
            String movieTitle = ImdbMetadataProvider.cleanString(element.ownText());
            md.setTitle(movieTitle);
        }
        if (md.getReleaseDate() == null || !ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("localReleaseDate").booleanValue()) {
            sb = new StringBuilder(this.imdbSite.getSite());
            sb.append("title/");
            sb.append(imdbId);
            sb.append("/releaseinfo");
            worker = new ImdbParser.ImdbWorker(this, sb.toString(), options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
            Future<Document> futureReleaseinfo = compSvcImdb.submit(worker);
            doc = futureReleaseinfo.get();
            this.parseReleaseinfoPage(doc, options, md);
        }
        if (futureTmdb != null && (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdb").booleanValue() || ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo").booleanValue())) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdb").booleanValue() && tmdbMd != null && StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                    md.setId("tmdb", tmdbMd.getId("tmdb"));
                    md.setTitle(tmdbMd.getTitle());
                    md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    md.setTagline(tmdbMd.getTagline());
                    md.setPlot(tmdbMd.getPlot());
                    md.setCollectionName(tmdbMd.getCollectionName());
                    md.setId("tmdbSet", tmdbMd.getId("tmdbSet"));
                }
                if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo").booleanValue() && tmdbMd != null) {
                    md.setId("tmdbSet", tmdbMd.getId("tmdbSet"));
                    md.setCollectionName(tmdbMd.getCollectionName());
                }
                md.setId(tmdbMd.getProviderId(), tmdbMd.getId(tmdbMd.getProviderId()));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)md.getOriginalTitle())) {
            md.setOriginalTitle(md.getTitle());
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        return md;
    }

    private MediaMetadata parseReleaseinfoPage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        Elements columns;
        Element tableReleaseDates = doc.getElementById("release_dates");
        if (tableReleaseDates != null && (columns = tableReleaseDates.getElementsByClass("release_date")) != null && !columns.isEmpty()) {
            Element td = columns.first();
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("d MMMM yyyy", Locale.US);
                Date parsedDate = sdf.parse(td.text());
                md.setReleaseDate(parsedDate);
            }
            catch (ParseException otherformat) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy", Locale.US);
                    Date parsedDate = sdf.parse(td.text());
                    md.setReleaseDate(parsedDate);
                }
                catch (ParseException ignored) {
                    // empty catch block
                }
            }
        }
        return md;
    }
}

