/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.fanarttv.FanartTv;
import org.tinymediamanager.scraper.fanarttv.entities.Image;
import org.tinymediamanager.scraper.fanarttv.entities.Images;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.ListUtils;

@PluginImplementation
public class FanartTvMetadataProvider
implements IMovieArtworkProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FanartTvMetadataProvider.class);
    private static MediaProviderInfo providerInfo = FanartTvMetadataProvider.createMediaProviderInfo();
    private FanartTv api = null;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("fanarttv", "fanart.tv", "<html><h3>Fanart.tv</h3><br />Fanart.tv provides a huge library of artwork for movies, TV shows and music.<br />Does not provide movie poster</html>", FanartTvMetadataProvider.class.getResource("/fanart_tv.png"));
        providerInfo.setVersion(FanartTvMetadataProvider.class);
        return providerInfo;
    }

    public FanartTvMetadataProvider() throws Exception {
        if (this.api == null) {
            try {
                this.api = new FanartTv(ApiKey.decryptApikey((String)"2gkQtSYPIxfyThxPXveHiCGXEcqJJwClUDrB5JV60OnQeQ85Ft65kFIk1SBKoge3"));
            }
            catch (Exception e) {
                LOGGER.error("FanartTvMetadataProvider", (Throwable)e);
                throw e;
            }
        }
        providerInfo.getConfig().addText("clientKey", "", true);
        providerInfo.getConfig().load();
        if (StringUtils.isNotBlank((CharSequence)providerInfo.getConfig().getValue("clientKey"))) {
            this.api.setClientKey(providerInfo.getConfig().getValue("clientKey"));
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws Exception {
        List<MediaArtwork> artwork;
        LOGGER.debug("getArtwork() " + options.toString());
        switch (options.getType()) {
            case MOVIE: 
            case MOVIE_SET: {
                artwork = this.getMovieArtwork(options);
                break;
            }
            case TV_SHOW: {
                artwork = this.getTvShowArtwork(options);
                break;
            }
            default: {
                artwork = new ArrayList<MediaArtwork>(1);
            }
        }
        MediaMetadata md = options.getMetadata();
        if (md != null && artwork.size() > 0) {
            md.addMediaArt(artwork);
        }
        return artwork;
    }

    private List<MediaArtwork> getMovieArtwork(MediaScrapeOptions options) throws Exception {
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        Images images = null;
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        if (StringUtils.isNotBlank((CharSequence)imdbId)) {
            try {
                LOGGER.debug("getArtwork with IMDB id: " + imdbId);
                images = this.api.getMovieService().getMovieImages(imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: " + e.getMessage());
            }
        }
        if (images == null && tmdbId != 0) {
            try {
                LOGGER.debug("getArtwork with TMDB id: " + tmdbId);
                images = this.api.getMovieService().getMovieImages(Integer.toString(tmdbId));
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: " + e.getMessage());
            }
        }
        if (images == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        returnArtwork = this.getArtwork(images, artworkType);
        Collections.sort(returnArtwork, new MediaArtwork.MediaArtworkComparator(language));
        return returnArtwork;
    }

    private List<MediaArtwork> getTvShowArtwork(MediaScrapeOptions options) throws Exception {
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        Images images = null;
        int tvdbId = 0;
        try {
            tvdbId = Integer.parseInt(options.getId("tvdb"));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (tvdbId == 0) {
            try {
                tvdbId = Integer.parseInt(options.getId("tvdb"));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (tvdbId > 0) {
            try {
                LOGGER.debug("getArtwork with TVDB id: " + tvdbId);
                images = this.api.getTvShowService().getTvShowImages(tvdbId);
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: " + e.getMessage());
            }
        } else {
            LOGGER.warn("not tvdbId set");
            return returnArtwork;
        }
        if (images == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        returnArtwork = this.getArtwork(images, artworkType);
        Collections.sort(returnArtwork, new MediaArtwork.MediaArtworkComparator(language));
        return returnArtwork;
    }

    private List<MediaArtwork> getArtwork(Images images, MediaArtwork.MediaArtworkType artworkType) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        switch (artworkType) {
            case POSTER: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                break;
            }
            case BACKGROUND: {
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                break;
            }
            case BANNER: {
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                break;
            }
            case CLEARART: {
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.movieart, ImageType.MOVIEART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                artworks.addAll(this.prepareArtwork(images.clearart, ImageType.CLEARART));
                break;
            }
            case DISC: {
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                break;
            }
            case LOGO: 
            case CLEARLOGO: {
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.movielogo, ImageType.MOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                artworks.addAll(this.prepareArtwork(images.clearlogo, ImageType.CLEARLOGO));
                break;
            }
            case SEASON: {
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                break;
            }
            case THUMB: {
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                break;
            }
            case ALL: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.movieart, ImageType.MOVIEART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                artworks.addAll(this.prepareArtwork(images.clearart, ImageType.CLEARART));
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.movielogo, ImageType.MOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                artworks.addAll(this.prepareArtwork(images.clearlogo, ImageType.CLEARLOGO));
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                break;
            }
        }
        return artworks;
    }

    private List<MediaArtwork> prepareArtwork(List<Image> images, ImageType type) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (Image image : ListUtils.nullSafe(images)) {
            MediaArtwork ma = new MediaArtwork(providerInfo.getId(), type.type);
            ma.setDefaultUrl(image.url);
            ma.setPreviewUrl(image.url.replace("/fanart/", "/preview/"));
            ma.setLanguage(image.lang);
            ma.setLikes(image.likes);
            ma.addImageSize(type.width, type.height, image.url);
            ma.setSizeOrder(type.sizeOrder);
            if ("all".equals(image.season)) {
                ma.setSeason(0);
            } else {
                try {
                    ma.setSeason(Integer.valueOf(image.season).intValue());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            artworks.add(ma);
            if (type.type != MediaArtwork.MediaArtworkType.CLEARLOGO) continue;
            artworks.add(new MediaArtwork(ma, MediaArtwork.MediaArtworkType.LOGO));
        }
        return artworks;
    }

    private static enum ImageType {
        HDMOVIECLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDCLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIETHUMB(1000, 562, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        SEASONTHUMB(500, 281, MediaArtwork.MediaArtworkType.SEASON, MediaArtwork.FanartSizes.SMALL.getOrder()),
        TVTHUMB(500, 281, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        SHOWBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        MOVIEPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        SEASONPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.SEASON, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        SEASONBANNER(1000, 185, MediaArtwork.MediaArtworkType.SEASON, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDMOVIELOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDTVLOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        CLEARLOGO(400, 155, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIELOGO(400, 155, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.SMALL.getOrder()),
        CLEARART(500, 281, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIEART(500, 281, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIEDISC(1000, 1000, MediaArtwork.MediaArtworkType.DISC, MediaArtwork.FanartSizes.MEDIUM.getOrder());

        int width;
        int height;
        MediaArtwork.MediaArtworkType type;
        int sizeOrder;

        private ImageType(int width, int height, MediaArtwork.MediaArtworkType type, int sizeOrder) {
            this.width = width;
            this.height = height;
            this.type = type;
            this.sizeOrder = sizeOrder;
        }
    }
}

