/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.fourthline.cling.model.meta.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTable;

public abstract class MediaFilesPanel
extends JPanel {
    private static final long serialVersionUID = -4929581173434859034L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFilesPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JScrollPane scrollPaneFiles;
    private JTable tableFiles;
    private EventList<MediaFile> mediaFileEventList;
    private DefaultEventTableModel<MediaFile> mediaFileTableModel = null;

    public MediaFilesPanel(EventList<MediaFile> mediaFiles) {
        this.mediaFileEventList = mediaFiles;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow")}));
        this.mediaFileTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.mediaFileEventList), (TableFormat)new MediaTableFormat());
        this.tableFiles = new ZebraJTable((TableModel)this.mediaFileTableModel);
        this.tableFiles.setAutoResizeMode(0);
        LinkListener linkListener = new LinkListener();
        this.tableFiles.addMouseListener(linkListener);
        this.tableFiles.addMouseMotionListener(linkListener);
        this.scrollPaneFiles = ZebraJTable.createStripedJScrollPane(this.tableFiles);
        this.add((Component)this.scrollPaneFiles, "1, 1, fill, fill");
        this.scrollPaneFiles.setViewportView(this.tableFiles);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.tableFiles.getColumnModel().getColumn(6).setCellRenderer(rightRenderer);
    }

    public void adjustColumns() {
        TableColumnResizer.adjustColumnPreferredWidths(this.tableFiles, 6);
    }

    public abstract MediaEntity getMediaEntity();

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            int col = MediaFilesPanel.this.tableFiles.columnAtPoint(arg0.getPoint());
            if (col == 0) {
                int row = MediaFilesPanel.this.tableFiles.rowAtPoint(arg0.getPoint());
                row = MediaFilesPanel.this.tableFiles.convertRowIndexToModel(row);
                MediaFile mf = (MediaFile)MediaFilesPanel.this.mediaFileEventList.get(row);
                if (mf.isVideo()) {
                    this.playVideo(mf, arg0);
                }
                if (mf.isGraphic()) {
                    MainWindow.getActiveInstance().createLightbox(mf.getFileAsPath().toString(), "");
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        private void playVideo(MediaFile mediaFile, MouseEvent arg0) {
            if (!Globals.settings.isUpnpRemotePlay()) {
                this.playLocal(mediaFile);
            } else {
                List<Device> upnpDevices = Upnp.getInstance().getAvailablePlayers();
                if (upnpDevices.isEmpty()) {
                    this.playLocal(mediaFile);
                } else {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new DeviceAction("System player", null, mediaFile));
                    menu.add(new JSeparator());
                    for (Device device : upnpDevices) {
                        menu.add(new DeviceAction(device.getDetails().getFriendlyName(), device, mediaFile));
                    }
                    int col = MediaFilesPanel.this.tableFiles.columnAtPoint(arg0.getPoint());
                    int row = MediaFilesPanel.this.tableFiles.rowAtPoint(arg0.getPoint());
                    row = MediaFilesPanel.this.tableFiles.convertRowIndexToModel(row);
                    Rectangle cellRect = MediaFilesPanel.this.tableFiles.getCellRect(row, col, true);
                    menu.show(arg0.getComponent(), cellRect.x, cellRect.y + cellRect.height);
                }
            }
        }

        private void playLocal(MediaFile mediaFile) {
            try {
                TmmUIHelper.openFile(mediaFile.getFileAsPath());
            }
            catch (Exception e) {
                LOGGER.error("open file", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mediaFile, "message.erroropenfile", new String[]{":", e.getLocalizedMessage()}));
            }
        }

        private void playViaUpnp(Device device, MediaFile mediaFile) {
            Upnp instance = Upnp.getInstance();
            instance.setPlayer(device);
            instance.playFile(MediaFilesPanel.this.getMediaEntity(), mediaFile);
        }

        private class DeviceAction
        extends AbstractAction {
            private Device device;
            private MediaFile mediaFile;

            private DeviceAction(String title, Device device, MediaFile mediaFile) {
                this.putValue("Name", title);
                this.device = device;
                this.mediaFile = mediaFile;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.device == null) {
                    LinkListener.this.playLocal(this.mediaFile);
                } else {
                    LinkListener.this.playViaUpnp(this.device, this.mediaFile);
                }
            }
        }
    }

    private static class MediaTableFormat
    implements AdvancedTableFormat<MediaFile> {
        private MediaTableFormat() {
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.filename");
                }
                case 2: {
                    return BUNDLE.getString("metatag.size");
                }
                case 3: {
                    return BUNDLE.getString("metatag.mediafiletype");
                }
                case 4: {
                    return BUNDLE.getString("metatag.codec");
                }
                case 5: {
                    return BUNDLE.getString("metatag.resolution");
                }
                case 6: {
                    return BUNDLE.getString("metatag.runtime");
                }
                case 7: {
                    return BUNDLE.getString("metatag.subtitle");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MediaFile mediaFile, int column) {
            switch (column) {
                case 0: {
                    if (mediaFile.isVideo()) {
                        return IconManager.PLAY_SMALL;
                    }
                    if (mediaFile.isGraphic()) {
                        return IconManager.SEARCH;
                    }
                    return null;
                }
                case 1: {
                    return mediaFile.getFilename();
                }
                case 2: {
                    return mediaFile.getFilesizeInMegabytes();
                }
                case 3: {
                    return this.getMediaFileTypeLocalized(mediaFile.getType());
                }
                case 4: {
                    return mediaFile.getCombinedCodecs();
                }
                case 5: {
                    return mediaFile.getVideoResolution();
                }
                case 6: {
                    return mediaFile.getDurationShort();
                }
                case 7: {
                    return mediaFile.getSubtitlesAsString();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }

        private String getMediaFileTypeLocalized(MediaFileType type) {
            String prop = "mediafiletype." + type.name().toLowerCase(Locale.ROOT);
            return BUNDLE.getString(prop);
        }
    }
}

