/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.moviesets.MovieSetTreeNode;
import org.tinymediamanager.ui.moviesets.MovieTreeNode;

public class MovieSetTreeCellRenderer
implements TreeCellRenderer {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private JPanel movieSetPanel = new JPanel();
    private JPanel moviePanel = new JPanel();
    private JLabel movieSetTitle = new JLabel();
    private JLabel movieTitle = new JLabel();
    private JLabel movieSetInfo = new JLabel();
    private JLabel movieSetImageLabel = new JLabel();
    private JLabel movieNfoLabel = new JLabel();
    private JLabel movieImageLabel = new JLabel();
    private DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public MovieSetTreeCellRenderer() {
        this.movieSetPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"min:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        TmmFontHelper.changeFont((JComponent)this.movieSetTitle, 1);
        this.movieSetTitle.setHorizontalAlignment(2);
        this.movieSetTitle.setMinimumSize(new Dimension(0, 0));
        this.movieSetPanel.add((Component)this.movieSetTitle, "1, 1");
        this.movieSetPanel.add((Component)this.movieSetImageLabel, "4, 1, 1, 2");
        TmmFontHelper.changeFont((JComponent)this.movieSetInfo, 0.816);
        this.movieSetInfo.setHorizontalAlignment(2);
        this.movieSetInfo.setMinimumSize(new Dimension(0, 0));
        this.movieSetPanel.add((Component)this.movieSetInfo, "1, 2");
        this.moviePanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"min:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        this.movieTitle.setMinimumSize(new Dimension(0, 0));
        this.moviePanel.add((Component)this.movieTitle, "1, 1");
        this.moviePanel.add((Component)this.movieNfoLabel, "3, 1");
        this.moviePanel.add((Component)this.movieImageLabel, "4, 1");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject;
        Component returnValue = null;
        if (value != null && value instanceof MovieSetTreeNode && (userObject = ((MovieSetTreeNode)value).getUserObject()) instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            if (StringUtils.isNotBlank((CharSequence)movieSet.getTitle())) {
                this.movieSetTitle.setText(movieSet.getTitle());
            } else {
                this.movieSetTitle.setText(BUNDLE.getString("tmm.unknowntitle"));
            }
            this.movieSetInfo.setText(movieSet.getMovies().size() + " Movies");
            this.movieSetImageLabel.setIcon(movieSet.getHasImages() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.movieSetPanel.setEnabled(tree.isEnabled());
            this.movieSetPanel.invalidate();
            returnValue = this.movieSetPanel;
        }
        if (value != null && value instanceof MovieTreeNode && (userObject = ((MovieTreeNode)value).getUserObject()) instanceof Movie) {
            Movie movie = (Movie)userObject;
            if (StringUtils.isNotBlank((CharSequence)movie.getTitle())) {
                this.movieTitle.setText(movie.getTitle());
            } else {
                this.movieTitle.setText(BUNDLE.getString("tmm.unknowntitle"));
            }
            this.movieNfoLabel.setIcon(movie.getHasNfoFile() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.movieImageLabel.setIcon(movie.getHasImages() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.moviePanel.setEnabled(tree.isEnabled());
            this.moviePanel.invalidate();
            returnValue = this.moviePanel;
        }
        if (returnValue == null) {
            returnValue = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (selected) {
            returnValue.setBackground(this.defaultRenderer.getBackgroundSelectionColor());
        } else {
            returnValue.setBackground(row % 2 == 0 ? EVEN_ROW_COLOR : Color.WHITE);
        }
        return returnValue;
    }
}

