/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTable;

public class MovieRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5039498266207230875L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private List<String> separators = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private EventList<MovieRenamerExample> exampleEventList = null;
    private JTextField tfMoviePath;
    private JTextField tfMovieFilename;
    private JLabel lblExample;
    private JCheckBox chckbxAsciiReplacement;
    private JCheckBox chckbxSpaceSubstitution;
    private JComboBox cbSeparator;
    private JComboBox cbMovieForPreview;
    private JCheckBox chckbxRemoveOtherNfos;
    private JCheckBox chckbxMoviesetSingleMovie;
    private ActionListener actionCreateRenamerExample = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieRenamerSettingsPanel.this.createRenamerExample();
        }
    };
    private JScrollPane scrollPane;
    private JTable tableExamples;
    private JPanel panelExample;
    private JLabel lblMMDWarning;
    private JLabel lblDefault1T;
    private JLabel lblDefaultFolderPattern;
    private JLabel lblDefault2T;
    private JLabel lblDefaultFilePattern;
    private JLabel lblSubtitleLanguage;
    private JComboBox<LanguageStyle> cbSubtitleLanguage;

    public MovieRenamerSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:default"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelRenamer = new JPanel();
        panelRenamer.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.movie.renamer.title"), 4, 2, null, null));
        this.add((Component)panelRenamer, "2, 2, fill, fill");
        panelRenamer.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"75dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow(3)"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.chckbxSpaceSubstitution = new JCheckBox(BUNDLE.getString("Settings.movie.renamer.spacesubstitution"));
        this.chckbxSpaceSubstitution.addActionListener(this.actionCreateRenamerExample);
        this.tfMoviePath = new JTextField();
        this.tfMoviePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        JLabel lblMoviePath = new JLabel(BUNDLE.getString("Settings.renamer.folder"));
        panelRenamer.add((Component)lblMoviePath, "2, 4, right, default");
        panelRenamer.add((Component)this.tfMoviePath, "4, 4, fill, default");
        this.tfMoviePath.setColumns(10);
        panelRenamer.add((Component)this.chckbxSpaceSubstitution, "8, 4");
        this.cbSeparator = new JComboBox<Object>(this.separators.toArray());
        panelRenamer.add((Component)this.cbSeparator, "10, 4, fill, default");
        this.cbSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MovieRenamerSettingsPanel.this.checkChanges();
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        this.lblDefault1T = new JLabel(BUNDLE.getString("Settings.default"));
        TmmFontHelper.changeFont((JComponent)this.lblDefault1T, 0.833);
        panelRenamer.add((Component)this.lblDefault1T, "2, 6, right, top");
        this.lblDefaultFolderPattern = new JLabel("$T { - $U }($Y)");
        TmmFontHelper.changeFont((JComponent)this.lblDefaultFolderPattern, 0.833);
        panelRenamer.add((Component)this.lblDefaultFolderPattern, "4, 6, default, top");
        this.chckbxMoviesetSingleMovie = new JCheckBox(BUNDLE.getString("Settings.renamer.moviesetsinglemovie"));
        this.chckbxMoviesetSingleMovie.addActionListener(this.actionCreateRenamerExample);
        panelRenamer.add((Component)this.chckbxMoviesetSingleMovie, "8, 6, 5, 1, fill, default");
        this.lblMMDWarning = new JLabel(BUNDLE.getString("Settings.renamer.folder.warning"));
        panelRenamer.add((Component)this.lblMMDWarning, "2, 8, 11, 1");
        JLabel lblMovieFilename = new JLabel(BUNDLE.getString("Settings.renamer.file"));
        panelRenamer.add((Component)lblMovieFilename, "2, 10, right, fill");
        this.tfMovieFilename = new JTextField();
        this.tfMovieFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        panelRenamer.add((Component)this.tfMovieFilename, "4, 10, fill, default");
        this.tfMovieFilename.setColumns(10);
        lblMovieFilename.setLabelFor(this.tfMovieFilename);
        this.chckbxAsciiReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.asciireplacement"));
        this.chckbxAsciiReplacement.addActionListener(this.actionCreateRenamerExample);
        panelRenamer.add((Component)this.chckbxAsciiReplacement, "8, 10, 5, 1");
        this.lblDefault2T = new JLabel(BUNDLE.getString("Settings.default"));
        TmmFontHelper.changeFont((JComponent)this.lblDefault2T, 0.833);
        panelRenamer.add((Component)this.lblDefault2T, "2, 12, right, top");
        this.lblDefaultFilePattern = new JLabel("$T { - $U }($Y) $V $A");
        TmmFontHelper.changeFont((JComponent)this.lblDefaultFilePattern, 0.833);
        panelRenamer.add((Component)this.lblDefaultFilePattern, "4, 12, default, top");
        JTextPane txtpntAsciiHint = new JTextPane();
        txtpntAsciiHint.setOpaque(false);
        txtpntAsciiHint.setEditable(false);
        txtpntAsciiHint.setText(BUNDLE.getString("Settings.renamer.asciireplacement.hint"));
        TmmFontHelper.changeFont((JComponent)txtpntAsciiHint, 0.833);
        txtpntAsciiHint.setBackground(UIManager.getColor("Panel.background"));
        panelRenamer.add((Component)txtpntAsciiHint, "8, 12, 5, 1, fill, fill");
        JTextPane txtrChooseAFolder = new JTextPane();
        txtrChooseAFolder.setOpaque(false);
        txtrChooseAFolder.setEditable(false);
        TmmFontHelper.changeFont((JComponent)txtrChooseAFolder, 0.833);
        txtrChooseAFolder.setText(BUNDLE.getString("Settings.movie.renamer.example"));
        txtrChooseAFolder.setBackground(UIManager.getColor("Panel.background"));
        panelRenamer.add((Component)txtrChooseAFolder, "2, 14, 3, 3, fill, top");
        this.chckbxRemoveOtherNfos = new JCheckBox(BUNDLE.getString("Settings.renamer.removenfo"));
        panelRenamer.add((Component)this.chckbxRemoveOtherNfos, "8, 14, 5, 1");
        this.lblSubtitleLanguage = new JLabel(BUNDLE.getString("Settings.renamer.language"));
        panelRenamer.add((Component)this.lblSubtitleLanguage, "8, 16, right, default");
        this.cbSubtitleLanguage = new JComboBox<LanguageStyle>(LanguageStyle.values());
        panelRenamer.add(this.cbSubtitleLanguage, "10, 16, 3, 1, fill, default");
        this.exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieRenamerExample.class)));
        DefaultEventTableModel exampleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), (TableFormat)new MovieRenamerExampleTableFormat());
        this.panelExample = new JPanel();
        this.panelExample.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.example"), 4, 2, null, null));
        this.add((Component)this.panelExample, "2, 4, fill, fill");
        this.panelExample.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50dlu:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblExampleT = new JLabel(BUNDLE.getString("tmm.movie"));
        this.panelExample.add((Component)lblExampleT, "2, 2");
        this.cbMovieForPreview = new JComboBox();
        this.panelExample.add((Component)this.cbMovieForPreview, "4, 2");
        this.lblExample = new JLabel("");
        this.panelExample.add((Component)this.lblExample, "2, 4, 3, 1");
        TmmFontHelper.changeFont(this.lblExample, 0.916, 1);
        this.tableExamples = new ZebraJTable((TableModel)exampleTableModel);
        this.scrollPane = ZebraJTable.createStripedJScrollPane(this.tableExamples);
        this.scrollPane.setViewportView(this.tableExamples);
        this.panelExample.add((Component)this.scrollPane, "2, 6, 3, 1, fill, fill");
        JTextPane txtpntTitle = new JTextPane();
        txtpntTitle.setOpaque(false);
        this.panelExample.add((Component)txtpntTitle, "2, 8, 3, 1");
        TmmFontHelper.changeFont((JComponent)txtpntTitle, 0.833);
        txtpntTitle.setBackground(UIManager.getColor("Panel.background"));
        txtpntTitle.setText(BUNDLE.getString("Settings.movie.renamer.optional"));
        txtpntTitle.setEditable(false);
        this.cbMovieForPreview.addActionListener(this.actionCreateRenamerExample);
        this.initDataBindings();
        String replacement = this.settings.getMovieRenamerSpaceReplacement();
        int index = this.separators.indexOf(replacement);
        if (index >= 0) {
            this.cbSeparator.setSelectedIndex(index);
        }
        this.cbSubtitleLanguage.setSelectedItem((Object)this.settings.getMovieRenamerLanguageStyle());
        this.exampleEventList.add((Object)new MovieRenamerExample("$T"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$O"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$1"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$E"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$2"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$Y"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$M"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$N"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$I"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$C"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$D"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$G"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$L"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$R"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$A"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$V"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$F"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$S"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$#"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$3"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$U"));
        this.exampleEventList.add((Object)new MovieRenamerExample("$K"));
    }

    private void buildAndInstallMovieArray() {
        this.cbMovieForPreview.removeAllItems();
        ArrayList<Movie> allMovies = new ArrayList<Movie>(MovieList.getInstance().getMovies());
        Collections.sort(allMovies, new MovieComparator());
        for (Movie movie : allMovies) {
            MoviePreviewContainer container = new MoviePreviewContainer();
            container.movie = movie;
            this.cbMovieForPreview.addItem(container);
        }
    }

    private void createRenamerExample() {
        Movie movie = null;
        if (!this.tfMoviePath.getText().isEmpty() && !MovieRenamer.isFolderPatternUnique(this.tfMoviePath.getText())) {
            this.lblMMDWarning.setText(BUNDLE.getString("Settings.renamer.folder.warning"));
            this.lblMMDWarning.setForeground(Color.red);
        } else {
            this.lblMMDWarning.setText("");
        }
        if (this.cbMovieForPreview.getSelectedItem() instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)this.cbMovieForPreview.getSelectedItem();
            movie = container.movie;
        }
        if (movie != null) {
            String path = "";
            String filename = "";
            path = StringUtils.isNotBlank((CharSequence)this.tfMoviePath.getText()) ? MovieRenamer.createDestinationForFoldername(this.tfMoviePath.getText(), movie) : movie.getPathNIO().getFileName().toString();
            if (StringUtils.isNotBlank((CharSequence)this.tfMovieFilename.getText())) {
                List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO);
                if (mediaFiles.size() > 0) {
                    String extension = FilenameUtils.getExtension((String)mediaFiles.get(0).getFilename());
                    filename = MovieRenamer.createDestinationForFilename(this.tfMovieFilename.getText(), movie) + "." + extension;
                }
            } else {
                filename = movie.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
            }
            this.lblExample.setText(movie.getDataSource() + File.separator + path + File.separator + filename);
            for (MovieRenamerExample example : this.exampleEventList) {
                example.createExample(movie);
            }
            try {
                TableColumnResizer.adjustColumnPreferredWidths(this.tableExamples, 7);
            }
            catch (Exception e) {}
        } else {
            this.lblExample.setText(BUNDLE.getString("Settings.movie.renamer.nomovie"));
        }
    }

    private void checkChanges() {
        String separator = (String)this.cbSeparator.getSelectedItem();
        this.settings.setMovieRenamerSpaceReplacement(separator);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallMovieArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"movieRenamerPathname");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.tfMoviePath, (Property)jTextFieldBeanProperty_3);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"movieRenamerFilename");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieFilename, (Property)jTextFieldBeanProperty_4);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"movieRenamerSpaceSubstitution");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxSpaceSubstitution, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"movieRenamerNfoCleanup");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxRemoveOtherNfos, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"movieRenamerCreateMoviesetForSingleMovie");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxMoviesetSingleMovie, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"asciiReplacement");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"movieRenamerLanguageStyle");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbSubtitleLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
    }

    private class MovieRenamerExampleTableFormat
    implements TableFormat<MovieRenamerExample> {
        private MovieRenamerExampleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    return BUNDLE.getString("Settings.renamer.token");
                }
                case 2: {
                    return BUNDLE.getString("Settings.renamer.value");
                }
            }
            return null;
        }

        public Object getColumnValue(MovieRenamerExample baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.token;
                }
                case 1: {
                    return baseObject.description;
                }
                case 2: {
                    return baseObject.example;
                }
            }
            return null;
        }
    }

    private class MovieRenamerExample
    extends AbstractModelObject {
        private String token;
        private String description;
        private String example = "";

        public MovieRenamerExample(String token) {
            this.token = token;
            try {
                this.description = BUNDLE.getString("Settings.movie.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(Movie movie) {
            String oldValue = this.example;
            this.example = movie == null ? "" : MovieRenamer.createDestination(this.token, movie, true);
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private class MovieComparator
    implements Comparator<Movie> {
        private MovieComparator() {
        }

        @Override
        public int compare(Movie arg0, Movie arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private class MoviePreviewContainer {
        Movie movie;

        private MoviePreviewContainer() {
        }

        public String toString() {
            return this.movie.getTitle();
        }
    }
}

