/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask2;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieUpdateAction
extends AbstractAction {
    private static final long serialVersionUID = 6885253964781733478L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieUpdateAction() {
        this.putValue("Name", BUNDLE.getString("movie.update"));
        this.putValue("SmallIcon", IconManager.REFRESH);
        this.putValue("SwingLargeIconKey", IconManager.REFRESH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            return;
        }
        MovieUpdateDatasourceTask2 task = new MovieUpdateDatasourceTask2(selectedMovies);
        if (TmmTaskManager.getInstance().addMainTask(task)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

