/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieComparator;

public class MovieTableFormat
implements AdvancedTableFormat<Movie> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Comparator<Movie> movieComparator = new MovieComparator();
    private Comparator<String> stringComparator = new StringComparator();
    private Comparator<Float> floatComparator = new FloatComparator();
    private Comparator<ImageIcon> imageComparator = new ImageComparator();
    private Comparator<Date> dateComparator = new DateComparator();

    public int getColumnCount() {
        return 10;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return BUNDLE.getString("metatag.title");
            }
            case 1: {
                return BUNDLE.getString("metatag.year");
            }
            case 2: {
                return BUNDLE.getString("metatag.rating");
            }
            case 3: {
                return BUNDLE.getString("metatag.dateadded");
            }
            case 4: {
                return BUNDLE.getString("metatag.nfo");
            }
            case 5: {
                return BUNDLE.getString("tmm.metadata");
            }
            case 6: {
                return BUNDLE.getString("metatag.images");
            }
            case 7: {
                return BUNDLE.getString("metatag.trailer");
            }
            case 8: {
                return BUNDLE.getString("metatag.subtitles");
            }
            case 9: {
                return BUNDLE.getString("metatag.watched");
            }
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(Movie movie, int column) {
        switch (column) {
            case 0: {
                return movie;
            }
            case 1: {
                return movie.getYear();
            }
            case 2: {
                return Float.valueOf(movie.getRating());
            }
            case 3: {
                return movie.getDateAdded();
            }
            case 4: {
                if (movie.getHasNfoFile().booleanValue()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
            case 5: {
                if (movie.getHasMetadata().booleanValue()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
            case 6: {
                if (movie.getHasImages().booleanValue()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
            case 7: {
                if (movie.getHasTrailer().booleanValue()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
            case 8: {
                if (movie.hasSubtitles()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
            case 9: {
                if (movie.isWatched()) {
                    return IconManager.CHECKMARK;
                }
                return IconManager.CROSS;
            }
        }
        throw new IllegalStateException();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Movie.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Float.class;
            }
            case 3: {
                return Date.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ImageIcon.class;
            }
        }
        throw new IllegalStateException();
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return this.movieComparator;
            }
            case 1: {
                return this.stringComparator;
            }
            case 2: {
                return this.floatComparator;
            }
            case 3: {
                return this.dateComparator;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.imageComparator;
            }
        }
        throw new IllegalStateException();
    }

    private static class DateComparator
    implements Comparator<Date> {
        private DateComparator() {
        }

        @Override
        public int compare(Date arg0, Date arg1) {
            return arg0.compareTo(arg1);
        }
    }

    private static class ImageComparator
    implements Comparator<ImageIcon> {
        private ImageComparator() {
        }

        @Override
        public int compare(ImageIcon arg0, ImageIcon arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == IconManager.CHECKMARK) {
                return 1;
            }
            return -1;
        }
    }

    private static class FloatComparator
    implements Comparator<Float> {
        private FloatComparator() {
        }

        @Override
        public int compare(Float arg0, Float arg1) {
            return arg0.compareTo(arg1);
        }
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            if (StringUtils.isEmpty((CharSequence)arg0)) {
                return -1;
            }
            if (StringUtils.isEmpty((CharSequence)arg1)) {
                return 1;
            }
            return arg0.toLowerCase(Locale.ROOT).compareTo(arg1.toLowerCase(Locale.ROOT));
        }
    }
}

