/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ParserUtils;

@XmlRootElement(name="movie")
@XmlSeeAlso(value={Actor.class, MovieSets.class, Producer.class})
@XmlType(propOrder={"title", "originaltitle", "sorttitle", "sets", "set", "rating", "year", "votes", "outline", "plot", "tagline", "runtime", "thumb", "fanart", "mpaa", "imdb", "ids", "genres", "genresNoWrap", "studio", "country", "premiered", "credits", "director", "actors", "producers", "language", "watched", "playcount", "source", "edition"})
public class MovieToMpNfoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToMpNfoConnector.class);
    private static JAXBContext context = MovieToMpNfoConnector.initContext();
    public String title = "";
    public String originaltitle = "";
    public String sorttitle = "";
    @XmlElementWrapper
    @XmlElement(name="set", type=MovieSets.class)
    @Deprecated
    public List<MovieSets> sets;
    public String set = "";
    public float rating = 0.0f;
    public String year = "";
    public int votes = 0;
    public String outline = "";
    public String plot = "";
    public String tagline = "";
    public String runtime = "";
    public String thumb = "";
    @XmlElementWrapper
    @XmlElement(name="thumb")
    public List<String> fanart;
    public String mpaa = "";
    public String imdb = "";
    @XmlElementWrapper(name="ids")
    public Map<String, Object> ids;
    @XmlElementWrapper
    @XmlElement(name="genre")
    public List<String> genres;
    @XmlElement(name="genre")
    public List<String> genresNoWrap;
    public String studio = "";
    public String country = "";
    public String premiered = "";
    public String credits = "";
    public String director = "";
    @XmlAnyElement(lax=true)
    private List<Object> actors = new ArrayList<Object>();
    @XmlAnyElement(lax=true)
    private List<Object> producers = new ArrayList<Object>();
    public String language = "";
    public boolean watched = false;
    public int playcount = 0;
    public String source = "";
    public String edition;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{MovieToMpNfoConnector.class, Actor.class});
        }
        catch (JAXBException e) {
            LOGGER.error("Error instantiating JaxB", (Throwable)e);
            return null;
        }
    }

    public MovieToMpNfoConnector() {
        this.genres = new ArrayList<String>();
        this.genresNoWrap = new ArrayList<String>();
        this.fanart = new ArrayList<String>();
        this.sets = new ArrayList<MovieSets>();
        this.ids = new HashMap<String, Object>();
    }

    public static void setData(Movie movie) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{":", "Context is null"}));
            return;
        }
        MovieToMpNfoConnector mp = MovieToMpNfoConnector.createInstanceFromMovie(movie);
        ArrayList<MovieNfoNaming> nfoNames = new ArrayList<MovieNfoNaming>();
        if (movie.isMultiMovieDir()) {
            nfoNames.add(MovieNfoNaming.FILENAME_NFO);
        } else {
            nfoNames = MovieModuleManager.MOVIE_SETTINGS.getMovieNfoFilenames();
        }
        MovieToMpNfoConnector.writeNfoFiles(movie, mp, nfoNames);
    }

    static MovieToMpNfoConnector createInstanceFromMovie(Movie movie) {
        MovieToMpNfoConnector mp = new MovieToMpNfoConnector();
        mp.title = movie.getTitle();
        mp.originaltitle = movie.getOriginalTitle();
        mp.sorttitle = movie.getSortTitle();
        if (StringUtils.isBlank((CharSequence)mp.sorttitle)) {
            mp.sorttitle = movie.getTitleSortable();
        }
        mp.rating = movie.getRating();
        mp.votes = movie.getVotes();
        mp.year = movie.getYear();
        mp.premiered = movie.getReleaseDateFormatted();
        mp.plot = movie.getPlot();
        if (StringUtils.isNotBlank((CharSequence)mp.plot) && mp.plot.length() > 200) {
            int spaceIndex = mp.plot.indexOf(" ", 200);
            mp.outline = spaceIndex > 0 ? mp.plot.substring(0, spaceIndex) + "..." : mp.plot;
        } else if (StringUtils.isNotBlank((CharSequence)mp.plot)) {
            mp.outline = mp.plot;
        }
        mp.tagline = movie.getTagline();
        mp.runtime = String.valueOf(movie.getRuntime());
        mp.thumb = FilenameUtils.getName((String)movie.getArtworkFilename(MediaFileType.POSTER));
        List<MediaFile> extrafanarts = movie.getMediaFiles(MediaFileType.EXTRAFANART);
        if (extrafanarts.size() > 0) {
            for (int i = 0; i < extrafanarts.size(); ++i) {
                MediaFile mf = extrafanarts.get(i);
                Path fanart = mf.getFileAsPath();
                String fanartPath = movie.getPathNIO().relativize(fanart).toString();
                mp.fanart.add(fanartPath);
                if (i != 4) {
                    continue;
                }
                break;
            }
        } else {
            mp.fanart.add(FilenameUtils.getName((String)movie.getArtworkFilename(MediaFileType.FANART)));
        }
        mp.imdb = movie.getImdbId();
        mp.ids.putAll(movie.getIds());
        mp.studio = movie.getProductionCompany();
        mp.country = movie.getCountry();
        Locale uiLanguage = Locale.getDefault();
        ArrayList<String> languages = new ArrayList<String>();
        for (String langu : movie.getSpokenLanguages().split(",")) {
            Locale locale = new Locale(langu = langu.trim());
            String languageLocalized = locale.getDisplayLanguage(uiLanguage);
            if (StringUtils.isNotBlank((CharSequence)languageLocalized) && !langu.equalsIgnoreCase(languageLocalized)) {
                languages.add(languageLocalized);
                continue;
            }
            languages.add(langu);
        }
        mp.language = StringUtils.join((Object[])languages.toArray(), (char)'|');
        mp.watched = movie.isWatched();
        mp.playcount = mp.watched ? 1 : 0;
        if (movie.getCertification() != null) {
            mp.mpaa = CertificationStyle.formatCertification(movie.getCertification(), MovieModuleManager.MOVIE_SETTINGS.getMovieCertificationStyle());
        }
        if (movie.getMediaSource() != MediaSource.UNKNOWN) {
            mp.source = movie.getMediaSource().name();
        }
        if (movie.getEdition() != MovieEdition.NONE) {
            mp.edition = movie.getEdition().getTitle();
        }
        mp.director = movie.getDirector();
        mp.credits = movie.getWriter();
        for (MovieActor cast : movie.getActors()) {
            mp.addActor(cast.getName(), cast.getCharacter(), cast.getThumbUrl());
        }
        for (MovieProducer producer : movie.getProducers()) {
            mp.addProducer(producer.getName(), producer.getRole(), producer.getThumbUrl());
        }
        for (MediaGenres genre : movie.getGenres()) {
            mp.genres.add(genre.toString());
        }
        if (movie.getMovieSet() != null) {
            MovieSet movieSet = movie.getMovieSet();
            mp.set = movieSet.getTitle();
        } else {
            mp.set = "";
        }
        return mp;
    }

    static void writeNfoFiles(Movie movie, MovieToMpNfoConnector mp, List<MovieNfoNaming> nfoNames) {
        String nfoFilename = "";
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieNfoNaming name : nfoNames) {
            try {
                nfoFilename = movie.getNfoFilename(name);
                if (nfoFilename.isEmpty()) continue;
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                String comment = "<!-- created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion() + " -->\n";
                m.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)comment);
                StringWriter w = new StringWriter();
                m.marshal((Object)mp, (Writer)w);
                StringBuilder sb = new StringBuilder(((Object)w).toString());
                ((Writer)w).close();
                if (SystemUtils.IS_OS_WINDOWS) {
                    sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
                }
                Path f = movie.getPathNIO().resolve(nfoFilename);
                Utils.writeStringToFile(f, sb.toString());
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("setData " + movie.getPathNIO().resolve(nfoFilename), (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{e.getLocalizedMessage()}));
            }
        }
        if (newNfos.size() > 0) {
            movie.removeAllMediaFiles(MediaFileType.NFO);
            movie.addToMediaFiles(newNfos);
        }
    }

    public static Movie getData(Path nfoFilename) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFilename, "message.nfo.readerror"));
            return null;
        }
        Movie movie = null;
        try {
            MediaGenres genreFound;
            MovieList movieList;
            MovieSet movieSet;
            MovieToMpNfoConnector mp = MovieToMpNfoConnector.parseNFO(nfoFilename);
            movie = new Movie();
            movie.setTitle(mp.title);
            movie.setOriginalTitle(mp.originaltitle);
            movie.setSortTitle(mp.sorttitle);
            movie.setRating(mp.rating);
            movie.setVotes(mp.votes);
            movie.setYear(mp.year);
            movie.setReleaseDate(mp.premiered);
            movie.setPlot(mp.plot);
            movie.setTagline(mp.tagline);
            try {
                String rt = mp.runtime.replaceAll("[^0-9]", "");
                movie.setRuntime(Integer.parseInt(rt));
            }
            catch (Exception e) {
                LOGGER.warn("could not parse runtime: " + mp.runtime);
            }
            for (Map.Entry<String, Object> entry : mp.ids.entrySet()) {
                try {
                    if ("imdbId".equals(entry.getKey())) {
                        movie.setId("imdb", entry.getValue());
                        continue;
                    }
                    if ("tmdbId".equals(entry.getKey())) {
                        movie.setId("tmdb", entry.getValue());
                        continue;
                    }
                    movie.setId(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    LOGGER.warn("could not set ID: " + entry.getKey() + " ; " + entry.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)movie.getImdbId())) {
                movie.setImdbId(mp.imdb);
            }
            movie.setDirector(mp.director);
            movie.setWriter(mp.credits);
            movie.setProductionCompany(mp.studio);
            movie.setCountry(mp.country);
            movie.setWatched(mp.watched);
            if (mp.playcount > 0) {
                movie.setWatched(true);
            }
            ArrayList<String> languages = new ArrayList<String>();
            for (String langu : mp.language.split("\\|")) {
                String languIso = LanguageUtils.getIso2LanguageFromLocalizedString((String)(langu = langu.trim()));
                if (StringUtils.isNotBlank((CharSequence)languIso)) {
                    languages.add(languIso);
                    continue;
                }
                languages.add(langu);
            }
            movie.setSpokenLanguages(StringUtils.join((Object[])languages.toArray(), (String)", "));
            if (!StringUtils.isEmpty((CharSequence)mp.mpaa)) {
                movie.setCertification(MovieHelpers.parseCertificationStringForMovieSetupCountry(mp.mpaa));
            }
            if (StringUtils.isNotBlank((CharSequence)mp.source)) {
                try {
                    MediaSource source = MediaSource.valueOf(mp.source);
                    if (source != null) {
                        movie.setMediaSource(source);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)mp.edition)) {
                MovieEdition edition = MovieEdition.getMovieEditionFromString(mp.edition);
                movie.setEdition(edition);
            }
            if (mp.sets != null && !mp.sets.isEmpty()) {
                MovieSets sets = mp.sets.get(0);
                MovieList movieList2 = MovieList.getInstance();
                MovieSet movieSet2 = movieList2.getMovieSet(sets.name, 0);
                if (movieSet2 != null) {
                    movie.setMovieSet(movieSet2);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)mp.set) && (movieSet = (movieList = MovieList.getInstance()).getMovieSet(mp.set, 0)) != null) {
                movie.setMovieSet(movieSet);
            }
            for (Actor actor : mp.getActors()) {
                MovieActor cast = new MovieActor(actor.name, actor.role);
                cast.setThumbUrl(actor.thumb);
                movie.addActor(cast);
            }
            for (Producer producer : mp.getProducers()) {
                MovieProducer cast = new MovieProducer(producer.name, producer.role);
                cast.setThumbUrl(producer.thumb);
                movie.addProducer(cast);
            }
            for (String genre : mp.genres) {
                String[] genres;
                for (String g : genres = genre.split("/")) {
                    genreFound = MediaGenres.getGenre((String)g.trim());
                    if (genreFound == null) continue;
                    movie.addGenre(genreFound);
                }
            }
            for (String genre : mp.genresNoWrap) {
                String[] genres;
                for (String g : genres = genre.split("/")) {
                    genreFound = MediaGenres.getGenre((String)g.trim());
                    if (genreFound == null) continue;
                    movie.addGenre(genreFound);
                }
            }
        }
        catch (UnmarshalException e) {
            LOGGER.error("getData " + nfoFilename, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("getData " + nfoFilename, (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)movie.getTitle())) {
            return null;
        }
        return movie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MovieToMpNfoConnector parseNFO(Path nfoFile) throws Exception {
        Unmarshaller um = context.createUnmarshaller();
        if (um == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            throw new Exception("could not create unmarshaller");
        }
        MovieToMpNfoConnector mp = null;
        try (Reader in = null;){
            in = new InputStreamReader((InputStream)new FileInputStream(nfoFile.toFile()), "UTF-8");
            mp = (MovieToMpNfoConnector)um.unmarshal(in);
        }
        if (mp == null) {
            String completeNFO = Utils.readFileToString(nfoFile).trim().replaceFirst("^([\\W]+)<", "<");
            completeNFO = completeNFO.replace("<movie>", "<movie xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            try {
                in = new StringReader(ParserUtils.cleanNfo(completeNFO));
                mp = (MovieToMpNfoConnector)um.unmarshal(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return mp;
    }

    public void addActor(String name, String role, String thumb) {
        Actor actor = new Actor(name, role, thumb);
        this.actors.add(actor);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> pureActors = new ArrayList<Actor>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Actor)) continue;
            Actor actor = (Actor)obj;
            pureActors.add(actor);
        }
        return pureActors;
    }

    private void addProducer(String name, String role, String thumb) {
        Producer producer = new Producer(name, role, thumb);
        this.producers.add(producer);
    }

    public List<Producer> getProducers() {
        ArrayList<Producer> pureProducers = new ArrayList<Producer>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Producer)) continue;
            Producer producer = (Producer)obj;
            pureProducers.add(producer);
        }
        return pureProducers;
    }

    public static class MovieSets {
        @XmlValue
        public String name;
        @XmlAttribute(name="order")
        public int order;

        public MovieSets() {
        }

        public MovieSets(String name, int order) {
            this.name = name;
            this.order = order;
        }
    }

    @XmlRootElement(name="producer")
    public static class Producer {
        public String name;
        public String role;
        public String thumb;

        public Producer() {
        }

        public Producer(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }

    @XmlRootElement(name="actor")
    public static class Actor {
        public String name;
        public String role;
        public String thumb;

        public Actor() {
        }

        public Actor(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }
}

