/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.EmptyFileException;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.ui.UTF8Control;

public class ImageCacheTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCacheTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Path> filesToCache = new ArrayList<Path>();

    public ImageCacheTask(String pathToFile) {
        super(BUNDLE.getString("tmm.rebuildimagecache"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.filesToCache.add(Paths.get(pathToFile, new String[0]));
    }

    @Deprecated
    public ImageCacheTask(File file) {
        super(BUNDLE.getString("tmm.rebuildimagecache"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.filesToCache.add(file.toPath());
    }

    public ImageCacheTask(Path file) {
        super(BUNDLE.getString("tmm.rebuildimagecache"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.filesToCache.add(file);
    }

    public ImageCacheTask(List<Path> files) {
        super(BUNDLE.getString("tmm.rebuildimagecache"), files.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.filesToCache.addAll(files);
    }

    @Override
    protected void doInBackground() {
        int i = 0;
        for (Path fileToCache : this.filesToCache) {
            try {
                if (this.cancel) {
                    return;
                }
                this.publishState(++i);
                ImageCache.cacheImage(fileToCache);
            }
            catch (EmptyFileException e) {
                LOGGER.warn("failed to cache file (file is empty): " + fileToCache);
            }
            catch (Exception e) {
                LOGGER.warn("failed to cache file: " + fileToCache);
            }
        }
    }
}

