/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.diagnosis.local.impl;

import java.io.Serializable;
import net.jcores.jre.CoreKeeper;
import net.xeoh.plugins.diagnosis.local.DiagnosisChannel;
import net.xeoh.plugins.diagnosis.local.DiagnosisChannelID;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisImpl;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisStatusImpl;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.Entry;
import net.xeoh.plugins.diagnosis.local.options.StatusOption;
import net.xeoh.plugins.diagnosis.local.options.status.OptionInfo;

public class DiagnosisChannelImpl
implements DiagnosisChannel<Object> {
    private final DiagnosisImpl diagnosis;
    private final Class<? extends DiagnosisChannelID<?>> channel;

    public DiagnosisChannelImpl(DiagnosisImpl diagnosis, Class<? extends DiagnosisChannelID<?>> channel) {
        this.diagnosis = diagnosis;
        this.channel = channel;
    }

    @Override
    public void status(Object value, StatusOption ... options) {
        OptionInfo[] infos;
        long timestamp = System.currentTimeMillis();
        long id = Thread.currentThread().getId();
        Entry entry = new Entry();
        entry.date = timestamp;
        entry.threadID = id;
        entry.channel = this.channel.getCanonicalName();
        entry.value = value;
        if (this.diagnosis.useStackTraces) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            entry.stackTrace = CoreKeeper.$(stackTrace).slice(2, Math.min(this.diagnosis.stackTracesDepth, stackTrace.length - 2)).string().array(String.class);
        }
        for (OptionInfo oi : infos = CoreKeeper.$(options).cast(OptionInfo.class).array(OptionInfo.class)) {
            entry.additionalInfo.put(oi.getKey(), oi.getValue());
        }
        DiagnosisStatusImpl<Serializable> status = new DiagnosisStatusImpl<Serializable>(this.channel, (Serializable)value, timestamp, infos);
        this.diagnosis.recordEntry(status, entry);
    }
}

