/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieExporterDialog;

public class MovieExportAction
extends AbstractAction {
    private static final long serialVersionUID = -6731682301579049379L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieExportAction() {
        this.putValue("SwingLargeIconKey", IconManager.EXPORT);
        this.putValue("SmallIcon", IconManager.EXPORT);
        this.putValue("Name", BUNDLE.getString("movie.export"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> movies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (movies.size() > 0) {
            MovieExporterDialog dialog = new MovieExporterDialog(movies);
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
        }
    }
}

