/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.jcores.jre.CoreKeeper;
import net.xeoh.plugins.base.Option;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginConfiguration;
import net.xeoh.plugins.base.PluginInformation;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.RecognizesOption;
import net.xeoh.plugins.base.annotations.meta.Version;
import net.xeoh.plugins.base.diagnosis.channels.tracing.PluginManagerTracer;
import net.xeoh.plugins.base.impl.PluginConfigurationImpl;
import net.xeoh.plugins.base.impl.PluginInformationImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.registry.PluginMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginRegistry;
import net.xeoh.plugins.base.impl.spawning.SpawnResult;
import net.xeoh.plugins.base.impl.spawning.Spawner;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.options.GetPluginOption;
import net.xeoh.plugins.base.options.addpluginsfrom.OptionReportAfter;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;
import net.xeoh.plugins.base.options.getplugin.OptionPluginSelector;
import net.xeoh.plugins.base.options.getplugin.PluginSelector;
import net.xeoh.plugins.base.util.OptionUtils;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;
import net.xeoh.plugins.diagnosis.local.Diagnosis;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisImpl;
import net.xeoh.plugins.diagnosis.local.options.ChannelOption;
import net.xeoh.plugins.diagnosis.local.options.StatusOption;
import net.xeoh.plugins.diagnosis.local.options.status.OptionInfo;
import net.xeoh.plugins.informationbroker.impl.InformationBrokerImpl;

@PluginImplementation
@Version(version=10002)
@Author(name="Ralf Biedert")
public class PluginManagerImpl
implements PluginManager {
    private final PluginConfiguration configuration;
    private final PluginRegistry pluginRegistry = new PluginRegistry();
    private final ClassPathManager classPathManager;
    private final Spawner spawner = new Spawner(this);
    private boolean shutdownPerformed = false;
    PluginInformation information;
    Diagnosis diagnosis;

    protected PluginManagerImpl(Properties initialProperties) {
        this.classPathManager = new ClassPathManager(this);
        this.configuration = new PluginConfigurationImpl(initialProperties);
        this.hookPlugin(new SpawnResult(this));
        this.hookPlugin(new SpawnResult(this.configuration));
        this.loadAdditionalPlugins();
        this.applyConfig();
    }

    @Override
    public PluginManager addPluginsFrom(URI url, AddPluginsFromOption ... options) {
        this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("add/start", new OptionInfo("url", url));
        if (url == null) {
            return this;
        }
        if (!this.classPathManager.addFromLocation(url, options)) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("add/nohandler", new OptionInfo("url", url));
        }
        if (CoreKeeper.$(options).get(OptionReportAfter.class, null) != null) {
            this.pluginRegistry.report();
        }
        this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("add/end", new OptionInfo("url", url));
        return this;
    }

    @Override
    @RecognizesOption(option=OptionPluginSelector.class)
    public <P extends Plugin> P getPlugin(Class<P> requestedPlugin, GetPluginOption ... options) {
        if (this.diagnosis != null) {
            String name = requestedPlugin == null ? "null" : requestedPlugin.getCanonicalName();
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/start", new OptionInfo("plugin", (Serializable)((Object)name)));
        }
        if (requestedPlugin == null) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/end", new OptionInfo("return", null));
            return null;
        }
        if (!requestedPlugin.isInterface()) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/onlyinterface", new OptionInfo("plugin", (Serializable)((Object)requestedPlugin.getCanonicalName())));
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/end", new OptionInfo("return", null));
            System.err.println("YOU MUST NOT call getPlugin() with a concrete class; only interfaces are");
            System.err.println("supported for lookup. This means do not call getPlugin(MyPluginImpl.class),");
            System.err.println("but rather getPlugin(MyPlugin.class)!");
            return null;
        }
        OptionUtils ou = new OptionUtils((Option[])options);
        PluginSelector pluginSelector = null;
        if (ou.contains(OptionPluginSelector.class)) {
            pluginSelector = ((OptionPluginSelector)ou.get(OptionPluginSelector.class, new OptionPluginSelector[0])).getSelector();
        } else {
            String[] capabilites = ((OptionCapabilities)ou.get(OptionCapabilities.class, new OptionCapabilities[]{new OptionCapabilities(new String[0])})).getCapabilities();
            final List<String> caps = Arrays.asList(capabilites);
            pluginSelector = new PluginSelector<P>(){

                @Override
                public boolean selectPlugin(Plugin plugin) {
                    if (caps.size() > 0) {
                        Collection<String> pcaps = PluginManagerImpl.this.information.getInformation(PluginInformation.Information.CAPABILITIES, plugin);
                        return pcaps.containsAll(caps);
                    }
                    return true;
                }
            };
        }
        for (Plugin plugin : this.pluginRegistry.getAllPlugins()) {
            if (this.diagnosis != null) {
                this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/considering", new OptionInfo("plugin", (Serializable)((Object)plugin.toString())));
            }
            PluginMetaInformation metaInformation = this.pluginRegistry.getMetaInformationFor(plugin);
            if (metaInformation.pluginStatus != PluginMetaInformation.PluginStatus.ACTIVE || !requestedPlugin.isAssignableFrom(plugin.getClass()) || !pluginSelector.selectPlugin(plugin)) continue;
            if (this.diagnosis != null) {
                this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/end", new OptionInfo("return", (Serializable)((Object)plugin.toString())));
            }
            return (P)plugin;
        }
        if (this.diagnosis != null) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("get/end", new OptionInfo("return", null));
        }
        return null;
    }

    @Override
    public void shutdown() {
        this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("shutdown/start", new StatusOption[0]);
        if (this.shutdownPerformed) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("shutdown/end/alreadyperformed", new StatusOption[0]);
            return;
        }
        for (Plugin p : this.pluginRegistry.getAllPlugins()) {
            this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("shutdown/destroy", new OptionInfo("plugin", (Serializable)((Object)p.getClass().getCanonicalName())));
            this.spawner.destroyPlugin(p, this.pluginRegistry.getMetaInformationFor(p));
        }
        this.pluginRegistry.clear();
        this.shutdownPerformed = true;
        this.diagnosis.channel(PluginManagerTracer.class, new ChannelOption[0]).status("shutdown/end", new StatusOption[0]);
    }

    private void applyConfig() {
        PluginConfigurationUtil pcu = new PluginConfigurationUtil(this.configuration);
        String cachePath = this.configuration.getConfiguration(PluginManager.class, "cache.file");
        this.classPathManager.getCache().setEnabled(pcu.getBoolean(PluginManager.class, "cache.enabled", false));
        this.classPathManager.getCache().setCachePath(cachePath);
        String mode = pcu.getString(PluginManager.class, "cache.mode", "strong");
        if (mode.equals("weak")) {
            this.classPathManager.getCache().setWeakMode(true);
        }
    }

    private void loadAdditionalPlugins() {
        this.hookPlugin(this.spawner.spawnPlugin(InformationBrokerImpl.class));
        this.information = (PluginInformation)this.spawner.spawnPlugin(PluginInformationImpl.class).plugin;
        this.diagnosis = (Diagnosis)this.spawner.spawnPlugin(DiagnosisImpl.class).plugin;
        ((PluginInformationImpl)this.information).pluginManager = this;
        ((DiagnosisImpl)this.diagnosis).configuration = this.configuration;
        ((DiagnosisImpl)this.diagnosis).init();
        this.hookPlugin(new SpawnResult(this.information));
        this.hookPlugin(new SpawnResult(this.diagnosis));
        Collection<Plugin> allPlugins = this.pluginRegistry.getAllPlugins();
        for (Plugin plugin : allPlugins) {
            this.pluginRegistry.getMetaInformationFor((Plugin)plugin).pluginStatus = PluginMetaInformation.PluginStatus.ACTIVE;
        }
    }

    public void hookPlugin(SpawnResult p) {
        this.spawner.processThisPluginLoadedAnnotation(p.plugin, p.metaInformation);
        this.pluginRegistry.registerPlugin(p.plugin, p.metaInformation);
        this.spawner.processOtherPluginLoadedAnnotation(p.plugin);
    }

    public ClassPathManager getClassPathManager() {
        return this.classPathManager;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public PluginConfiguration getPluginConfiguration() {
        return this.configuration;
    }

    public Diagnosis getDiagnosis() {
        return this.diagnosis;
    }

    public Spawner getSpawner() {
        return this.spawner;
    }
}

