/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.CachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiScraperProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class KodiUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiUrl.class);
    private String urlString;
    private Url url;
    private String functionName;
    private KodiScraper scraper;

    public KodiUrl(Element url) {
        this.updateFromElement(url);
    }

    public KodiUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        if (url.trim().contains("<url")) {
            try {
                url = StringEscapeUtils.unescapeHtml4((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = url.replaceAll("\\&", "\\&amp;");
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = f.newDocumentBuilder();
                Document d = parser.parse(new ByteArrayInputStream(url.getBytes()));
                Element e = (Element)d.getElementsByTagName("url").item(0);
                this.updateFromElement(e);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid xml url: " + url, e);
            }
        } else {
            this.urlString = url;
        }
    }

    public KodiUrl(String url, KodiScraper kodiScraper) {
        this(url);
        this.scraper = kodiScraper;
    }

    public KodiUrl(Element url, KodiScraper kodiScraper) {
        this(url);
        this.scraper = kodiScraper;
    }

    private void updateFromElement(Element e) {
        this.urlString = e.getTextContent();
        if (this.urlString != null) {
            this.urlString = this.urlString.trim();
        }
        LOGGER.debug("KodiUrl using Url from Xml: " + this.urlString);
        this.functionName = e.getAttribute("function");
    }

    private Url getUrl() throws Exception {
        if (this.url == null) {
            this.url = new CachedUrl(this.urlString);
        }
        return this.url;
    }

    public InputStream getInputStream() throws Exception {
        if (this.scraper != null && !StringUtils.isEmpty((CharSequence)this.getFunctionName())) {
            KodiScraperProcessor processor = new KodiScraperProcessor(this.scraper);
            LOGGER.debug("Processing Url Function: " + this.getFunctionName() + " with Url: " + this.urlString);
            KodiUrl xurl = new KodiUrl(this.urlString);
            String results = processor.executeFunction(this.getFunctionName(), new String[]{"", xurl.getTextContent()});
            if (results == null) {
                results = "";
            }
            return new ByteArrayInputStream(results.getBytes());
        }
        Url u = this.getUrl();
        if (this.urlString.contains(".zip")) {
            LOGGER.debug("Converting ZipFile to Text content for url: " + this.urlString);
            ZipInputStream zis = new ZipInputStream(u.getInputStream());
            ZipEntry ze = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int MAX_LEN = 2048;
            byte[] buf = new byte[MAX_LEN];
            while ((ze = zis.getNextEntry()) != null) {
                LOGGER.debug("Adding Zip Entry: " + ze.getName() + " to Text content");
                int len = 0;
                while ((len = zis.read(buf)) > 0) {
                    baos.write(buf, 0, len);
                }
            }
            baos.flush();
            zis.close();
            LOGGER.debug("Returing Text Context as inputstream...");
            return new ByteArrayInputStream(baos.toByteArray());
        }
        return u.getInputStream();
    }

    public String toExternalForm() {
        return this.urlString;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getTextContent() throws Exception {
        return IOUtils.toString((InputStream)this.getInputStream());
    }

    public String toString() {
        return "KodiUrl[" + this.url + "]";
    }
}

