/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieGenresPanel
extends JPanel {
    private static final long serialVersionUID = -6585642654072040266L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieGenresPanel.class);
    private MovieSelectionModel movieSelectionModel;

    public MovieGenresPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.setOpaque(false);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSelectionModel.class && "selectedMovie".equals(property) || source.getClass() == Movie.class && "genre".equals(property) || source.getClass() == Movie.class && "videoIn3D".equals(property)) {
                    MovieGenresPanel.this.buildImages();
                }
            }
        };
        this.movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void buildImages() {
        this.removeAll();
        ArrayList<MediaGenres> genres = new ArrayList<MediaGenres>(this.movieSelectionModel.getSelectedMovie().getGenres());
        if (this.movieSelectionModel.getSelectedMovie().isVideoIn3D() && !genres.contains(MediaGenres.getGenre((String)"3D"))) {
            genres.add(0, MediaGenres.getGenre((String)"3D"));
        }
        for (MediaGenres genre : genres) {
            try {
                StringBuilder sb = new StringBuilder("/images/genres/");
                sb.append(genre.name().toLowerCase(Locale.ROOT));
                sb.append(".png");
                ImageIcon image = new ImageIcon(MovieGenresPanel.class.getResource(sb.toString()));
                JLabel lblImage = new JLabel(image);
                this.add(lblImage);
            }
            catch (NullPointerException e) {
                LOGGER.warn("genre image for genre " + genre.name() + " not available");
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
        if (genres == null || genres.size() == 0) {
            try {
                ImageIcon image = new ImageIcon(MovieGenresPanel.class.getResource("/images/genres/unknown.png"));
                JLabel lblImage = new JLabel(image);
                this.add(lblImage);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

