/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.japura.gui.model.PriorityComboBoxModel;

public class PriorityComboBoxRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected static Border emptyBorder = new EmptyBorder(1, 1, 1, 1);
    protected static Border bottomLineBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK);
    protected static Border separatorBorder = BorderFactory.createCompoundBorder(bottomLineBorder, emptyBorder);

    public PriorityComboBoxRenderer() {
        this.setOpaque(true);
        this.setBorder(emptyBorder);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = null;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    protected void applyChangesForPriorityComboBox(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list.getModel() instanceof PriorityComboBoxModel) {
            PriorityComboBoxModel model = (PriorityComboBoxModel)list.getModel();
            if (!model.isPriorityAvailable()) {
                return;
            }
            if (model.getPriorityItemsSize() > 0 && index == model.getPriorityItemsSize() - 1) {
                this.setBorder(separatorBorder);
            } else {
                this.setBorder(emptyBorder);
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.applyChangesForPriorityComboBox(list, value, index, isSelected, cellHasFocus);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            this.setText(value == null ? "" : value.toString());
        }
        return this;
    }
}

