/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.japura.gui.WidgetLayout;

public class EnhancedPanel
extends JComponent {
    private static final long serialVersionUID = 2L;
    private JRootPane root = new JRootPane();
    private WidgetRoot widgetRoot;
    private GlassPane glassPane = new GlassPane();

    public EnhancedPanel() {
        this.widgetRoot = new WidgetRoot();
        super.setLayout(new BorderLayout());
        super.add(this.root);
        this.setLayout(new FlowLayout());
        this.root.getLayeredPane().add((Component)this.widgetRoot, JLayeredPane.MODAL_LAYER);
        this.root.setGlassPane(this.glassPane);
    }

    @Override
    public final JRootPane getRootPane() {
        if (this.getParent() != null) {
            return SwingUtilities.getRootPane(this.getParent());
        }
        return null;
    }

    public void setWidgetLayout(LayoutManager layoutManager) {
        this.widgetRoot.setLayout(layoutManager);
    }

    public LayoutManager getWidgetLayout() {
        return this.widgetRoot.getLayout();
    }

    public void addWidget(JComponent widget) {
        this.addWidget(widget, null);
    }

    public void addWidget(JComponent widget, Object constraints) {
        this.widgetRoot.add((Component)widget, constraints);
    }

    public void removeWidget(JComponent widget) {
        this.widgetRoot.remove(widget);
    }

    @Override
    public final LayoutManager getLayout() {
        return this.root.getContentPane().getLayout();
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
        this.root.getContentPane().setLayout(mgr);
    }

    @Override
    public Color getBackground() {
        return this.root.getContentPane().getBackground();
    }

    @Override
    public void setBackground(Color bg) {
        this.root.getContentPane().setBackground(bg);
    }

    @Override
    public final void doLayout() {
        super.doLayout();
        this.widgetRoot.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public final void remove(Component comp) {
        this.root.getContentPane().remove(comp);
    }

    @Override
    public final void remove(int index) {
        this.root.getContentPane().remove(index);
    }

    @Override
    public final void removeAll() {
        this.root.getContentPane().removeAll();
    }

    @Override
    public final Component add(Component comp) {
        return this.root.getContentPane().add(comp);
    }

    @Override
    public final Component add(Component comp, int index) {
        return this.root.getContentPane().add(comp, index);
    }

    @Override
    public final void add(Component comp, Object constraints) {
        this.root.getContentPane().add(comp, constraints);
    }

    @Override
    public final void add(Component comp, Object constraints, int index) {
        this.root.getContentPane().add(comp, constraints, index);
    }

    public void setWidgetTranslucentBackground(boolean enabled) {
        this.widgetRoot.setTranslucentBackgroundEnabled(enabled);
    }

    public boolean isWidgetTranslucentBackground() {
        return this.widgetRoot.isTranslucentBackgroundEnabled();
    }

    public boolean isEventsBlocked() {
        return this.glassPane.isVisible();
    }

    public void setEventsBlocked(boolean blocked) {
        this.glassPane.setVisible(blocked);
        this.glassPane.setEventsBlocked(blocked);
    }

    private static class WidgetRoot
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private boolean translucentBackgroundEnabled;

        public WidgetRoot() {
            this.setLayout(new WidgetLayout());
            this.setOpaque(false);
            this.setBackground(new Color(135, 135, 135, 150));
        }

        public void setTranslucentBackgroundEnabled(boolean enabled) {
            this.translucentBackgroundEnabled = enabled;
        }

        public boolean isTranslucentBackgroundEnabled() {
            return this.translucentBackgroundEnabled;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.isTranslucentBackgroundEnabled()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(this.getBackground());
                int width = this.getRootPane().getWidth();
                int height = this.getRootPane().getHeight();
                g2d.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
            }
        }
    }

    private static class GlassPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private MouseAdapter mouseAdapter;
        private KeyAdapter keyAdapter;
        private FocusAdapter focusAdapter;

        public GlassPane() {
            this.setOpaque(false);
            this.mouseAdapter = new MouseAdapter(){};
            this.keyAdapter = new KeyAdapter(){};
            this.focusAdapter = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    GlassPane.this.requestFocus();
                }
            };
        }

        public void setEventsBlocked(boolean blocked) {
            if (blocked) {
                this.addMouseListener(this.mouseAdapter);
                this.addMouseMotionListener(this.mouseAdapter);
                this.addKeyListener(this.keyAdapter);
                this.addFocusListener(this.focusAdapter);
                this.requestFocus();
            } else {
                this.removeMouseListener(this.mouseAdapter);
                this.removeMouseMotionListener(this.mouseAdapter);
                this.removeKeyListener(this.keyAdapter);
                this.removeFocusListener(this.focusAdapter);
            }
        }
    }
}

