/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.SpinnerUI;
import org.apache.commons.lang3.StringUtils;
import org.japura.gui.CheckComboBox;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchOptions;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.SmallCheckBoxUI;
import org.tinymediamanager.ui.SmallSpinnerUI;
import org.tinymediamanager.ui.SmallTextFieldBorder;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.SmallCheckComboBox;
import org.tinymediamanager.ui.components.SmallComboBox;
import org.tinymediamanager.ui.movies.MovieExtendedComparator;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.RoundedPanel;

public class MovieExtendedSearchPanel
extends RoundedPanel {
    private static final long serialVersionUID = -4170930017190753789L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final float FONT_SIZE = Math.round((double)Globals.settings.getFontSize() * 0.916);
    private static final SmallCheckBoxUI CHECKBOX_UI = AbstractLookAndFeel.getTheme() != null ? new SmallCheckBoxUI() : null;
    private MovieList movieList = MovieList.getInstance();
    private MovieSelectionModel movieSelectionModel;
    private JCheckBox cbFilterWatched;
    private JComboBox cbGenre;
    private JComboBox cbSortColumn;
    private JComboBox cbSortOrder;
    private JComboBox cbWatched;
    private JCheckBox cbFilterGenre;
    private JCheckBox cbFilterCast;
    private JTextField tfCastMember;
    private JCheckBox cbFilterTag;
    private CheckComboBox cbTag;
    private JCheckBox cbFilterDuplicates;
    private JCheckBox cbFilterMovieset;
    private JComboBox cbMovieset;
    private JCheckBox cbFilterVideoFormat;
    private JComboBox cbVideoFormat;
    private JCheckBox cbFilterVideoCodec;
    private JComboBox cbVideoCodec;
    private JCheckBox cbFilterAudioCodec;
    private JComboBox cbAudioCodec;
    private JCheckBox cbFilterDatasource;
    private CheckComboBox cbDatasource;
    private JCheckBox cbFilterMissingMetadata;
    private JCheckBox cbFilterMissingArtwork;
    private JCheckBox cbFilterMissingSubtitles;
    private JCheckBox cbFilterVideo3D;
    private final Action actionSort = new SortAction();
    private final Action actionFilter = new FilterAction();
    private final ListCheckListener listCheckListener;
    private JCheckBox cbFilterNewMovies;
    private JLabel lblNewMovies;
    private JCheckBox cbFilterCertification;
    private JLabel lblCertification;
    private JComboBox cbCertification;
    private JCheckBox cbFilterMediaSource;
    private JComboBox cbMediaSource;
    private JCheckBox cbFilterYear;
    private JLabel lblYear;
    private JSpinner spYear;
    private JCheckBox cbFilterOffline;
    private JLabel lblOffline;
    private JComboBox cbOffline;

    public MovieExtendedSearchPanel(MovieSelectionModel model) {
        this.setOpaque(false);
        this.shadowAlpha = 100;
        this.arcs = new Dimension(10, 10);
        this.movieSelectionModel = model;
        Map<MovieSearchOptions, Object> savedSearchOptions = MovieModuleManager.MOVIE_SETTINGS.getUiFilters();
        this.addMouseListener(new MouseAdapter(){});
        this.listCheckListener = new ListCheckListener(){

            public void removeCheck(ListEvent event) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(new ActionEvent(event.getSource(), 1, "checked"));
            }

            public void addCheck(ListEvent event) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(new ActionEvent(event.getSource(), 1, "checked"));
            }
        };
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC}));
        JLabel lblFilterBy = new JLabel(BUNDLE.getString("movieextendedsearch.filterby"));
        this.setComponentFont(lblFilterBy);
        this.add((Component)lblFilterBy, "2, 2, 3, 1");
        this.cbFilterNewMovies = new JCheckBox("");
        this.cbFilterNewMovies.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterNewMovies.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.NEW_MOVIES));
        this.cbFilterNewMovies.setAction(this.actionFilter);
        this.add((Component)this.cbFilterNewMovies, "2, 4");
        this.lblNewMovies = new JLabel(BUNDLE.getString("movieextendedsearch.newmovies"));
        this.setComponentFont(this.lblNewMovies);
        this.add((Component)this.lblNewMovies, "4, 4, right, default");
        this.cbFilterDuplicates = new JCheckBox("");
        this.cbFilterDuplicates.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterDuplicates.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.DUPLICATES));
        this.cbFilterDuplicates.setAction(this.actionFilter);
        this.add((Component)this.cbFilterDuplicates, "2, 5");
        JLabel lblShowDuplicates = new JLabel(BUNDLE.getString("movieextendedsearch.duplicates"));
        this.setComponentFont(lblShowDuplicates);
        this.add((Component)lblShowDuplicates, "4, 5, right, default");
        this.cbFilterWatched = new JCheckBox("");
        this.cbFilterWatched.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterWatched.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.WATCHED));
        this.cbFilterWatched.setAction(this.actionFilter);
        this.add((Component)this.cbFilterWatched, "2, 6");
        JLabel lblWatchedFlag = new JLabel(BUNDLE.getString("movieextendedsearch.watched"));
        this.setComponentFont(lblWatchedFlag);
        this.add((Component)lblWatchedFlag, "4, 6, right, default");
        this.cbWatched = new SmallComboBox((Object[])MovieExtendedComparator.WatchedFlag.values());
        this.setComponentFont(this.cbWatched);
        this.cbWatched.setAction(this.actionFilter);
        this.add((Component)this.cbWatched, "6, 6, fill, default");
        this.cbFilterGenre = new JCheckBox("");
        this.cbFilterGenre.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterGenre.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.GENRE));
        this.cbFilterGenre.setAction(this.actionFilter);
        this.add((Component)this.cbFilterGenre, "2, 7");
        JLabel lblGenre = new JLabel(BUNDLE.getString("movieextendedsearch.genre"));
        this.setComponentFont(lblGenre);
        this.add((Component)lblGenre, "4, 7, right, default");
        this.cbGenre = new SmallComboBox(MediaGenres.values());
        this.setComponentFont(this.cbGenre);
        this.cbGenre.setAction(this.actionFilter);
        this.add((Component)this.cbGenre, "6, 7, fill, default");
        this.cbFilterCertification = new JCheckBox("");
        this.cbFilterCertification.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterCertification.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.CERTIFICATION));
        this.cbFilterCertification.setAction(this.actionFilter);
        this.add((Component)this.cbFilterCertification, "2, 8");
        this.lblCertification = new JLabel(BUNDLE.getString("metatag.certification"));
        this.setComponentFont(this.lblCertification);
        this.add((Component)this.lblCertification, "4, 8, right, default");
        this.cbCertification = new SmallComboBox();
        this.setComponentFont(this.cbCertification);
        this.cbCertification.setAction(this.actionFilter);
        this.add((Component)this.cbCertification, "6, 8, fill, default");
        this.cbFilterYear = new JCheckBox("");
        this.cbFilterYear.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterYear.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.YEAR));
        this.cbFilterYear.setAction(this.actionFilter);
        this.add((Component)this.cbFilterYear, "2, 9");
        this.lblYear = new JLabel(BUNDLE.getString("metatag.year"));
        this.setComponentFont(this.lblYear);
        this.add((Component)this.lblYear, "4, 9, right, default");
        int year = Calendar.getInstance().get(1);
        this.spYear = new JSpinner();
        this.setComponentFont(this.spYear);
        this.spYear.setUI((SpinnerUI)((Object)new SmallSpinnerUI()));
        this.spYear.setModel(new SpinnerNumberModel(year, 0, 3000, 1));
        this.spYear.setEditor(new JSpinner.NumberEditor(this.spYear, "#"));
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }
        });
        this.add((Component)this.spYear, "6, 9");
        this.cbFilterCast = new JCheckBox("");
        this.cbFilterCast.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterCast.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.CAST));
        this.cbFilterCast.setAction(this.actionFilter);
        this.add((Component)this.cbFilterCast, "2, 10");
        JLabel lblCastMember = new JLabel(BUNDLE.getString("movieextendedsearch.cast"));
        this.setComponentFont(lblCastMember);
        this.add((Component)lblCastMember, "4, 10, right, default");
        this.tfCastMember = new JTextField();
        this.setComponentFont(this.tfCastMember);
        this.tfCastMember.setBorder(new SmallTextFieldBorder());
        this.add((Component)this.tfCastMember, "6, 10, fill, default");
        this.tfCastMember.setColumns(10);
        this.tfCastMember.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MovieExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }
        });
        this.cbFilterTag = new JCheckBox("");
        this.cbFilterTag.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterTag.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.TAG));
        this.cbFilterTag.setAction(this.actionFilter);
        this.add((Component)this.cbFilterTag, "2, 11");
        JLabel lblTag = new JLabel(BUNDLE.getString("movieextendedsearch.tag"));
        this.setComponentFont(lblTag);
        this.add((Component)lblTag, "4, 11, right, default");
        this.cbTag = new SmallCheckComboBox();
        this.cbTag.setTextFor(CheckComboBox.NONE, BUNDLE.getString("movieextendedsearch.tags.selected.none"));
        this.cbTag.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("movieextendedsearch.tags.selected.multiple"));
        this.cbTag.setTextFor(CheckComboBox.ALL, BUNDLE.getString("movieextendedsearch.tags.selected.all"));
        this.cbTag.getModel().addListCheckListener(this.listCheckListener);
        this.add((Component)this.cbTag, "6, 11, fill, default");
        this.cbFilterMovieset = new JCheckBox("");
        this.cbFilterMovieset.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterMovieset.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.MOVIESET));
        this.cbFilterMovieset.setAction(this.actionFilter);
        this.add((Component)this.cbFilterMovieset, "2, 12");
        JLabel lblMoviesInMovieset = new JLabel(BUNDLE.getString("movieextendedsearch.movieset"));
        this.setComponentFont(lblMoviesInMovieset);
        this.add((Component)lblMoviesInMovieset, "4, 12, right, default");
        this.cbMovieset = new SmallComboBox((Object[])MovieExtendedComparator.MovieInMovieSet.values());
        this.setComponentFont(this.cbMovieset);
        this.cbMovieset.setAction(this.actionFilter);
        this.add((Component)this.cbMovieset, "6, 12, fill, default");
        this.cbFilterVideoFormat = new JCheckBox("");
        this.cbFilterVideoFormat.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterVideoFormat.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.VIDEO_FORMAT));
        this.cbFilterVideoFormat.setAction(this.actionFilter);
        this.add((Component)this.cbFilterVideoFormat, "2, 13");
        JLabel lblVideoFormat = new JLabel(BUNDLE.getString("metatag.resolution"));
        this.setComponentFont(lblVideoFormat);
        this.add((Component)lblVideoFormat, "4, 13, right, default");
        this.cbVideoFormat = new SmallComboBox(this.getVideoFormats());
        this.setComponentFont(this.cbVideoFormat);
        this.cbVideoFormat.setAction(this.actionFilter);
        this.add((Component)this.cbVideoFormat, "6, 13, fill, default");
        this.cbFilterVideoCodec = new JCheckBox("");
        this.cbFilterVideoCodec.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterVideoCodec.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.VIDEO_CODEC));
        this.cbFilterVideoCodec.setAction(this.actionFilter);
        this.add((Component)this.cbFilterVideoCodec, "2, 14");
        JLabel lblVideoCodec = new JLabel(BUNDLE.getString("metatag.videocodec"));
        this.setComponentFont(lblVideoCodec);
        this.add((Component)lblVideoCodec, "4, 14, right, default");
        this.cbVideoCodec = new SmallComboBox();
        this.setComponentFont(this.cbVideoCodec);
        this.cbVideoCodec.setAction(this.actionFilter);
        this.add((Component)this.cbVideoCodec, "6, 14, fill, default");
        this.cbFilterVideo3D = new JCheckBox("");
        this.cbFilterVideo3D.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterVideo3D.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.VIDEO_3D));
        this.cbFilterVideo3D.addActionListener(this.actionFilter);
        this.add((Component)this.cbFilterVideo3D, "2, 15");
        JLabel lblVideo3D = new JLabel(BUNDLE.getString("metatag.3d"));
        this.setComponentFont(lblVideo3D);
        this.add((Component)lblVideo3D, "4, 15, right, default");
        this.cbFilterAudioCodec = new JCheckBox("");
        this.cbFilterAudioCodec.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterAudioCodec.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.AUDIO_CODEC));
        this.cbFilterAudioCodec.setAction(this.actionFilter);
        this.add((Component)this.cbFilterAudioCodec, "2, 16");
        JLabel lblAudioCodec = new JLabel(BUNDLE.getString("metatag.audiocodec"));
        this.setComponentFont(lblAudioCodec);
        this.add((Component)lblAudioCodec, "4, 16, right, default");
        this.cbAudioCodec = new SmallComboBox();
        this.setComponentFont(this.cbAudioCodec);
        this.cbAudioCodec.setAction(this.actionFilter);
        this.add((Component)this.cbAudioCodec, "6, 16, fill, default");
        this.cbFilterDatasource = new JCheckBox("");
        this.cbFilterDatasource.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterDatasource.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.DATASOURCE));
        this.cbFilterDatasource.setAction(this.actionFilter);
        this.add((Component)this.cbFilterDatasource, "2, 17");
        JLabel lblDatasource = new JLabel(BUNDLE.getString("metatag.datasource"));
        this.setComponentFont(lblDatasource);
        this.add((Component)lblDatasource, "4, 17, right, default");
        this.cbDatasource = new SmallCheckComboBox();
        this.cbDatasource.setTextFor(CheckComboBox.NONE, BUNDLE.getString("checkcombobox.selected.none"));
        this.cbDatasource.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("checkcombobox.selected.multiple"));
        this.cbDatasource.setTextFor(CheckComboBox.ALL, BUNDLE.getString("checkcombobox.selected.all"));
        this.cbDatasource.getModel().addListCheckListener(this.listCheckListener);
        this.add((Component)this.cbDatasource, "6, 17, fill, default");
        this.cbFilterMediaSource = new JCheckBox("");
        this.cbFilterMediaSource.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterMediaSource.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.MEDIA_SOURCE));
        this.cbFilterMediaSource.addActionListener(this.actionFilter);
        this.add((Component)this.cbFilterMediaSource, "2, 18");
        JLabel lblMediaSource = new JLabel(BUNDLE.getString("metatag.source"));
        this.setComponentFont(lblMediaSource);
        this.add((Component)lblMediaSource, "4, 18, right, default");
        this.cbMediaSource = new SmallComboBox((Object[])MediaSource.values());
        this.setComponentFont(this.cbMediaSource);
        this.cbMediaSource.setAction(this.actionFilter);
        this.add((Component)this.cbMediaSource, "6, 18, fill, default");
        this.cbFilterMissingMetadata = new JCheckBox("");
        this.cbFilterMissingMetadata.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterMissingMetadata.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.MISSING_METADATA));
        this.cbFilterMissingMetadata.setAction(this.actionFilter);
        this.add((Component)this.cbFilterMissingMetadata, "2, 19");
        JLabel lblMissingMetadata = new JLabel(BUNDLE.getString("movieextendedsearch.missingmetadata"));
        this.setComponentFont(lblMissingMetadata);
        this.add((Component)lblMissingMetadata, "4, 19, right, default");
        this.cbFilterMissingArtwork = new JCheckBox("");
        this.cbFilterMissingArtwork.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterMissingArtwork.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.MISSING_ARTWORK));
        this.cbFilterMissingArtwork.setAction(this.actionFilter);
        this.add((Component)this.cbFilterMissingArtwork, "2, 20");
        JLabel lblMissingArtwork = new JLabel(BUNDLE.getString("movieextendedsearch.missingartwork"));
        this.setComponentFont(lblMissingArtwork);
        this.add((Component)lblMissingArtwork, "4, 20, right, default");
        this.cbFilterMissingSubtitles = new JCheckBox("");
        this.cbFilterMissingSubtitles.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterMissingSubtitles.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.MISSING_SUBTITLES));
        this.cbFilterMissingSubtitles.setAction(this.actionFilter);
        this.add((Component)this.cbFilterMissingSubtitles, "2, 21");
        JLabel lblMissingSubtitles = new JLabel(BUNDLE.getString("movieextendedsearch.missingsubtitles"));
        this.setComponentFont(lblMissingSubtitles);
        this.add((Component)lblMissingSubtitles, "4, 21, right, default");
        this.cbFilterOffline = new JCheckBox("");
        this.cbFilterOffline.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterOffline.setSelected(savedSearchOptions.containsKey((Object)MovieSearchOptions.OFFLINE));
        this.cbFilterOffline.setAction(this.actionFilter);
        this.add((Component)this.cbFilterOffline, "2, 22");
        this.lblOffline = new JLabel(BUNDLE.getString("movieextendedsearch.offline"));
        this.setComponentFont(this.lblOffline);
        this.add((Component)this.lblOffline, "4, 22, right, default");
        this.cbOffline = new SmallComboBox((Object[])MovieExtendedComparator.OfflineMovie.values());
        this.cbOffline.setAction(this.actionFilter);
        this.add((Component)this.cbOffline, "6, 22, fill, default");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "2, 24, 5, 1");
        JLabel lblSortBy = new JLabel(BUNDLE.getString("movieextendedsearch.sortby"));
        this.setComponentFont(lblSortBy);
        this.add((Component)lblSortBy, "2, 26, 3, 1");
        this.cbSortColumn = new SmallComboBox((Object[])MovieExtendedComparator.SortColumn.values());
        this.setComponentFont(this.cbSortColumn);
        this.cbSortColumn.setAction(this.actionSort);
        this.add((Component)this.cbSortColumn, "2, 28, 3, 1, fill, default");
        this.cbSortOrder = new SmallComboBox((Object[])MovieExtendedComparator.SortOrder.values());
        this.setComponentFont(this.cbSortOrder);
        this.cbSortOrder.setAction(this.actionSort);
        this.add((Component)this.cbSortOrder, "6, 28, fill, default");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof MovieList && "tag".equals(evt.getPropertyName())) {
                    MovieExtendedSearchPanel.this.buildAndInstallTagsArray();
                }
                if (evt.getSource() instanceof MovieList && "videoCodec".equals(evt.getPropertyName())) {
                    MovieExtendedSearchPanel.this.buildAndInstallCodecArray();
                }
                if (evt.getSource() instanceof MovieList && "audioCodec".equals(evt.getPropertyName())) {
                    MovieExtendedSearchPanel.this.buildAndInstallCodecArray();
                }
                if (evt.getSource() instanceof MovieSettings && "movieDataSource".equals(evt.getPropertyName())) {
                    MovieExtendedSearchPanel.this.buildAndInstallDatasourceArray();
                }
                if (evt.getSource() instanceof MovieList && "certification".equals(evt.getPropertyName())) {
                    MovieExtendedSearchPanel.this.buildAndInstallCertificationArray();
                }
            }
        };
        this.movieList.addPropertyChangeListener(propertyChangeListener);
        MovieModuleManager.MOVIE_SETTINGS.addPropertyChangeListener(propertyChangeListener);
        this.buildAndInstallTagsArray();
        this.buildAndInstallCodecArray();
        this.buildAndInstallDatasourceArray();
        this.buildAndInstallCertificationArray();
    }

    private void buildAndInstallTagsArray() {
        List oldValues = this.cbTag.getModel().getCheckeds();
        this.cbTag.getModel().removeListCheckListener(this.listCheckListener);
        this.cbTag.getModel().clear();
        ArrayList<String> tags = new ArrayList<String>(this.movieList.getTagsInMovies());
        Collections.sort(tags);
        for (String tag : tags) {
            this.cbTag.getModel().addElement(new Object[]{tag});
        }
        if (oldValues != null) {
            for (Object obj : oldValues) {
                this.cbTag.getModel().setCheck(new Object[]{obj});
            }
        }
        this.cbTag.getModel().addListCheckListener(this.listCheckListener);
    }

    private void buildAndInstallCodecArray() {
        Object oldValue = this.cbVideoCodec.getSelectedItem();
        this.cbVideoCodec.removeActionListener(this.actionFilter);
        this.cbVideoCodec.removeAllItems();
        ArrayList<String> codecs = new ArrayList<String>(this.movieList.getVideoCodecsInMovies());
        Collections.sort(codecs);
        for (String codec : codecs) {
            this.cbVideoCodec.addItem(codec);
        }
        if (oldValue != null) {
            this.cbVideoCodec.setSelectedItem(oldValue);
        }
        this.cbVideoCodec.addActionListener(this.actionFilter);
        oldValue = this.cbAudioCodec.getSelectedItem();
        this.cbAudioCodec.removeActionListener(this.actionFilter);
        this.cbAudioCodec.removeAllItems();
        codecs = new ArrayList<String>(this.movieList.getAudioCodecsInMovies());
        Collections.sort(codecs);
        for (String codec : codecs) {
            this.cbAudioCodec.addItem(codec);
        }
        if (oldValue != null) {
            this.cbAudioCodec.setSelectedItem(oldValue);
        }
        this.cbAudioCodec.addActionListener(this.actionFilter);
    }

    private void buildAndInstallDatasourceArray() {
        List oldValues = this.cbDatasource.getModel().getCheckeds();
        this.cbDatasource.getModel().removeListCheckListener(this.listCheckListener);
        this.cbDatasource.getModel().clear();
        ArrayList<String> datasources = new ArrayList<String>(MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource());
        Collections.sort(datasources);
        for (String datasource : datasources) {
            this.cbDatasource.getModel().addElement(new Object[]{datasource});
        }
        if (oldValues != null) {
            for (Object obj : oldValues) {
                this.cbDatasource.getModel().setCheck(new Object[]{obj});
            }
        }
        this.cbDatasource.getModel().addListCheckListener(this.listCheckListener);
    }

    private void buildAndInstallCertificationArray() {
        Object oldValue = this.cbCertification.getSelectedItem();
        this.cbCertification.removeActionListener(this.actionFilter);
        this.cbCertification.removeAllItems();
        ArrayList<Certification> certifications = new ArrayList<Certification>(this.movieList.getCertificationsInMovies());
        Collections.sort(certifications);
        for (Certification cert : certifications) {
            this.cbCertification.addItem(cert);
        }
        if (oldValue != null) {
            this.cbCertification.setSelectedItem(oldValue);
        }
        this.cbCertification.addActionListener(this.actionFilter);
    }

    private String[] getVideoFormats() {
        return new String[]{"480p", "540p", "576p", "720p", "1080p", "4k", "SD", "HD"};
    }

    private void setComponentFont(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(FONT_SIZE));
    }

    private class FilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 7488733475791640009L;

        private FilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String audioCodec;
            String videoCodec;
            Certification cert;
            MediaGenres genre;
            HashMap<MovieSearchOptions, Object> searchOptions = new HashMap<MovieSearchOptions, Object>();
            if (MovieExtendedSearchPanel.this.cbFilterDuplicates.isSelected()) {
                MovieExtendedSearchPanel.this.movieList.searchDuplicates();
                searchOptions.put(MovieSearchOptions.DUPLICATES, true);
            }
            if (MovieExtendedSearchPanel.this.cbFilterWatched.isSelected()) {
                if (MovieExtendedSearchPanel.this.cbWatched.getSelectedItem() == MovieExtendedComparator.WatchedFlag.WATCHED) {
                    searchOptions.put(MovieSearchOptions.WATCHED, true);
                } else {
                    searchOptions.put(MovieSearchOptions.WATCHED, false);
                }
            }
            if (MovieExtendedSearchPanel.this.cbFilterGenre.isSelected() && (genre = (MediaGenres)MovieExtendedSearchPanel.this.cbGenre.getSelectedItem()) != null) {
                searchOptions.put(MovieSearchOptions.GENRE, genre);
            }
            if (MovieExtendedSearchPanel.this.cbFilterCertification.isSelected() && (cert = (Certification)MovieExtendedSearchPanel.this.cbCertification.getSelectedItem()) != null) {
                searchOptions.put(MovieSearchOptions.CERTIFICATION, cert);
            }
            if (MovieExtendedSearchPanel.this.cbFilterCast.isSelected() && StringUtils.isNotBlank((CharSequence)MovieExtendedSearchPanel.this.tfCastMember.getText())) {
                searchOptions.put(MovieSearchOptions.CAST, MovieExtendedSearchPanel.this.tfCastMember.getText());
            }
            if (MovieExtendedSearchPanel.this.cbFilterTag.isSelected()) {
                List tags = MovieExtendedSearchPanel.this.cbTag.getModel().getCheckeds();
                searchOptions.put(MovieSearchOptions.TAG, tags);
            }
            if (MovieExtendedSearchPanel.this.cbFilterMovieset.isSelected()) {
                if (MovieExtendedSearchPanel.this.cbMovieset.getSelectedItem() == MovieExtendedComparator.MovieInMovieSet.IN_MOVIESET) {
                    searchOptions.put(MovieSearchOptions.MOVIESET, true);
                } else {
                    searchOptions.put(MovieSearchOptions.MOVIESET, false);
                }
            }
            if (MovieExtendedSearchPanel.this.cbFilterVideoFormat.isSelected()) {
                String videoFormat = (String)MovieExtendedSearchPanel.this.cbVideoFormat.getSelectedItem();
                searchOptions.put(MovieSearchOptions.VIDEO_FORMAT, videoFormat);
            }
            if (MovieExtendedSearchPanel.this.cbFilterVideoCodec.isSelected() && StringUtils.isNotBlank((CharSequence)(videoCodec = (String)MovieExtendedSearchPanel.this.cbVideoCodec.getSelectedItem()))) {
                searchOptions.put(MovieSearchOptions.VIDEO_CODEC, videoCodec);
            }
            if (MovieExtendedSearchPanel.this.cbFilterAudioCodec.isSelected() && StringUtils.isNotBlank((CharSequence)(audioCodec = (String)MovieExtendedSearchPanel.this.cbAudioCodec.getSelectedItem()))) {
                searchOptions.put(MovieSearchOptions.AUDIO_CODEC, audioCodec);
            }
            if (MovieExtendedSearchPanel.this.cbFilterDatasource.isSelected()) {
                List datasources = MovieExtendedSearchPanel.this.cbDatasource.getModel().getCheckeds();
                searchOptions.put(MovieSearchOptions.DATASOURCE, datasources);
            }
            if (MovieExtendedSearchPanel.this.cbFilterMissingMetadata.isSelected()) {
                searchOptions.put(MovieSearchOptions.MISSING_METADATA, Boolean.TRUE);
            }
            if (MovieExtendedSearchPanel.this.cbFilterMissingArtwork.isSelected()) {
                searchOptions.put(MovieSearchOptions.MISSING_ARTWORK, Boolean.TRUE);
            }
            if (MovieExtendedSearchPanel.this.cbFilterMissingSubtitles.isSelected()) {
                searchOptions.put(MovieSearchOptions.MISSING_SUBTITLES, Boolean.TRUE);
            }
            if (MovieExtendedSearchPanel.this.cbFilterNewMovies.isSelected()) {
                searchOptions.put(MovieSearchOptions.NEW_MOVIES, Boolean.TRUE);
            }
            if (MovieExtendedSearchPanel.this.cbFilterMediaSource.isSelected()) {
                searchOptions.put(MovieSearchOptions.MEDIA_SOURCE, MovieExtendedSearchPanel.this.cbMediaSource.getSelectedItem());
            }
            if (MovieExtendedSearchPanel.this.cbFilterYear.isSelected()) {
                searchOptions.put(MovieSearchOptions.YEAR, MovieExtendedSearchPanel.this.spYear.getValue());
            }
            if (MovieExtendedSearchPanel.this.cbFilterVideo3D.isSelected()) {
                searchOptions.put(MovieSearchOptions.VIDEO_3D, Boolean.TRUE);
            }
            if (MovieExtendedSearchPanel.this.cbFilterOffline.isSelected()) {
                if (MovieExtendedSearchPanel.this.cbOffline.getSelectedItem() == MovieExtendedComparator.OfflineMovie.OFFLINE) {
                    searchOptions.put(MovieSearchOptions.OFFLINE, Boolean.TRUE);
                } else {
                    searchOptions.put(MovieSearchOptions.OFFLINE, Boolean.FALSE);
                }
            }
            MovieExtendedSearchPanel.this.movieSelectionModel.filterMovies(searchOptions);
        }
    }

    private class SortAction
    extends AbstractAction {
        private static final long serialVersionUID = -4057379119252539003L;

        private SortAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieExtendedComparator.SortColumn column = (MovieExtendedComparator.SortColumn)((Object)MovieExtendedSearchPanel.this.cbSortColumn.getSelectedItem());
            MovieExtendedComparator.SortOrder order = (MovieExtendedComparator.SortOrder)((Object)MovieExtendedSearchPanel.this.cbSortOrder.getSelectedItem());
            boolean ascending = order == MovieExtendedComparator.SortOrder.ASCENDING;
            MovieExtendedSearchPanel.this.movieSelectionModel.sortMovies(column, ascending);
        }
    }
}

