/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.UTF8Control;

public class ClearImageCacheAction
extends AbstractAction {
    private static final long serialVersionUID = -4615019451671427233L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearImageCacheAction.class);

    public ClearImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("tmm.clearimagecache"));
        this.putValue("ShortDescription", BUNDLE.getString("tmm.clearimagecache"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Path cache = ImageCache.getCacheDir();
        if (Files.exists(cache, new LinkOption[0])) {
            try {
                Utils.deleteDirectoryRecursive(cache);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

