/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.thetvdbapi.model;

import java.util.Locale;

public enum BannerType {
    GRAPHICAL("graphical"),
    SEASON("season"),
    SEASONWIDE("seasonwide"),
    BLANK("blank"),
    TEXT("text"),
    FANART_HD("1920x1080"),
    FANART_SD("1280x720"),
    POSTER("680x1000"),
    ARTWORK("artwork");

    private final String type;

    private BannerType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static BannerType fromString(String type) {
        if (type != null) {
            for (BannerType bannerType : BannerType.values()) {
                if (!type.equalsIgnoreCase(bannerType.type)) continue;
                return bannerType;
            }
            if (type.toLowerCase(Locale.ROOT).contains("x")) {
                return ARTWORK;
            }
        }
        throw new IllegalArgumentException("BannerType is empty/null");
    }
}

