/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryImpl;
import org.fourthline.cling.registry.RegistryItem;
import org.fourthline.cling.registry.RegistryItems;
import org.fourthline.cling.registry.RegistryListener;

class RemoteItems
extends RegistryItems<RemoteDevice, RemoteGENASubscription> {
    private static Logger log = Logger.getLogger(Registry.class.getName());

    RemoteItems(RegistryImpl registry) {
        super(registry);
    }

    @Override
    void add(final RemoteDevice device) {
        Resource[] resources;
        if (this.update((RemoteDeviceIdentity)device.getIdentity())) {
            log.fine("Ignoring addition, device already registered: " + device);
            return;
        }
        for (Resource deviceResource : resources = this.getResources(device)) {
            log.fine("Validating remote device resource; " + deviceResource);
            if (this.registry.getResource(deviceResource.getPathQuery()) == null) continue;
            throw new RegistrationException("URI namespace conflict with already registered resource: " + deviceResource);
        }
        for (Resource validatedResource : resources) {
            this.registry.addResource(validatedResource);
            log.fine("Added remote device resource: " + validatedResource);
        }
        RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), device, this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() != null ? this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() : ((RemoteDeviceIdentity)device.getIdentity()).getMaxAgeSeconds());
        log.fine("Adding hydrated remote device to registry with " + item.getExpirationDetails().getMaxAgeSeconds() + " seconds expiration: " + device);
        this.getDeviceItems().add(item);
        if (log.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("-------------------------- START Registry Namespace -----------------------------------\n");
            for (Resource resource : this.registry.getResources()) {
                sb.append(resource).append("\n");
            }
            sb.append("-------------------------- END Registry Namespace -----------------------------------");
            log.finest(sb.toString());
        }
        log.fine("Completely hydrated remote device graph available, calling listeners: " + device);
        for (final RegistryListener listener : this.registry.getListeners()) {
            this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceAdded(RemoteItems.this.registry, device);
                }
            });
        }
    }

    boolean update(RemoteDeviceIdentity rdIdentity) {
        for (LocalDevice localDevice : this.registry.getLocalDevices()) {
            if (localDevice.findDevice(rdIdentity.getUdn()) == null) continue;
            log.fine("Ignoring update, a local device graph contains UDN");
            return true;
        }
        RemoteDevice registeredRemoteDevice = (RemoteDevice)this.get(rdIdentity.getUdn(), false);
        if (registeredRemoteDevice != null) {
            if (!registeredRemoteDevice.isRoot()) {
                log.fine("Updating root device of embedded: " + registeredRemoteDevice);
                registeredRemoteDevice = registeredRemoteDevice.getRoot();
            }
            final RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)registeredRemoteDevice.getIdentity()).getUdn(), registeredRemoteDevice, this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() != null ? this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() : rdIdentity.getMaxAgeSeconds());
            log.fine("Updating expiration of: " + registeredRemoteDevice);
            this.getDeviceItems().remove(item);
            this.getDeviceItems().add(item);
            log.fine("Remote device updated, calling listeners: " + registeredRemoteDevice);
            for (final RegistryListener listener : this.registry.getListeners()) {
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.remoteDeviceUpdated(RemoteItems.this.registry, (RemoteDevice)item.getItem());
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    boolean remove(RemoteDevice remoteDevice) {
        return this.remove(remoteDevice, false);
    }

    boolean remove(RemoteDevice remoteDevice, boolean shuttingDown) throws RegistrationException {
        final RemoteDevice registeredDevice = (RemoteDevice)this.get(((RemoteDeviceIdentity)remoteDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            log.fine("Removing remote device from registry: " + remoteDevice);
            for (Resource deviceResource : this.getResources(registeredDevice)) {
                if (!this.registry.removeResource(deviceResource)) continue;
                log.fine("Unregistered resource: " + deviceResource);
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                final RegistryItem outgoingSubscription = it.next();
                UDN subscriptionForUDN = ((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)((RemoteGENASubscription)outgoingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                log.fine("Removing outgoing subscription: " + outgoingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ((RemoteGENASubscription)outgoingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED, null);
                    }
                });
            }
            if (!shuttingDown) {
                for (final RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.remoteDeviceRemoved(RemoteItems.this.registry, registeredDevice);
                        }
                    });
                }
            }
            this.getDeviceItems().remove(new RegistryItem(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn()));
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        RemoteDevice[] allDevices;
        for (RemoteDevice device : allDevices = this.get().toArray(new RemoteDevice[this.get().size()])) {
            this.remove(device, shuttingDown);
        }
    }

    void start() {
    }

    @Override
    void maintain() {
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashMap expiredRemoteDevices = new HashMap();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Device '" + remoteItem.getItem() + "' expires in seconds: " + remoteItem.getExpirationDetails().getSecondsUntilExpiration());
            }
            if (!remoteItem.getExpirationDetails().hasExpired(false)) continue;
            expiredRemoteDevices.put(remoteItem.getKey(), remoteItem.getItem());
        }
        for (RemoteDevice remoteDevice : expiredRemoteDevices.values()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removing expired: " + remoteDevice);
            }
            this.remove(remoteDevice);
        }
        HashSet expiredOutgoingSubscriptions = new HashSet();
        for (RegistryItem item : this.getSubscriptionItems()) {
            if (!item.getExpirationDetails().hasExpired(true)) continue;
            expiredOutgoingSubscriptions.add(item.getItem());
        }
        for (RemoteGENASubscription subscription : expiredOutgoingSubscriptions) {
            if (log.isLoggable(Level.FINEST)) {
                log.fine("Renewing outgoing subscription: " + subscription);
            }
            this.renewOutgoingSubscription(subscription);
        }
    }

    public void resume() {
        log.fine("Updating remote device expiration timestamps on resume");
        ArrayList toUpdate = new ArrayList();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            toUpdate.add(((RemoteDevice)remoteItem.getItem()).getIdentity());
        }
        for (RemoteDeviceIdentity identity : toUpdate) {
            this.update(identity);
        }
    }

    @Override
    void shutdown() {
        log.fine("Cancelling all outgoing subscriptions to remote devices during shutdown");
        ArrayList remoteSubscriptions = new ArrayList();
        for (RegistryItem item : this.getSubscriptionItems()) {
            remoteSubscriptions.add(item.getItem());
        }
        for (RemoteGENASubscription remoteSubscription : remoteSubscriptions) {
            this.registry.getProtocolFactory().createSendingUnsubscribe(remoteSubscription).run();
        }
        log.fine("Removing all remote devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void renewOutgoingSubscription(RemoteGENASubscription subscription) {
        this.registry.executeAsyncProtocol(this.registry.getProtocolFactory().createSendingRenewal(subscription));
    }
}

