/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.japura.gui.Gradient;
import org.japura.gui.PaintedPanel;

public class TitleBar
extends PaintedPanel {
    private static final long serialVersionUID = 4L;
    private static Object defaultTitleBackground = new Gradient(Gradient.TOP_TO_BOTTOM, new Color(160, 190, 255), new Color(240, 240, 255));
    private Insets titleMargin = new Insets(3, 3, 3, 3);
    private JLabel titleLabel;
    private Object titleBackground;
    private int iconWidth;
    private int gapBetweenIconAndTitle = 5;
    private int gapBetweenTitleAndComponents = 15;
    private int gapBetweenComponents = 5;
    private JComponent[] titleComponents;
    private JPanel iconBase;

    protected TitleBar(Icon icon, String title, JComponent[] titleComponents) {
        if (title == null || title.length() == 0) {
            title = " ";
        }
        if (defaultTitleBackground instanceof Gradient) {
            this.setTitleBackground((Gradient)defaultTitleBackground);
        } else if (defaultTitleBackground instanceof Color) {
            this.setTitleBackground((Color)defaultTitleBackground);
        }
        this.titleComponents = titleComponents;
        if (this.titleComponents == null) {
            this.titleComponents = new JComponent[0];
        }
        if (icon != null) {
            this.iconWidth = icon.getIconWidth();
            this.iconBase = new JPanel();
            this.iconBase.setMinimumSize(new Dimension(icon.getIconWidth(), 1));
            this.iconBase.setPreferredSize(new Dimension(icon.getIconWidth(), 1));
            this.iconBase.setOpaque(false);
        }
        this.getTitleLabel().setText(title);
        this.titleMargin = new Insets(5, 5, 5, 5);
        this.rebuild();
    }

    public void rebuild() {
        this.removeAll();
        Insets margin = this.getTitleMargin();
        StringBuilder param2 = new StringBuilder();
        param2.append(margin.left);
        param2.append("[]");
        if (this.iconWidth > 0) {
            param2.append(this.gapBetweenIconAndTitle);
            param2.append("[]");
        }
        if (this.titleComponents.length > 0) {
            param2.append(this.gapBetweenTitleAndComponents);
            param2.append(":push");
        }
        for (int i = 0; i < this.titleComponents.length; ++i) {
            param2.append("[]");
            if (i >= this.titleComponents.length - 1) continue;
            param2.append(this.gapBetweenComponents);
        }
        param2.append(margin.right);
        StringBuilder param3 = new StringBuilder();
        param3.append(margin.top);
        param3.append("[align bottom]");
        param3.append(margin.bottom);
        this.setLayout((LayoutManager)new MigLayout("", param2.toString(), param3.toString()));
        if (this.iconWidth > 0) {
            this.add(this.getIconBase());
        }
        this.add(this.getTitleLabel());
        for (JComponent comp : this.titleComponents) {
            this.add(comp);
        }
        this.revalidate();
    }

    protected JPanel getIconBase() {
        return this.iconBase;
    }

    public void setTitleGaps(int gapBetweenIconAndTitle, int gapBetweenTitleAndComponents, int gapBetweenComponents) {
        gapBetweenIconAndTitle = Math.max(gapBetweenIconAndTitle, 0);
        gapBetweenTitleAndComponents = Math.max(gapBetweenTitleAndComponents, 0);
        gapBetweenComponents = Math.max(gapBetweenComponents, 0);
        this.rebuild();
    }

    public int getGapBetweenIconAndTitle() {
        return this.gapBetweenIconAndTitle;
    }

    public int getGapBetweenTitleAndTitleComponents() {
        return this.gapBetweenTitleAndComponents;
    }

    public int getGapBetweenTitleComponents() {
        return this.gapBetweenComponents;
    }

    protected JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
        }
        return this.titleLabel;
    }

    @Override
    public Font getFont() {
        return this.getTitleLabel().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTitleLabel().setFont(font);
    }

    public void setTitle(String title) {
        this.getTitleLabel().setText(title);
    }

    public String getTitle() {
        return this.getTitleLabel().getText();
    }

    public void setTitleForeground(Color color) {
        this.getTitleLabel().setForeground(color);
    }

    public Color getTitleForeground() {
        return this.getTitleLabel().getForeground();
    }

    public void setTitleBackground(Color color) {
        if (color != null) {
            this.titleBackground = color;
            this.removeBackgrounds();
            this.addBackground(color);
        }
    }

    public void setTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            this.titleBackground = gradient;
            this.removeBackgrounds();
            this.addBackground(gradient);
        }
    }

    public Object getTitleBackground() {
        return this.titleBackground;
    }

    public boolean hasTitleBackgroundGradient() {
        return this.titleBackground instanceof Gradient;
    }

    public Insets getTitleMargin() {
        return (Insets)this.titleMargin.clone();
    }

    public void setTitleMargin(Insets titleMargin) {
        if (titleMargin == null) {
            this.titleMargin = new Insets(0, 0, 0, 0);
        } else {
            int top = Math.max(titleMargin.top, 0);
            int left = Math.max(titleMargin.left, 0);
            int bottom = Math.max(titleMargin.bottom, 0);
            int right = Math.max(titleMargin.right, 0);
            this.titleMargin = new Insets(top, left, bottom, right);
        }
        this.rebuild();
    }

    public static Object getDefaultTitleBackground() {
        return defaultTitleBackground;
    }

    public static void setDefaultTitleBackground(Color color) {
        if (color != null) {
            defaultTitleBackground = color;
        }
    }

    public static void setDefaultTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            defaultTitleBackground = gradient;
        }
    }
}

