/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.item;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.Person;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.StorageMedium;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.item.Item;

public class TextItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.textItem");

    public TextItem() {
        this.setClazz(CLASS);
    }

    public TextItem(Item other) {
        super(other);
    }

    public TextItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public TextItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public PersonWithRole getFirstAuthor() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.AUTHOR.class);
    }

    public PersonWithRole[] getAuthors() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.AUTHOR.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public TextItem setAuthors(PersonWithRole[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.AUTHOR.class);
        for (PersonWithRole p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.AUTHOR(p));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public TextItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public TextItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public TextItem setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public TextItem setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public TextItem setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.getFirstPropertyValue(DIDLObject.Property.DC.RELATION.class);
    }

    public URI[] getRelations() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RELATION.class);
        return list.toArray(new URI[list.size()]);
    }

    public TextItem setRelations(URI[] relations) {
        this.removeProperties(DIDLObject.Property.DC.RELATION.class);
        for (URI relation : relations) {
            this.addProperty(new DIDLObject.Property.DC.RELATION(relation));
        }
        return this;
    }

    public String getFirstRights() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.RIGHTS.class);
    }

    public String[] getRights() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RIGHTS.class);
        return list.toArray(new String[list.size()]);
    }

    public TextItem setRights(String[] rights) {
        this.removeProperties(DIDLObject.Property.DC.RIGHTS.class);
        for (String right : rights) {
            this.addProperty(new DIDLObject.Property.DC.RIGHTS(right));
        }
        return this;
    }

    public String getRating() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.RATING.class);
    }

    public TextItem setRating(String rating) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.RATING(rating));
        return this;
    }

    public Person getFirstContributor() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.CONTRIBUTOR.class);
    }

    public Person[] getContributors() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.CONTRIBUTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public TextItem setContributors(Person[] contributors) {
        this.removeProperties(DIDLObject.Property.DC.CONTRIBUTOR.class);
        for (Person p : contributors) {
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(p));
        }
        return this;
    }

    public Person getFirstPublisher() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.PUBLISHER.class);
    }

    public Person[] getPublishers() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.PUBLISHER.class);
        return list.toArray(new Person[list.size()]);
    }

    public TextItem setPublishers(Person[] publishers) {
        this.removeProperties(DIDLObject.Property.DC.PUBLISHER.class);
        for (Person publisher : publishers) {
            this.addProperty(new DIDLObject.Property.DC.PUBLISHER(publisher));
        }
        return this;
    }
}

