/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.WolDeviceDialog;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class ExternalDevicesSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 8176824801347872222L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();
    private JTable tableWolDevices;
    private JTextField tfXbmcHost;
    private JTextField tfXbmcUsername;
    private JPasswordField tfXbmcPassword;
    private JCheckBox chckbxUpnpRemotePlay;
    private JCheckBox chckbxUpnpShareLibrary;

    public ExternalDevicesSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelWol = new JPanel();
        panelWol.setBorder(new TitledBorder(null, BUNDLE.getString("tmm.wakeonlan"), 4, 2, null, null));
        this.add((Component)panelWol, "2, 2, fill, fill");
        panelWol.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(50dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100px;default)")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(40dlu;default)")}));
        JScrollPane spWolDevices = new JScrollPane();
        panelWol.add((Component)spWolDevices, "2, 2, 1, 5, fill, fill");
        this.tableWolDevices = new JTable();
        spWolDevices.setViewportView(this.tableWolDevices);
        JButton btnAddWolDevice = new JButton(BUNDLE.getString("Button.add"));
        btnAddWolDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WolDeviceDialog dialog = new WolDeviceDialog();
                dialog.pack();
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        panelWol.add((Component)btnAddWolDevice, "4, 2, fill, default");
        JButton btnEditWolDevice = new JButton(BUNDLE.getString("Button.edit"));
        btnEditWolDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WolDevice device;
                int row = ExternalDevicesSettingsPanel.this.tableWolDevices.getSelectedRow();
                row = ExternalDevicesSettingsPanel.this.tableWolDevices.convertRowIndexToModel(row);
                if (row != -1 && (device = Globals.settings.getWolDevices().get(row)) != null) {
                    WolDeviceDialog dialog = new WolDeviceDialog();
                    dialog.setDevice(device);
                    dialog.pack();
                    dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                    dialog.setVisible(true);
                }
            }
        });
        panelWol.add((Component)btnEditWolDevice, "4, 4");
        JButton btnRemoveWolDevice = new JButton(BUNDLE.getString("Button.remove"));
        btnRemoveWolDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ExternalDevicesSettingsPanel.this.tableWolDevices.getSelectedRow();
                row = ExternalDevicesSettingsPanel.this.tableWolDevices.convertRowIndexToModel(row);
                if (row != -1) {
                    WolDevice device = Globals.settings.getWolDevices().get(row);
                    Globals.settings.removeWolDevice(device);
                }
            }
        });
        panelWol.add((Component)btnRemoveWolDevice, "4, 6, fill, top");
        JPanel panelXBMC = new JPanel();
        panelXBMC.setVisible(false);
        JPanel panelUpnp = new JPanel();
        panelUpnp.setBorder(new TitledBorder(null, "UPnP", 4, 2, null, null));
        this.add((Component)panelUpnp, "2, 4, fill, fill");
        panelUpnp.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.chckbxUpnpShareLibrary = new JCheckBox(BUNDLE.getString("Settings.upnp.share"));
        panelUpnp.add((Component)this.chckbxUpnpShareLibrary, "2, 1");
        this.chckbxUpnpRemotePlay = new JCheckBox(BUNDLE.getString("Settings.upnp.play"));
        panelUpnp.add((Component)this.chckbxUpnpRemotePlay, "2, 3");
        panelXBMC.setBorder(new TitledBorder(null, "Kodi / XBMC", 4, 2, null, null));
        this.add((Component)panelXBMC, "2, 6, fill, fill");
        panelXBMC.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblXbmcHost = new JLabel(BUNDLE.getString("Settings.proxyhost"));
        panelXBMC.add((Component)lblXbmcHost, "2, 2, right, default");
        this.tfXbmcHost = new JTextField();
        panelXBMC.add((Component)this.tfXbmcHost, "4, 2, fill, default");
        this.tfXbmcHost.setColumns(10);
        JLabel lblXbmcUsername = new JLabel(BUNDLE.getString("Settings.proxyuser"));
        panelXBMC.add((Component)lblXbmcUsername, "2, 4, right, default");
        this.tfXbmcUsername = new JTextField();
        panelXBMC.add((Component)this.tfXbmcUsername, "4, 4, fill, default");
        this.tfXbmcUsername.setColumns(10);
        JLabel lblXbmcPassword = new JLabel(BUNDLE.getString("Settings.proxypass"));
        panelXBMC.add((Component)lblXbmcPassword, "2, 6, right, default");
        this.tfXbmcPassword = new JPasswordField();
        panelXBMC.add((Component)this.tfXbmcPassword, "4, 6, fill, default");
        this.tfXbmcPassword.setColumns(10);
        this.initDataBindings();
        this.tableWolDevices.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("Settings.devicename"));
        this.tableWolDevices.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("Settings.macaddress"));
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"wolDevices");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (JTable)this.tableWolDevices);
        BeanProperty wolBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_1);
        BeanProperty wolBeanProperty_2 = BeanProperty.create((String)"macAddress");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_2);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"xbmcHost");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfXbmcHost, (Property)jTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"xbmcUsername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.tfXbmcUsername, (Property)jTextFieldBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"xbmcPassword");
        BeanProperty jPasswordFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.tfXbmcPassword, (Property)jPasswordFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"upnpRemotePlay");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxUpnpRemotePlay, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"upnpShareLibrary");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxUpnpShareLibrary, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }
}

