/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class RoundedPanel
extends JPanel {
    private static final long serialVersionUID = -1225971440296084187L;
    protected int strokeSize = 1;
    protected Color shadowColor = Color.black;
    protected boolean shady = true;
    protected boolean highQuality = true;
    protected Dimension arcs = new Dimension(20, 20);
    protected int shadowGap = 5;
    protected int shadowOffset = 4;
    protected int shadowAlpha = 150;

    public RoundedPanel() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int shadowGap = this.shadowGap;
        Color shadowColorA = new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), this.shadowAlpha);
        Graphics2D graphics = (Graphics2D)g;
        Object renderingHint = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.shady) {
            graphics.setColor(shadowColorA);
            graphics.fillRoundRect(this.shadowOffset, this.shadowOffset, width - this.strokeSize - this.shadowOffset, height - this.strokeSize - this.shadowOffset, this.arcs.width, this.arcs.height);
        } else {
            shadowGap = 1;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setColor(this.getForeground());
        graphics.setStroke(new BasicStroke(this.strokeSize));
        graphics.drawRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setStroke(new BasicStroke());
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
    }
}

