/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowModuleManager
implements ITmmModule {
    public static final TvShowSettings SETTINGS = Globals.settings.getTvShowSettings();
    private static final String MODULE_TITLE = "TV show management";
    private static final String TV_SHOW_DB = "tvshows.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowModuleManager.class);
    private static TvShowModuleManager instance;
    private boolean enabled = false;
    private MVStore mvStore;
    private ObjectMapper objectMapper;
    private ObjectWriter tvShowObjectWriter;
    private ObjectWriter episodeObjectWriter;
    private MVMap<UUID, String> tvShowMap;
    private MVMap<UUID, String> episodeMap;

    private TvShowModuleManager() {
    }

    public static TvShowModuleManager getInstance() {
        if (instance == null) {
            instance = new TvShowModuleManager();
        }
        return instance;
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() throws Exception {
        Path db = Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB);
        Utils.createBackupFile(db);
        Utils.deleteOldBackupFile(db, 15);
        this.mvStore = new MVStore.Builder().fileName(Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB).toString()).compressHigh().backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Error in the background thread of the persistent cache", e);
            }
        }).autoCommitBufferSize(4096).open();
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        this.objectMapper.setTimeZone(TimeZone.getDefault());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        this.objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        this.tvShowObjectWriter = this.objectMapper.writerFor(TvShow.class);
        this.episodeObjectWriter = this.objectMapper.writerFor(TvShowEpisode.class);
        this.tvShowMap = this.mvStore.openMap("tvshows");
        this.episodeMap = this.mvStore.openMap("episodes");
        TvShowList.getInstance().loadTvShowsFromDatabase(this.tvShowMap, this.objectMapper);
        TvShowList.getInstance().loadEpisodesFromDatabase(this.episodeMap, this.objectMapper);
        TvShowList.getInstance().initDataAfterLoading();
        this.enabled = true;
    }

    @Override
    public void shutDown() throws Exception {
        this.mvStore.compactMoveChunks();
        this.mvStore.close();
        this.enabled = false;
        if (Globals.settings.isDeleteTrashOnExit()) {
            for (String ds : SETTINGS.getTvShowDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump(TvShow tvshow) {
        try {
            JSONObject show = new JSONObject(this.tvShowObjectWriter.writeValueAsString((Object)tvshow));
            JSONArray episodes = new JSONArray();
            for (TvShowEpisode ep : tvshow.getEpisodes()) {
                JSONObject epJson = new JSONObject(this.episodeObjectWriter.writeValueAsString((Object)ep));
                episodes.put((Object)epJson);
            }
            show.put("episodes", (Object)episodes);
            LOGGER.info("Dumping TvShow:\n" + show.toString(4));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistTvShow(TvShow tvShow) throws Exception {
        String oldValue;
        String newValue = this.tvShowObjectWriter.writeValueAsString((Object)tvShow);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.tvShowMap.get((Object)tvShow.getDbId())))) {
            this.tvShowMap.put((Object)tvShow.getDbId(), (Object)newValue);
        }
    }

    void removeTvShowFromDb(TvShow tvShow) throws Exception {
        this.tvShowMap.remove((Object)tvShow.getDbId());
    }

    void persistEpisode(TvShowEpisode episode) throws Exception {
        String oldValue;
        String newValue = this.episodeObjectWriter.writeValueAsString((Object)episode);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.episodeMap.get((Object)episode.getDbId())))) {
            this.episodeMap.put((Object)episode.getDbId(), (Object)newValue);
        }
    }

    void removeEpisodeFromDb(TvShowEpisode episode) throws Exception {
        this.episodeMap.remove((Object)episode.getDbId());
    }

    @Override
    public void initializeDatabase() throws Exception {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB));
    }
}

