/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.ExpressionToken;
import java.util.Iterator;
import java.util.List;

public class ForEachToken
extends ExpressionToken {
    public static final String FOREACH = "foreach";
    private final String varName;
    private final String separator;
    private transient Iterator<Object> iterator;
    private transient int index;

    public ForEachToken(String expression, String varName, String separator) {
        super(expression);
        this.varName = varName;
        this.separator = separator != null ? separator : "";
        this.index = -1;
    }

    public ForEachToken(List<String> segments, String expression, String varName, String separator) {
        super(segments, expression);
        this.varName = varName;
        this.separator = separator != null ? separator : "";
        this.index = -1;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = "foreach " + this.getExpression() + " " + this.varName + (this.separator == null || this.separator.isEmpty() ? "" : " " + this.separator);
        }
        return this.text;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        Object value = this.evaluatePlain(context);
        return context.modelAdaptor.getIterable(value);
    }

    public Iterator<Object> iterator() {
        return this.getIterator();
    }

    public String getVarName() {
        return this.varName;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isLast() {
        return !this.iterator().hasNext();
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIterable(Iterable<Object> iterable) {
        this.iterator = iterable.iterator();
    }

    public void setIterator(Iterator<Object> iterator) {
        this.iterator = iterator;
    }

    public Iterator<Object> getIterator() {
        return this.iterator;
    }

    public Object advance() {
        ++this.index;
        return this.iterator.next();
    }

    public void resetIndex() {
        this.index = -1;
    }
}

