/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.config.MediaProviderConfigObject;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;

public class MediaScraperConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = -4120483383064864579L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private IMediaProvider mediaProvider;
    private boolean dirty = false;
    private JPanel configPanel;

    public MediaScraperConfigurationPanel(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
        this.setLayout(new BorderLayout());
        JPanel panelHead = new JPanel(new FlowLayout(0, 20, 0));
        this.add((Component)panelHead, "North");
        JLabel lblScraperOptions = new JLabel(BUNDLE.getString("Settings.scraper.options"));
        TmmFontHelper.changeFont(lblScraperOptions, 1.2f, 1);
        panelHead.add(lblScraperOptions);
        this.configPanel = this.createConfigPanel();
        this.add((Component)this.configPanel, "Center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (MediaScraperConfigurationPanel.this.dirty) {
                    MediaScraperConfigurationPanel.this.saveSettings();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    private JPanel createConfigPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0};
        gridBagLayout.columnWeights = new double[]{Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{Double.MIN_VALUE};
        panel.setLayout(gridBagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        MediaProviderConfig config = this.mediaProvider.getProviderInfo().getConfig();
        for (Map.Entry entry : config.getConfigObjects().entrySet()) {
            JComponent comp;
            if (!((MediaProviderConfigObject)entry.getValue()).isVisible()) continue;
            constraints.anchor = 21;
            constraints.ipadx = 20;
            JLabel label = new JLabel(((MediaProviderConfigObject)entry.getValue()).getKeyDescription());
            constraints.gridx = 0;
            panel.add((Component)label, constraints);
            switch (((MediaProviderConfigObject)entry.getValue()).getType()) {
                case BOOL: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(((MediaProviderConfigObject)entry.getValue()).getValueAsBool());
                    checkbox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }
                    });
                    comp = checkbox;
                    break;
                }
                case SELECT: 
                case SELECT_INDEX: {
                    JComboBox<String> combobox = new JComboBox<String>(((MediaProviderConfigObject)entry.getValue()).getPossibleValues().toArray(new String[0]));
                    combobox.setSelectedItem(((MediaProviderConfigObject)entry.getValue()).getValueAsString());
                    combobox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }
                    });
                    comp = combobox;
                    break;
                }
                default: {
                    JTextField tf = ((MediaProviderConfigObject)entry.getValue()).isEncrypt() ? new JPasswordField(config.getValue((String)entry.getKey())) : new JTextField(config.getValue((String)entry.getKey()));
                    tf.setPreferredSize(new Dimension(100, 24));
                    tf.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }
                    });
                    comp = tf;
                }
            }
            comp.putClientProperty(entry.getKey(), entry.getKey());
            constraints.ipadx = 0;
            constraints.gridx = 1;
            panel.add((Component)comp, constraints);
            try {
                String desc = BUNDLE.getString("scraper." + this.mediaProvider.getProviderInfo().getId() + "." + (String)entry.getKey() + ".desc");
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    JLabel lblHint = new JLabel(IconManager.HINT);
                    lblHint.setToolTipText(desc);
                    constraints.gridx = 2;
                    panel.add((Component)lblHint, constraints);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            ++constraints.gridy;
        }
        return panel;
    }

    private void saveSettings() {
        Map config = this.mediaProvider.getProviderInfo().getConfig().getConfigObjects();
        for (Map.Entry entry : config.entrySet()) {
            for (Component comp : this.configPanel.getComponents()) {
                Object param;
                if (!(comp instanceof JComponent) || (param = ((JComponent)comp).getClientProperty(entry.getKey())) == null || !((String)entry.getKey()).equals(param)) continue;
                try {
                    if (comp instanceof JCheckBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue((String)entry.getKey(), ((JCheckBox)comp).isSelected());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue((String)entry.getKey(), ((JComboBox)comp).getSelectedItem().toString());
                        continue;
                    }
                    this.mediaProvider.getProviderInfo().getConfig().setValue((String)entry.getKey(), ((JTextField)comp).getText());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        this.mediaProvider.getProviderInfo().getConfig().save();
    }
}

