/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.ui.UTF8Control;

public class MovieChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChooserModel.class);
    public static final MovieChooserModel emptyResult = new MovieChooserModel();
    private MediaScraper metadataProvider = null;
    private List<MediaScraper> artworkScrapers = null;
    private List<MediaScraper> trailerScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private String name = "";
    private String overview = "";
    private String year = "";
    private String combinedName = "";
    private String posterUrl = "";
    private String tagline = "";
    private boolean scraped = false;

    public MovieChooserModel(MediaScraper metadataProvider, List<MediaScraper> artworkScrapers, List<MediaScraper> trailerScrapers, MediaSearchResult result, MediaLanguages language) {
        this.metadataProvider = metadataProvider;
        this.artworkScrapers = artworkScrapers;
        this.trailerScrapers = trailerScrapers;
        this.result = result;
        this.language = language;
        this.setName(result.getTitle());
        if (result.getYear() != 0) {
            this.setYear(Integer.toString(result.getYear()));
        } else {
            this.setYear("");
        }
        this.setCombinedName();
    }

    private MovieChooserModel() {
        this.setName(BUNDLE.getString("chooser.nothingfound"));
        this.combinedName = this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = overview;
        this.firePropertyChange("overview", oldValue, overview);
    }

    public String getName() {
        return this.name;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = newValue;
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = StringUtils.isNotBlank((CharSequence)this.getYear()) ? this.getName() + " (" + this.getYear() + ")" : this.getName();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setResult(this.result);
            options.setLanguage(LocaleUtils.toLocale((String)this.language.name()));
            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
            LOGGER.info("=====================================================");
            LOGGER.info("Scraper metadata with scraper: " + this.metadataProvider.getMediaProvider().getProviderInfo().getId() + ", " + this.metadataProvider.getMediaProvider().getProviderInfo().getVersion());
            LOGGER.info(options.toString());
            LOGGER.info("=====================================================");
            this.metadata = ((IMovieMetadataProvider)this.metadataProvider.getMediaProvider()).getMetadata(options);
            this.setOverview(this.metadata.getPlot());
            this.setTagline(this.metadata.getTagline());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(((MediaArtwork)this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getPreviewUrl());
            }
            this.scraped = true;
        }
        catch (Exception e) {
            LOGGER.error("scrapeMedia", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    public String getTagline() {
        return this.tagline;
    }

    public void startArtworkScrapeTask(Movie movie, MovieScraperMetadataConfig config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(movie, config));
    }

    public void startTrailerScrapeTask(Movie movie) {
        TmmTaskManager.getInstance().addUnnamedTask(new TrailerScrapeTask(movie));
    }

    private class TrailerScrapeTask
    extends TmmTask {
        private Movie movieToScrape;

        public TrailerScrapeTask(Movie movie) {
            super(BUNDLE.getString("message.scrape.trailer") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            ArrayList<MovieTrailer> trailer = new ArrayList<MovieTrailer>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setMetadata(MovieChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieChooserModel.this.metadata.getId("tmdb"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(LocaleUtils.toLocale((String)MovieChooserModel.this.language.name()));
            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
            for (MediaScraper trailerScraper : MovieChooserModel.this.trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    List foundTrailers = trailerProvider.getTrailers(options);
                    for (MediaTrailer mediaTrailer : foundTrailers) {
                        MovieTrailer movieTrailer = new MovieTrailer(mediaTrailer);
                        trailer.add(movieTrailer);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            }
            for (MediaFile mf : this.movieToScrape.getMediaFiles(MediaFileType.TRAILER)) {
                LOGGER.debug("adding local trailer " + mf.getFilename());
                MovieTrailer mt = new MovieTrailer();
                mt.setName(mf.getFilename());
                mt.setProvider("downloaded");
                mt.setQuality(mf.getVideoFormat());
                mt.setInNfo(false);
                mt.setUrl(mf.getFile().toURI().toString());
                trailer.add(0, mt);
            }
            this.movieToScrape.setTrailers(trailer);
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private Movie movieToScrape;
        private MovieScraperMetadataConfig config;

        public ArtworkScrapeTask(Movie movie, MovieScraperMetadataConfig config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(MovieChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieChooserModel.this.metadata.getId("tmdb"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(LocaleUtils.toLocale((String)MovieChooserModel.this.language.name()));
            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
            options.setFanartSize(MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize());
            options.setPosterSize(MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize());
            for (MediaScraper artworkScraper : MovieChooserModel.this.artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (Exception e) {}
            }
            if (StringUtils.isNotBlank((CharSequence)MovieChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(MovieChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(MovieChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(MovieChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.movieToScrape.setArtwork(artwork, this.config);
        }
    }
}

