/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;

public class TmmProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmProperties.class);
    private static final String PROPERTIES_FILE = "tmm.prop";
    private static TmmProperties instance;
    private Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TmmProperties() {
        InputStream input = null;
        try {
            input = new FileInputStream(new File(Settings.getInstance().getSettingsFolder(), PROPERTIES_FILE));
            this.properties.load(input);
        }
        catch (FileNotFoundException ignored) {
        }
        catch (Exception e) {
            LOGGER.warn("unable to read properties file: " + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static synchronized TmmProperties getInstance() {
        if (instance == null) {
            instance = new TmmProperties();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties() {
        OutputStream output = null;
        try {
            output = new FileOutputStream(new File(Settings.getInstance().getSettingsFolder(), PROPERTIES_FILE));
            Properties tmp = new Properties(){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            tmp.putAll((Map<?, ?>)this.properties);
            tmp.store(output, null);
        }
        catch (IOException e) {
            LOGGER.warn("failed to store properties file: " + e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOGGER.warn("failed to store properties file: " + e.getMessage());
                }
            }
        }
    }

    public void putProperty(String key, String value) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        this.properties.put(key, value);
        this.writeProperties();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Boolean getPropertyAsBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Boolean.FALSE;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public Integer getPropertyAsInteger(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

