/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.map;

public class MapEntry<K, V>
implements Comparable<MapEntry<K, V>> {
    private final K key;
    private final V value;

    public MapEntry(K k, V v) {
        this.key = k;
        this.value = v;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public String toString() {
        return this.key() + ": " + this.value();
    }

    @Override
    public int compareTo(MapEntry<K, V> mapEntry) {
        if (this.key() instanceof Comparable) {
            return ((Comparable)this.key()).compareTo(mapEntry);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof MapEntry) {
            MapEntry mapEntry = (MapEntry)object;
            if (this.key() == null && this.value() == null && mapEntry.key == null && mapEntry.value == null) {
                return true;
            }
            if (this.key() == null && this.value() == null && (mapEntry.key != null || mapEntry.value != null)) {
                return false;
            }
            if (this.key() != null && this.value() == null) {
                if (mapEntry.value != null) {
                    return false;
                }
                return this.key().equals(mapEntry.key);
            }
            if (this.key() == null && this.value() != null) {
                if (mapEntry.key != null) {
                    return false;
                }
                return this.value().equals(mapEntry.value);
            }
            return this.key().equals(mapEntry.key) && this.value().equals(mapEntry.value);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.key() != null) {
            n = this.key().hashCode() * 13;
        }
        if (this.value() != null) {
            n += this.value().hashCode();
        }
        return n;
    }
}

