/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.util.Properties;
import java.util.logging.Logger;
import net.xeoh.plugins.base.PluginConfiguration;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Version;

@Author(name="Ralf Biedert")
@PluginImplementation
@Version(version=10000)
public class PluginConfigurationImpl
implements PluginConfiguration {
    final Properties configuration;
    final Logger logger = Logger.getLogger(this.getClass().getName());

    protected PluginConfigurationImpl(Properties initialProperties) {
        this.configuration = initialProperties;
    }

    @Override
    public synchronized String getConfiguration(Class<?> root, String subkey) {
        String key = this.getKey(root, subkey);
        String value = this.configuration.getProperty(key);
        this.logger.fine("Returning '" + value + "' for " + "'" + key + "'");
        return value;
    }

    @Override
    public synchronized void setConfiguration(Class<?> root, String subkey, String value) {
        String key = this.getKey(root, subkey);
        this.logger.fine("Setting '" + value + "' for " + "'" + key + "'");
        this.configuration.setProperty(key, value);
    }

    private String getKey(Class<?> root, String subkey) {
        String prefix = "";
        if (root != null) {
            prefix = root.getName() + ".";
        }
        this.logger.finer("Assembled key '" + prefix + subkey + "'");
        return prefix + subkey;
    }
}

