/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.japura.gui.CheckComboBox;
import org.japura.gui.model.ListCheckModel;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleDownloadTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowSubtitleChooserModel;

public class TvShowSubtitleChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowList tvShowList = TvShowList.getInstance();
    private final TvShowEpisode episodeToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private EventList<TvShowSubtitleChooserModel> subtitleEventList = null;
    private DefaultEventTableModel<TvShowSubtitleChooserModel> subtitleTableModel = null;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private JTable tableSubs;
    private JComboBox<MediaLanguages> cbLanguage;
    private CheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;

    public TvShowSubtitleChooserDialog(TvShowEpisode episode, MediaFile mediaFile, boolean inQueue) {
        super(BUNDLE.getString("tvshowepisodesubtitlechooser.search"), "episodeSubtitleChooser");
        this.setBounds(5, 5, 712, 429);
        this.episodeToScrape = episode;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowSubtitleChooserModel.class)));
        this.subtitleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), (TableFormat)new SubtitleTableFormat());
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        this.cbScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        ListCheckModel model = this.cbScraper.getModel();
        for (MediaScraper scraper : this.tvShowList.getAvailableSubtitleScrapers()) {
            model.addElement(new Object[]{scraper});
            if (!TvShowModuleManager.SETTINGS.getTvShowSubtitleScrapers().contains(scraper.getId())) continue;
            model.addCheck(new Object[]{scraper});
        }
        for (MediaLanguages language : MediaLanguages.values()) {
            this.cbLanguage.addItem(language);
            if (language != TvShowModuleManager.SETTINGS.getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem(language);
        }
        this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.episodeToScrape.getTvShow().getImdbId(), this.episodeToScrape.getSeason(), this.episodeToScrape.getEpisode());
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"120dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblEpisodeTitle = new JLabel(this.episodeToScrape.getTitle());
        TmmFontHelper.changeFont(lblEpisodeTitle, 1.33, 1);
        panelContent.add((Component)lblEpisodeTitle, "2, 2, 9, 1");
        JLabel lblSeasonT = new JLabel(BUNDLE.getString("metatag.season"));
        panelContent.add((Component)lblSeasonT, "2, 4, right, default");
        JLabel lblSeason = new JLabel(String.valueOf(this.episodeToScrape.getSeason()));
        panelContent.add((Component)lblSeason, "4, 4");
        JLabel lblEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        panelContent.add((Component)lblEpisodeT, "2, 6, right, default");
        JLabel lblEpisode = new JLabel(String.valueOf(this.episodeToScrape.getEpisode()));
        panelContent.add((Component)lblEpisode, "4, 6");
        JLabel lblMediaFileNameT = new JLabel(BUNDLE.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "2, 8, right, default");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFilename());
        panelContent.add((Component)lblMediaFileName, "4, 8, 7, 1");
        JLabel lblScraperT = new JLabel(BUNDLE.getString("scraper"));
        panelContent.add((Component)lblScraperT, "2, 10, right, default");
        this.cbScraper = new MediaScraperCheckComboBox();
        panelContent.add((Component)this.cbScraper, "4, 10, fill, default");
        JLabel lblLanguageT = new JLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "2, 12, right, default");
        this.cbLanguage = new JComboBox();
        panelContent.add(this.cbLanguage, "4, 12, fill, default");
        JButton btnSearch = new JButton(BUNDLE.getString("Button.search"));
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowSubtitleChooserDialog.this.searchSubtitle(TvShowSubtitleChooserDialog.this.fileToScrape.getFileAsPath().toFile(), TvShowSubtitleChooserDialog.this.episodeToScrape.getTvShow().getImdbId(), TvShowSubtitleChooserDialog.this.episodeToScrape.getSeason(), TvShowSubtitleChooserDialog.this.episodeToScrape.getEpisode());
            }
        });
        panelContent.add((Component)btnSearch, "8, 12");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "2, 14, 9, 1, fill, fill");
        this.tableSubs = new JTable((TableModel)this.subtitleTableModel);
        scrollPaneSubs.setViewportView(this.tableSubs);
        JPanel panelBottom = new JPanel();
        this.getContentPane().add((Component)panelBottom, "South");
        panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"max(82dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        panelBottom.add((Component)this.progressBar, "2, 2");
        this.lblProgressAction = new JLabel("");
        panelBottom.add((Component)this.lblProgressAction, "4, 2");
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelBottom.add((Component)panelButtons, "5, 2, fill, fill");
        JButton btnDone = new JButton(BUNDLE.getString("Button.done"));
        btnDone.setIcon(IconManager.APPLY);
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowSubtitleChooserDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnDone);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.PROCESS_STOP);
            btnAbortQueue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TvShowSubtitleChooserDialog.this.continueQueue = false;
                    TvShowSubtitleChooserDialog.this.setVisible(false);
                }
            });
            panelButtons.add(btnAbortQueue);
        }
    }

    private void searchSubtitle(File file, String imdbId, int season, int episode) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>();
        ListCheckModel model = this.cbScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            scrapers.add((MediaScraper)checked);
        }
        this.activeSearchTask = new SearchTask(file, imdbId, season, episode, scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(final String description) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TvShowSubtitleChooserDialog.this.lblProgressAction.setText(description);
                TvShowSubtitleChooserDialog.this.progressBar.setVisible(true);
                TvShowSubtitleChooserDialog.this.progressBar.setIndeterminate(true);
            }
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TvShowSubtitleChooserDialog.this.lblProgressAction.setText("");
                TvShowSubtitleChooserDialog.this.progressBar.setVisible(false);
                TvShowSubtitleChooserDialog.this.progressBar.setIndeterminate(false);
            }
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                TvShowSubtitleChooserModel model = (TvShowSubtitleChooserModel)TvShowSubtitleChooserDialog.this.subtitleEventList.get(row);
                if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                    String filename = FilenameUtils.getBaseName((String)TvShowSubtitleChooserDialog.this.fileToScrape.getFilename()) + "." + model.getLanguage().name();
                    TvShowSubtitleDownloadTask task = new TvShowSubtitleDownloadTask(model.getDownloadUrl(), TvShowSubtitleChooserDialog.this.episodeToScrape.getPathNIO().resolve(filename), TvShowSubtitleChooserDialog.this.episodeToScrape);
                    TmmTaskManager.getInstance().addDownloadTask(task);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class SubtitleTableFormat
    implements AdvancedTableFormat<TvShowSubtitleChooserModel> {
        private SubtitleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.releasename");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowSubtitleChooserModel model, int column) {
            switch (column) {
                case 0: {
                    return IconManager.DOWNLOAD;
                }
                case 1: {
                    return model.getName();
                }
                case 2: {
                    return model.getReleaseName();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private File file;
        private int season;
        private int episode;
        private String imdbId;
        private List<SubtitleSearchResult> searchResults;
        private MediaLanguages language;
        private List<MediaScraper> scrapers;
        boolean cancel;

        SearchTask(File file, String imdbId, int season, int episode, List<MediaScraper> scrapers) {
            this.file = file;
            this.season = season;
            this.episode = episode;
            this.imdbId = imdbId;
            this.language = (MediaLanguages)TvShowSubtitleChooserDialog.this.cbLanguage.getSelectedItem();
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            TvShowSubtitleChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + TvShowSubtitleChooserDialog.this.episodeToScrape.getTitle());
            for (MediaScraper scraper : this.scrapers) {
                try {
                    IMediaSubtitleProvider subtitleProvider = (IMediaSubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchOptions options = new SubtitleSearchOptions(this.file);
                    options.setImdbId(this.imdbId);
                    options.setLanguage(LocaleUtils.toLocale((String)this.language.name()));
                    options.setSeason(this.season);
                    options.setEpisode(this.episode);
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (Exception exception) {}
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                TvShowSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.size() == 0) {
                    TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)TvShowSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)new TvShowSubtitleChooserModel(result, this.language));
                    }
                }
                if (!TvShowSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    TvShowSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(TvShowSubtitleChooserDialog.this.tableSubs, 7);
            }
            TvShowSubtitleChooserDialog.this.stopProgressBar();
        }
    }
}

