/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8Control
extends ResourceBundle.Control {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (format.equals("java.class")) {
            try {
                Class<?> bundleClass = loader.loadClass(bundleName);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.newInstance();
            }
            catch (ClassNotFoundException e) {}
        } else if (format.equals("java.properties")) {
            final String resourceName = this.toResourceName0(bundleName, "properties");
            if (resourceName == null) {
                return bundle;
            }
            final ClassLoader classLoader = loader;
            final boolean reloadFlag = reload;
            InputStream stream = null;
            try {
                stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        InputStream is = null;
                        if (reloadFlag) {
                            URLConnection connection;
                            URL url = classLoader.getResource(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                        } else {
                            is = classLoader.getResourceAsStream(resourceName);
                        }
                        return is;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            if (stream == null) {
                try {
                    stream = new FileInputStream(new File("locale", resourceName));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private String toResourceName0(String bundleName, String suffix) {
        if (bundleName.contains("://")) {
            return null;
        }
        return this.toResourceName(bundleName, suffix);
    }
}

