/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.transport.spi.UpnpStream;
import org.seamless.util.Exceptions;
import org.seamless.util.io.IO;

public abstract class AsyncServletUpnpStream
extends UpnpStream
implements AsyncListener {
    private static final Logger log = Logger.getLogger(UpnpStream.class.getName());
    protected final AsyncContext asyncContext;
    protected final HttpServletRequest request;
    protected StreamResponseMessage responseMessage;

    public AsyncServletUpnpStream(ProtocolFactory protocolFactory, AsyncContext asyncContext, HttpServletRequest request) {
        super(protocolFactory);
        this.asyncContext = asyncContext;
        this.request = request;
        asyncContext.addListener((AsyncListener)this);
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    protected HttpServletResponse getResponse() {
        ServletResponse response = this.asyncContext.getResponse();
        if (response == null) {
            throw new IllegalStateException("Couldn't get response from asynchronous context, already timed out");
        }
        return (HttpServletResponse)response;
    }

    protected void complete() {
        try {
            this.asyncContext.complete();
        }
        catch (IllegalStateException ex) {
            log.info("Error calling servlet container's AsyncContext#complete() method: " + ex);
        }
    }

    @Override
    public void run() {
        try {
            StreamRequestMessage requestMessage = this.readRequestMessage();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Processing new request message: " + requestMessage);
            }
            this.responseMessage = this.process(requestMessage);
            if (this.responseMessage != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Preparing HTTP response message: " + this.responseMessage);
                }
                this.writeResponseMessage(this.responseMessage);
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Sending HTTP response status: 404");
                }
                this.getResponse().setStatus(404);
            }
        }
        catch (Throwable t) {
            log.info("Exception occurred during UPnP stream processing: " + t);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Cause: " + Exceptions.unwrap((Throwable)t), Exceptions.unwrap((Throwable)t));
            }
            if (!this.getResponse().isCommitted()) {
                log.finer("Response hasn't been committed, returning INTERNAL SERVER ERROR to client");
                this.getResponse().setStatus(500);
            } else {
                log.info("Could not return INTERNAL SERVER ERROR to client, response was already committed");
            }
            this.responseException(t);
        }
        finally {
            this.complete();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onComplete(AsyncEvent event) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Completed asynchronous processing of HTTP request: " + event.getSuppliedRequest());
        }
        this.responseSent(this.responseMessage);
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Asynchronous processing of HTTP request timed out: " + event.getSuppliedRequest());
        }
        this.responseException(new Exception("Asynchronous request timed out"));
    }

    public void onError(AsyncEvent event) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Asynchronous processing of HTTP request error: " + event.getThrowable());
        }
        this.responseException(event.getThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamRequestMessage readRequestMessage() throws IOException {
        byte[] bodyBytes;
        StreamRequestMessage requestMessage;
        String requestMethod = this.getRequest().getMethod();
        String requestURI = this.getRequest().getRequestURI();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Processing HTTP request: " + requestMethod + " " + requestURI);
        }
        try {
            requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Invalid request URI: " + requestURI, ex);
        }
        if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
            throw new RuntimeException("Method not supported: " + requestMethod);
        }
        requestMessage.setConnection(this.createConnection());
        UpnpHeaders headers = new UpnpHeaders();
        Enumeration headerNames = this.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = this.getRequest().getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                headers.add(headerName, headerValue);
            }
        }
        requestMessage.setHeaders(headers);
        try (ServletInputStream is = null;){
            is = this.getRequest().getInputStream();
            bodyBytes = IO.readBytes((InputStream)is);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Reading request body bytes: " + bodyBytes.length);
        }
        if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Request contains textual entity body, converting then setting string on message");
            }
            requestMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes.length > 0) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Request contains binary entity body, setting bytes on message");
            }
            requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("Request did not contain entity body");
        }
        return requestMessage;
    }

    protected void writeResponseMessage(StreamResponseMessage responseMessage) throws IOException {
        int contentLength;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Sending HTTP response status: " + ((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        }
        this.getResponse().setStatus(((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        for (Map.Entry entry : responseMessage.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.getResponse().addHeader((String)entry.getKey(), value);
            }
        }
        this.getResponse().setDateHeader("Date", System.currentTimeMillis());
        byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
        int n = contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
        if (contentLength > 0) {
            this.getResponse().setContentLength(contentLength);
            log.finer("Response message has body, writing bytes to stream...");
            IO.writeBytes((OutputStream)this.getResponse().getOutputStream(), (byte[])responseBodyBytes);
        }
    }

    protected abstract Connection createConnection();
}

