/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.gena;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.header.CallbackHeader;
import org.fourthline.cling.model.message.header.NTEventHeader;
import org.fourthline.cling.model.message.header.TimeoutHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class OutgoingSubscribeRequestMessage
extends StreamRequestMessage {
    public OutgoingSubscribeRequestMessage(RemoteGENASubscription subscription, List<URL> callbackURLs, UpnpHeaders extraHeaders) {
        super(UpnpRequest.Method.SUBSCRIBE, subscription.getEventSubscriptionURL());
        this.getHeaders().add(UpnpHeader.Type.CALLBACK, new CallbackHeader(callbackURLs));
        this.getHeaders().add(UpnpHeader.Type.NT, new NTEventHeader());
        this.getHeaders().add(UpnpHeader.Type.TIMEOUT, new TimeoutHeader(subscription.getRequestedDurationSeconds()));
        if (extraHeaders != null) {
            this.getHeaders().putAll((Map)((Object)extraHeaders));
        }
    }

    public boolean hasCallbackURLs() {
        CallbackHeader callbackHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.CALLBACK, CallbackHeader.class);
        return ((List)callbackHeader.getValue()).size() > 0;
    }
}

